/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.util.List;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_I_ProductPlanning;
import org.compiere.model.MColumn;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.manufacturing.model.MPPProductPlanning;

public class ImportProductPlanning
extends SvrProcess {
    private boolean isImported = false;
    private boolean p_DeleteOldImported = false;
    private boolean p_IsImportOnlyNoErrors = true;
    private int imported = 0;
    private int notimported = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] paramaters;
        for (ProcessInfoParameter para : paramaters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsImportOnlyNoErrors")) {
                this.p_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(para.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_DeleteOldImported) {
            int no = 0;
            for (X_I_ProductPlanning ipp : this.getRecords(true, false)) {
                ipp.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported + ", Not imported: " + this.notimported;
    }

    private void importRecords() {
        for (X_I_ProductPlanning ipp : this.getRecords(false, this.p_IsImportOnlyNoErrors)) {
            this.isImported = false;
            MPPProductPlanning pp = this.importProductPlanning(ipp);
            if (pp == null) {
                this.isImported = false;
            }
            if (this.isImported) {
                ipp.setPP_Product_Planning_ID(pp.getPP_Product_Planning_ID());
                ipp.setI_IsImported(true);
                ipp.setProcessed(true);
                ipp.setI_ErrorMsg("");
                ipp.saveEx();
                ++this.imported;
                continue;
            }
            ipp.setI_IsImported(false);
            ipp.setProcessed(true);
            ipp.saveEx();
            ++this.notimported;
        }
    }

    private MPPProductPlanning importProductPlanning(X_I_ProductPlanning ipp) {
        try {
            MPPProductPlanning pp = null;
            pp = ipp.getPP_Product_Planning_ID() > 0 ? new MPPProductPlanning(this.getCtx(), ipp.getPP_Product_Planning_ID(), this.get_TrxName()) : MPPProductPlanning.get(this.getCtx(), ipp.getAD_Client_ID(), ipp.getAD_Org_ID(), ipp.getM_Warehouse_ID(), ipp.getS_Resource_ID(), ipp.getM_Product_ID(), this.get_TrxName());
            if (pp == null || pp.get_ID() <= 0) {
                pp = new MPPProductPlanning(Env.getCtx(), 0, this.get_TrxName());
                pp.setAD_Org_ID(ipp.getAD_Org_ID());
                pp.setM_Product_ID(ipp.getM_Product_ID());
                pp.setS_Resource_ID(ipp.getS_Resource_ID());
                pp.setM_Warehouse_ID(ipp.getM_Warehouse_ID());
                pp.setIsRequiredDRP(false);
                pp.setIsRequiredMRP(false);
            }
            this.fillValue(pp, ipp);
            if (ipp.getC_BPartner_ID() > 0 && ipp.getVendorProductNo() != null) {
                this.importPurchaseProductPlanning(ipp);
            }
            pp.saveEx();
            this.isImported = true;
            return pp;
        }
        catch (Exception e) {
            ipp.setI_ErrorMsg(e.getMessage());
            this.isImported = false;
            return null;
        }
    }

    private void importPurchaseProductPlanning(X_I_ProductPlanning ipp) {
        MProduct product = MProduct.get(this.getCtx(), ipp.getM_Product_ID());
        if (product.isPurchased()) {
            StringBuffer whereClause = new StringBuffer();
            whereClause.append("M_Product_ID").append("=? AND ");
            whereClause.append("C_BPartner_ID").append("=?");
            MProductPO productPO = (MProductPO)new Query(this.getCtx(), "M_Product_PO", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(ipp.getM_Product_ID(), ipp.getC_BPartner_ID()).first();
            if (productPO == null) {
                productPO = new MProductPO(this.getCtx(), 0, this.get_TrxName());
                productPO.setM_Product_ID(ipp.getM_Product_ID());
                productPO.setC_BPartner_ID(ipp.getC_BPartner_ID());
            }
            productPO.setAD_Org_ID(ipp.getAD_Org_ID());
            productPO.setOrder_Min(ipp.getOrder_Min());
            productPO.setOrder_Pack(ipp.getOrder_Pack());
            productPO.setDeliveryTime_Promised(ipp.getDeliveryTime_Promised().intValue());
            productPO.setVendorProductNo(ipp.getVendorProductNo());
            productPO.saveEx();
        }
    }

    private void fillValue(MPPProductPlanning pp, X_I_ProductPlanning ipp) {
        for (MColumn col : this.getProductPlanningColumns()) {
            if (!pp.is_new() && !col.isUpdateable() && ipp.get_ColumnIndex(col.getColumnName()) > 0 || "IsRequiredDRP".equals(col.getColumnName()) || "IsRequiredMRP".equals(col.getColumnName()) || "PP_Product_Planning_ID".equals(col.getColumnName()) || ipp.get_Value(col.getColumnName()) != null && pp.get_Value(col.getColumnName()) != null && pp.get_Value(col.getColumnName()).equals(ipp.get_Value(col.getColumnName()))) continue;
            pp.set_ValueOfColumn(col.getColumnName(), ipp.get_Value(col.getColumnName()));
        }
        this.isImported = true;
    }

    private MColumn[] getProductPlanningColumns() {
        return MTable.get(this.getCtx(), "PP_Product_Planning").getColumns(false);
    }

    private void fillIDValues() {
        for (X_I_ProductPlanning ppi : this.getRecords(false, this.p_IsImportOnlyNoErrors)) {
            int AD_Org_ID = 0;
            if (ppi.getAD_Org_ID() > 0) {
                AD_Org_ID = this.getID("AD_Org", "AD_Org_ID = ?", ppi.getAD_Org_ID());
            }
            if (AD_Org_ID <= 0 && ppi.getOrgValue() != null) {
                AD_Org_ID = this.getID("AD_Org", "Value = ?", ppi.getOrgValue());
                ppi.setAD_Org_ID(AD_Org_ID);
            } else {
                ppi.setAD_Org_ID(AD_Org_ID);
            }
            int C_BPartner_ID = 0;
            if (ppi.getC_BPartner_ID() == 0) {
                C_BPartner_ID = this.getID("C_BPartner", "C_BPartner_ID=?", ppi.getC_BPartner_ID());
            }
            if (C_BPartner_ID <= 0 && ppi.getBPartner_Value() != null) {
                C_BPartner_ID = this.getID("C_BPartner", "Value=?", ppi.getBPartner_Value());
                ppi.setC_BPartner_ID(C_BPartner_ID);
            } else {
                ppi.setC_BPartner_ID(C_BPartner_ID);
            }
            int M_Product_ID = 0;
            if (ppi.getM_Product_ID() > 0) {
                M_Product_ID = this.getID("M_Product", "M_Product_ID = ?", ppi.getM_Product_ID());
            }
            if (M_Product_ID <= 0 && ppi.getProductValue() != null) {
                M_Product_ID = this.getID("M_Product", "Value = ?", ppi.getProductValue());
                ppi.setM_Product_ID(M_Product_ID);
            } else {
                ppi.setM_Product_ID(M_Product_ID);
            }
            int M_Warehouse_ID = 0;
            if (ppi.getM_Warehouse_ID() > 0) {
                M_Warehouse_ID = this.getID("M_Warehouse", "M_Warehouse_ID = ?", ppi.getM_Warehouse_ID());
            }
            if (M_Warehouse_ID <= 0 && ppi.getWarehouseValue() != null) {
                M_Warehouse_ID = this.getID("M_Warehouse", "Value = ?", ppi.getWarehouseValue());
                ppi.setM_Warehouse_ID(M_Warehouse_ID);
            } else {
                ppi.setM_Warehouse_ID(M_Warehouse_ID);
            }
            int DD_NetworkDistribution_ID = 0;
            if (ppi.getDD_NetworkDistribution_ID() > 0) {
                DD_NetworkDistribution_ID = this.getID("DD_NetworkDistribution", "DD_NetworkDistribution_ID = ?", ppi.getDD_NetworkDistribution_ID());
            }
            if (DD_NetworkDistribution_ID <= 0 && ppi.getNetworkDistributionValue() != null) {
                DD_NetworkDistribution_ID = this.getID("DD_NetworkDistribution", "Value= ?", ppi.getNetworkDistributionValue());
                ppi.setDD_NetworkDistribution_ID(DD_NetworkDistribution_ID);
            } else {
                ppi.setDD_NetworkDistribution_ID(DD_NetworkDistribution_ID);
            }
            int PP_Product_BOM_ID = 0;
            if (ppi.getPP_Product_BOM_ID() > 0) {
                PP_Product_BOM_ID = this.getID("PP_Product_BOM", "PP_Product_BOM_ID= ?", ppi.getPP_Product_BOM_ID());
            }
            if (PP_Product_BOM_ID <= 0 && ppi.getProduct_BOM_Value() != null) {
                PP_Product_BOM_ID = this.getID("PP_Product_BOM", "Value= ?", ppi.getProduct_BOM_Value());
                ppi.setPP_Product_BOM_ID(PP_Product_BOM_ID);
            } else {
                ppi.setPP_Product_BOM_ID(PP_Product_BOM_ID);
            }
            int S_Resource_ID = 0;
            if (ppi.getS_Resource_ID() > 0) {
                S_Resource_ID = this.getID("S_Resource", "S_Resource_ID= ?", ppi.getS_Resource_ID());
            }
            if (S_Resource_ID <= 0 && ppi.getResourceValue() != null) {
                S_Resource_ID = this.getID("S_Resource", "Value=? AND ManufacturingResourceType=?", ppi.getResourceValue(), "PT");
                ppi.setS_Resource_ID(S_Resource_ID);
            } else {
                ppi.setS_Resource_ID(S_Resource_ID);
            }
            ppi.saveEx();
            StringBuffer err = new StringBuffer("");
            if (ppi.getAD_Org_ID() <= 0) {
                err.append(" @AD_Org_ID@ @NotFound@,");
            }
            if (ppi.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (err.toString() == null || err.toString().length() <= 0) continue;
            ++this.notimported;
            ppi.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), err.toString()));
            ppi.saveEx();
        }
    }

    private int getID(String tableName, String whereClause, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setParameters(parameters).firstId();
    }

    private List<X_I_ProductPlanning> getRecords(boolean imported, boolean isWithError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_ProductPlanning", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(imported).list();
    }
}

