/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.core.domains.models.X_I_Movement;
import org.compiere.model.MColumn;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.manufacturing.process.ImportInventoryMoveAbstract;

public class ImportInventoryMove
extends ImportInventoryMoveAbstract {
    private boolean isImported = false;
    private int imported = 0;
    private int notImported = 0;
    private LinkedHashMap<Integer, MMovement> movementProcessed = new LinkedHashMap();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            int no = 0;
            for (X_I_Movement movement : this.getRecords(true, false)) {
                movement.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "@I_IsImported@: " + this.imported + ", @I_ErrorMsg@ : " + this.notImported;
    }

    private void importRecords() {
        this.isImported = false;
        for (X_I_Movement movementImport : this.getRecords(false, this.isImportOnlyNoErrors())) {
            MMovement movement = this.importInventoryMovement(movementImport);
            this.isImported = movement != null ? this.importInventoryMovementLine(movement, movementImport) : false;
            if (this.isImported) {
                movementImport.setM_Movement_ID(movement.getM_Movement_ID());
                movementImport.setI_IsImported(true);
                movementImport.setProcessed(true);
                movementImport.saveEx();
                movement.saveEx();
                ++this.imported;
                this.addMovementToProcess(movement);
                continue;
            }
            movementImport.setI_IsImported(false);
            movementImport.setProcessed(true);
            movementImport.saveEx();
            ++this.notImported;
        }
        this.processAll();
    }

    private void addMovementToProcess(MMovement movement) {
        this.movementProcessed.put(movement.get_ID(), movement);
    }

    private void processAll() {
        for (Map.Entry<Integer, MMovement> entry : this.movementProcessed.entrySet()) {
            MMovement movement = entry.getValue();
            movement.processIt(this.getDocAction());
            movement.saveEx();
        }
    }

    private boolean importInventoryMovementLine(MMovement movement, X_I_Movement movementImport) {
        this.isImported = false;
        MMovementLine movementLine = this.getInventoryMovementLine(movement, movementImport);
        if (movementLine == null) {
            movementLine = new MMovementLine(Env.getCtx(), 0, this.get_TrxName());
        }
        try {
            movementLine.setM_Movement_ID(movement.getM_Movement_ID());
            movementLine.setAD_Org_ID(movementImport.getAD_Org_ID());
            movementLine.setM_Product_ID(movementImport.getM_Product_ID());
            movementLine.setM_Locator_ID(movementImport.getM_Locator_ID());
            movementLine.setM_LocatorTo_ID(movementImport.getM_LocatorTo_ID());
            movementLine.setMovementQty(movementLine.getMovementQty().add(movementImport.getMovementQty()));
            movementLine.saveEx();
            movementImport.setM_MovementLine_ID(movementLine.getM_MovementLine_ID());
            movementImport.saveEx();
            this.isImported = true;
        }
        catch (Exception e) {
            movementImport.setI_ErrorMsg(e.getMessage());
            this.isImported = false;
        }
        return this.isImported;
    }

    private MMovementLine getInventoryMovementLine(MMovement movement, X_I_Movement movementImport) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        MColumn[] columns = this.getInventoryMovementColumns();
        int count = 0;
        for (MColumn column : columns) {
            if (!"AD_Org_ID".equals(column.getColumnName()) && !"M_Product_ID".equals(column.getColumnName()) && !"M_Locator_ID".equals(column.getColumnName()) && !"M_LocatorTo_ID".equals(column.getColumnName())) continue;
            whereClause.append(column.getColumnName()).append("=?");
            parameters.add(movementImport.get_Value(column.getColumnName()));
            if (count >= 3) continue;
            whereClause.append(" AND ");
            ++count;
        }
        whereClause.append(" AND M_Movement_ID=?");
        parameters.add(movement.getM_Movement_ID());
        return (MMovementLine)new Query(this.getCtx(), "M_MovementLine", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).first();
    }

    private MColumn[] getInventoryMovementColumns() {
        return MTable.get(this.getCtx(), "M_MovementLine").getColumns(false);
    }

    private MMovement importInventoryMovement(X_I_Movement movementImport) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("TRUNC(").append("MovementDate").append(",'DD') = " + DB.TO_DATE(movementImport.getMovementDate()) + " AND ").append("DocumentNo").append("=? AND ").append("C_DocType_ID").append("=?");
        int movementId = new Query(Env.getCtx(), "M_Movement", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(movementImport.getDocumentNo(), movementImport.getC_DocType_ID()).firstId();
        MMovement movement = null;
        if (movementId <= 0) {
            movementId = 0;
        }
        movement = new MMovement(this.getCtx(), movementId, this.get_TrxName());
        try {
            movement.setDocumentNo(movementImport.getDocumentNo());
            movement.setC_DocType_ID(movementImport.getC_DocType_ID());
            movement.setAD_Org_ID(movementImport.getAD_Org_ID());
            movement.setMovementDate(movementImport.getMovementDate());
            movement.setC_DocType_ID(movementImport.getC_DocType_ID());
            movement.setDocumentNo(movementImport.getDocumentNo());
            movement.setC_BPartner_ID(movementImport.getC_BPartner_ID());
            movement.setM_Shipper_ID(movementImport.getM_Shipper_ID());
            movement.setC_Project_ID(movementImport.getC_Project_ID());
            movement.setC_Campaign_ID(movementImport.getC_Campaign_ID());
            movement.setAD_OrgTrx_ID(movementImport.getAD_OrgTrx_ID());
            movement.saveEx();
        }
        catch (Exception e) {
            movementImport.setI_ErrorMsg(e.getMessage());
            this.isImported = false;
        }
        return movement;
    }

    private void fillIDValues() {
        for (X_I_Movement movementImport : this.getRecords(false, this.isImportOnlyNoErrors())) {
            movementImport.setAD_Org_ID(this.getID("AD_Org", "Value = ?", new Object[]{movementImport.getOrgValue()}));
            if (movementImport.getM_Product_ID() == 0) {
                movementImport.setM_Product_ID(this.getID("M_Product", "Value = ?", new Object[]{movementImport.getProductValue()}));
            }
            movementImport.setM_Locator_ID(this.getID("M_Locator", "Value = ?", new Object[]{movementImport.getLocatorValue()}));
            movementImport.setM_LocatorTo_ID(this.getID("M_Locator", "Value = ?", new Object[]{movementImport.getLocatorToValue()}));
            if (movementImport.getC_DocType_ID() == 0) {
                movementImport.setC_DocType_ID(this.getID("C_DocType", "Name=?", new Object[]{movementImport.getDocTypeName()}));
            }
            if (movementImport.getC_BPartner_ID() == 0) {
                movementImport.setC_BPartner_ID(this.getID("C_BPartner", "Value =?", new Object[]{movementImport.getBPartnerValue()}));
            }
            if (movementImport.getM_Shipper_ID() == 0) {
                movementImport.setM_Shipper_ID(this.getID("M_Shipper", "Name = ?", new Object[]{movementImport.getShipperName()}));
            }
            if (movementImport.getC_Project_ID() == 0) {
                movementImport.setC_Project_ID(this.getID("C_Project", "Value = ?", new Object[]{movementImport.getProjectValue()}));
            }
            if (movementImport.getC_Campaign_ID() == 0) {
                movementImport.setC_Campaign_ID(this.getID("C_Campaign", "Value = ?", new Object[]{movementImport.getCampaignValue()}));
            }
            if (movementImport.getAD_OrgTrx_ID() == 0) {
                movementImport.setAD_OrgTrx_ID(this.getID("AD_Org", "Value = ?", new Object[]{movementImport.getOrgTrxValue()}));
            }
            movementImport.saveEx();
            StringBuilder err = new StringBuilder("");
            if (movementImport.getAD_Org_ID() <= 0) {
                err.append(" @AD_Org_ID@ @NotFound@,");
            }
            if (movementImport.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (movementImport.getM_Locator_ID() <= 0) {
                err.append(" @M_Locator_ID@ @NotFound@,");
            }
            if (movementImport.getM_LocatorTo_ID() <= 0) {
                err.append(" @M_LocatorTo_ID@ @NotFound@,");
            }
            if (movementImport.getC_DocType_ID() <= 0) {
                err.append(" @C_DocType_ID@ @NotFound@,");
            }
            if (err.toString() == null || err.toString().length() <= 0) continue;
            ++this.notImported;
            movementImport.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), err.toString()));
            movementImport.saveEx();
        }
    }

    private int getID(String tableName, String whereClause, Object[] values) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setClient_ID().setParameters(values).firstId();
    }

    private List<X_I_Movement> getRecords(boolean isImported, boolean isWithError) {
        StringBuilder whereClause = new StringBuilder("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_Movement", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(isImported).list();
    }
}

