/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MForecast;
import org.compiere.model.MSequence;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.manufacturing.model.MPPForecastRun;

public class GenerateForecast
extends SvrProcess {
    private int p_M_Forecast_ID;
    private int p_PP_ForecastRun_ID;
    private Timestamp p_StartDate;
    private Timestamp p_EndDate;
    private String p_ForecastActionType;
    private String p_ForecastLoadType;
    private int p_DaysAfterDue;
    private int p_M_Product_ID;
    private int p_M_Product_Category_ID;
    private int p_M_Product_Classification_ID;
    private int p_M_Product_Class_ID;
    private int p_M_Product_Group_ID;
    private int p_SalesRep_ID;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("M_Forecast_ID")) {
                this.p_M_Forecast_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("PP_ForecastRun_ID")) {
                this.p_PP_ForecastRun_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("DatePromised")) {
                this.p_StartDate = (Timestamp)para.getParameter();
                this.p_EndDate = (Timestamp)para.getParameter_To();
                continue;
            }
            if (name.equals("ForecastActionType")) {
                this.p_ForecastActionType = (String)para.getParameter();
                continue;
            }
            if (name.equals("ForecastLoadType")) {
                this.p_ForecastLoadType = (String)para.getParameter();
                continue;
            }
            if (name.equals("DaysAfterDue")) {
                this.p_DaysAfterDue = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Classification_ID")) {
                this.p_M_Product_Classification_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Class_ID")) {
                this.p_M_Product_Class_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Group_ID")) {
                this.p_M_Product_Group_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("SalesRep_ID")) {
                this.p_SalesRep_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        MForecast forecast = new MForecast(this.getCtx(), this.p_M_Forecast_ID, this.get_TrxName());
        MPPForecastRun fr = new MPPForecastRun(this.getCtx(), this.p_PP_ForecastRun_ID, this.get_TrxName());
        if (fr.getAD_Org_ID() != forecast.getAD_Org_ID()) {
            throw new AdempiereException("@AD_Org_ID@  @NotMatched@ @M_Forecast_ID@");
        }
        if (fr.getPP_Calendar_ID() != forecast.getPP_Calendar_ID()) {
            throw new AdempiereException("@PP_Calendar_ID@  @NotMatched@ @M_Forecast_ID@");
        }
        if (fr.getPP_PeriodDefinition_ID() != forecast.getPP_PeriodDefinition_ID()) {
            throw new AdempiereException("@PP_PeriodDefinition_ID@ @NotMatched@ @M_Forecast_ID@");
        }
        StringBuilder result = new StringBuilder();
        int deletedRecord = 0;
        int updatedRecord = 0;
        int createdRecord = 0;
        if (this.p_SalesRep_ID <= 0) {
            this.p_SalesRep_ID = Env.getAD_User_ID(this.getCtx());
        }
        if ("R".equals(this.p_ForecastActionType)) {
            deletedRecord = this.deleteData();
            createdRecord = this.insertForecast();
        } else if ("M".equals(this.p_ForecastActionType)) {
            updatedRecord = this.updateForecast();
            createdRecord = this.insertForecast();
        }
        String desc = fr.getDocumentNo() + " " + fr.getDescription();
        forecast.setDescription(forecast.getDescription() != null ? forecast.getDescription() + " " + desc : desc);
        forecast.saveEx();
        fr.setProcessed(true);
        fr.saveEx();
        result.append("@M_Forecast_ID@ # @Deleted@ = ").append(deletedRecord).append(" @Updated@ = ").append(updatedRecord).append(" @Created@ = ").append(createdRecord);
        return result.toString();
    }

    private int insertForecast() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO ").append("M_ForecastLine").append(" (");
        insert.append("M_ForecastLine_ID").append(",");
        insert.append("M_Forecast_ID").append(",");
        insert.append("AD_Client_ID").append(",");
        insert.append("AD_Org_ID").append(",");
        insert.append("M_Warehouse_ID").append(",");
        insert.append("M_Product_ID").append(",");
        insert.append("QtyCalculated").append(",");
        insert.append("Qty").append(",");
        insert.append("DatePromised").append(",");
        insert.append("PP_Period_ID").append(",");
        insert.append("SalesRep_ID").append(",");
        insert.append("Created").append(",");
        insert.append("CreatedBy").append(",");
        insert.append("Updated").append(",");
        insert.append("UpdatedBy").append(")");
        insert.append(" SELECT ");
        insert.append("nextidfunc(").append(MSequence.get(this.getCtx(), "M_ForecastLine").get_ID()).append(",'N')").append(",");
        insert.append(this.p_M_Forecast_ID).append(",");
        insert.append("frm.AD_Client_ID,");
        insert.append("frm.AD_Org_ID,");
        insert.append("frm.M_Warehouse_ID,");
        insert.append("frm.M_Product_ID,");
        insert.append("frr.QtyCalculated,");
        insert.append("NVL(frr.QtyPlan,0) + NVL(frr.QtyAbnormal,0),");
        if (this.p_ForecastLoadType.equals("S")) {
            insert.append("adddays(fp.StartDate,").append(this.p_DaysAfterDue).append("),");
        }
        if (this.p_ForecastLoadType.equals("E")) {
            insert.append("adddays(fp.EndDate,").append(this.p_DaysAfterDue).append("),");
        }
        insert.append("frr.PP_Period_ID,");
        insert.append(this.p_SalesRep_ID).append(",");
        insert.append("SYSDATE").append(",");
        insert.append(Env.getAD_User_ID(this.getCtx())).append(",");
        insert.append("SYSDATE").append(",");
        insert.append(Env.getAD_User_ID(this.getCtx()));
        insert.append(" FROM PP_ForecastRunMaster frm ");
        insert.append(" INNER JOIN PP_ForecastRunResult frr ON (frr.PP_ForecastRunMaster_ID=frm.PP_ForecastRunMaster_ID) ");
        insert.append(" INNER JOIN PP_Period fp ON (fp.PP_Period_ID=frr.PP_Period_ID) ");
        insert.append(" INNER JOIN M_Product p ON (p.M_Product_ID=frm.M_Product_ID) ");
        insert.append(" INNER JOIN M_Product_Category pc ON (pc.M_Product_Category_ID=p.M_Product_Category_ID)");
        StringBuilder whereClause = new StringBuilder(" WHERE NOT EXISTS (SELECT 1 FROM M_ForecastLine fl WHERE fl.M_Forecast_ID=? AND ");
        whereClause.append("fl.M_Product_ID=frm.M_Product_ID AND ");
        whereClause.append("fl.M_Warehouse_ID=frm.M_Warehouse_ID AND ");
        whereClause.append("fl.PP_Period_ID=frr.PP_Period_ID) AND ");
        parameters.add(this.p_M_Forecast_ID);
        insert.append(this.getWhere(whereClause.toString(), parameters)).append(" ORDER BY fp.PeriodNo");
        return DB.executeUpdateEx(insert.toString(), parameters.toArray(), this.get_TrxName());
    }

    private int updateForecast() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder update = new StringBuilder();
        update.append("UPDATE ").append("M_ForecastLine");
        update.append(" SET ");
        update.append(" QtyCalculated = NVL(M_ForecastLine.QtyCalculated,0) + NVL(frr.QtyCalculated,0),");
        update.append(" Qty =  NVL(M_ForecastLine.Qty,0) + NVL(frr.QtyPlan,0) + NVL(frr.QtyAbnormal,0)");
        update.append(" FROM PP_ForecastRunMaster frm ");
        update.append(" INNER JOIN PP_ForecastRunResult frr ON (frr.PP_ForecastRunMaster_ID=frm.PP_ForecastRunMaster_ID) ");
        update.append(" INNER JOIN PP_Period fp ON (fp.PP_Period_ID=frr.PP_Period_ID) ");
        update.append(" INNER JOIN M_Product p ON (p.M_Product_ID=frm.M_Product_ID) ");
        update.append(" INNER JOIN M_Product_Category pc ON (pc.M_Product_Category_ID=p.M_Product_Category_ID)");
        update.append(" LEFT  JOIN M_Product_Classification pcl ON (pcl.value=p.Classification) ");
        update.append(" LEFT  JOIN M_Product_Class pclass ON (pclass.value=p.Group1) ");
        update.append(" LEFT  JOIN M_Product_Group pg ON (p.value=p.Group2) ");
        StringBuilder whereClause = new StringBuilder(" WHERE M_ForecastLine.M_Forecast_ID=?  AND ");
        whereClause.append(" M_ForecastLine.M_Product_ID = frm.M_Product_ID AND ");
        whereClause.append(" M_ForecastLine.M_Warehouse_ID=frm.M_Warehouse_ID AND ");
        whereClause.append(" M_ForecastLine.PP_Period_ID=frr.PP_Period_ID AND ");
        parameters.add(this.p_M_Forecast_ID);
        update.append(this.getWhere(whereClause.toString(), parameters));
        return DB.executeUpdateEx(update.toString(), parameters.toArray(), this.get_TrxName());
    }

    private String getWhere(String where, List<Object> parameters) {
        StringBuilder whereClause = new StringBuilder(where);
        whereClause.append("frm.PP_ForecastRun_ID=? AND frm.AD_Client_ID=? ");
        parameters.add(this.p_PP_ForecastRun_ID);
        parameters.add(this.getAD_Client_ID());
        if (this.p_ForecastLoadType.equals("S")) {
            whereClause.append("AND adddays(fp.StartDate,").append(this.p_DaysAfterDue).append(") BETWEEN ?  AND ?  ");
        }
        if (this.p_ForecastLoadType.equals("E")) {
            whereClause.append("AND adddays(fp.EndDate,").append(this.p_DaysAfterDue).append(")  BETWEEN ?  AND ?  ");
        }
        parameters.add(this.p_StartDate);
        parameters.add(this.p_EndDate);
        if (this.p_M_Product_ID > 0) {
            whereClause.append("AND frm.M_Product_ID=? ");
            parameters.add(this.p_M_Product_ID);
        }
        if (this.p_M_Product_Category_ID > 0) {
            whereClause.append("AND pc.M_Product_Category_ID=? ");
            parameters.add(this.p_M_Product_Category_ID);
        }
        if (this.p_M_Product_Classification_ID > 0) {
            whereClause.append("AND pcl.M_Product_Classification_ID=? ");
            parameters.add(this.p_M_Product_Classification_ID);
        }
        if (this.p_M_Product_Class_ID > 0) {
            whereClause.append("AND pclass.M_Product_Class_ID=? ");
            parameters.add(this.p_M_Product_Class_ID);
        }
        if (this.p_M_Product_Group_ID > 0) {
            whereClause.append("AND pg.M_Product_Group_ID=? ");
            parameters.add(this.p_M_Product_Group_ID);
        }
        return whereClause.toString();
    }

    private int deleteData() {
        StringBuilder updateSQL = new StringBuilder();
        updateSQL.append("DELETE FROM M_ForecastLine WHERE M_Forecast_ID=").append(this.p_M_Forecast_ID);
        return DB.executeUpdateEx(updateSQL.toString(), this.get_TrxName());
    }
}

