/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.manufacturing.model.MPPOrder;

public class CompletePrintOrder
extends SvrProcess
implements ClientProcess {
    private int p_PP_Order_ID = 0;
    private boolean p_IsPrintPickList = false;
    private boolean p_IsPrintWorkflow = false;
    private boolean p_IsPrintPackList = false;
    private boolean p_IsComplete = false;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("PP_Order_ID")) {
                this.p_PP_Order_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("IsPrintPickList")) {
                this.p_IsPrintPickList = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsPrintWorkflow")) {
                this.p_IsPrintWorkflow = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsPrintPackingList")) {
                this.p_IsPrintPackList = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("IsComplete")) {
                this.p_IsComplete = para.getParameterAsBoolean();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        MTable table;
        PO entity;
        if (this.p_PP_Order_ID == 0) {
            throw new FillMandatoryException(new String[]{"PP_Order_ID"});
        }
        if (this.p_IsComplete) {
            MPPOrder order = new MPPOrder(this.getCtx(), this.p_PP_Order_ID, this.get_TrxName());
            if (!order.isAvailable()) {
                throw new AdempiereException("@NoQtyAvailable@");
            }
            order.setDocAction("CO");
            boolean ok = order.processIt("CO");
            order.saveEx();
            if (!ok) {
                throw new AdempiereException(order.getProcessMsg());
            }
            if (!"CO".equals(order.getDocStatus())) {
                throw new AdempiereException(order.getProcessMsg());
            }
        }
        if ((entity = (table = MTable.get(this.getCtx(), "PP_Order")).getPO(this.p_PP_Order_ID, this.get_TrxName())) == null) {
            this.addLog("@NotFound@ @PP_Order_ID@");
        } else {
            if (this.p_IsPrintPickList) {
                this.printDocument(entity, this.getPrintFormatId("Manufacturing_Order_BOM_Header ** TEMPLATE **", "PP_Order_BOM_Header_v"), false);
            }
            if (this.p_IsPrintPackList) {
                this.printDocument(entity, this.getPrintFormatId("Manufacturing_Order_BOM_Header_Packing ** TEMPLATE **", "PP_Order_BOM_Header_v"), false);
            }
            if (this.p_IsPrintWorkflow) {
                this.printDocument(entity, this.getPrintFormatId("Manufacturing_Order_Workflow_Header ** TEMPLATE **", "PP_Order_Workflow_Header_v"), false);
            }
        }
        return "@OK@";
    }

    private int getPrintFormatId(String formatName, String tableName) {
        return MPrintFormat.getPrintFormat_ID(formatName, MTable.getTable_ID(tableName), this.getAD_Client_ID());
    }
}

