/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_S_Resource;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.TimeUtil;
import org.eevolution.manufacturing.exceptions.CRPException;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPOrderNode;
import org.eevolution.manufacturing.model.MPPOrderWorkflow;
import org.eevolution.manufacturing.model.reasoner.CRPReasoner;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class CRP
extends SvrProcess {
    public static final String FORWARD_SCHEDULING = "F";
    public static final String BACKWARD_SCHEDULING = "B";
    private int p_S_Resource_ID;
    private String p_ScheduleType;
    private int p_MaxIterationsNo = -1;
    public static final String SYSCONFIG_MaxIterationsNo = "CRP.MaxIterationsNo";
    public static final int DEFAULT_MaxIterationsNo = 1000;
    public RoutingService routingService = null;
    private CRPReasoner reasoner;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) {
                // empty if block
            }
            if (name.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("ScheduleType")) {
                this.p_ScheduleType = (String)para.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_MaxIterationsNo = MSysConfig.getIntValue(SYSCONFIG_MaxIterationsNo, 1000, this.getAD_Client_ID());
    }

    @Override
    protected String doIt() throws Exception {
        this.reasoner = new CRPReasoner();
        this.routingService = RoutingServiceFactory.get().getRoutingService(this.getAD_Client_ID());
        return this.runCRP();
    }

    private String runCRP() {
        Iterator it = this.reasoner.getPPOrdersNotCompletedQuery(this.p_S_Resource_ID, this.get_TrxName()).iterate();
        while (it.hasNext()) {
            MPPOrder order = (MPPOrder)it.next();
            try {
                this.runCRP(order);
            }
            catch (Exception e) {
                if (e instanceof CRPException) {
                    CRPException crpEx = (CRPException)e;
                    crpEx.setPP_Order(order);
                    throw crpEx;
                }
                CRPException crpEx = new CRPException(e);
                throw crpEx;
            }
        }
        return "OK";
    }

    public void runCRP(MPPOrder order) {
        this.log.info("PP_Order DocumentNo:" + order.getDocumentNo());
        MPPOrderWorkflow owf = order.getMPPOrderWorkflow();
        if (owf == null) {
            this.addLog("WARNING: No workflow found - " + order);
            return;
        }
        this.log.info("PP_Order Workflow:" + owf.getName());
        ArrayList<Integer> visitedNodes = new ArrayList<Integer>();
        if (this.p_ScheduleType.equals(FORWARD_SCHEDULING)) {
            Timestamp date = order.getDateStartSchedule();
            int nodeId = owf.getPP_Order_Node_ID();
            MPPOrderNode node = null;
            while (nodeId != 0) {
                node = owf.getNode(nodeId);
                if (visitedNodes.contains(nodeId)) {
                    throw new CRPException("Cyclic transition found").setPP_Order_Node(node);
                }
                visitedNodes.add(nodeId);
                this.log.info("PP_Order Node:" + node.getName() != null ? node.getName() : (" Description:" + node.getDescription() != null ? node.getDescription() : ""));
                MResource resource = MResource.get(this.getCtx(), node.getS_Resource_ID());
                if (resource == null) {
                    nodeId = owf.getNext(nodeId, this.getAD_Client_ID());
                    continue;
                }
                if (!this.reasoner.isAvailable(resource)) {
                    throw new CRPException("@ResourceNotInSlotDay@").setS_Resource(resource);
                }
                long nodeMillis = this.calculateMillisFor(node, owf.getDurationBaseSec());
                Timestamp dateFinish = this.scheduleForward(date, nodeMillis, resource);
                node.setDateStartSchedule(date);
                node.setDateFinishSchedule(dateFinish);
                node.saveEx();
                date = node.getDateFinishSchedule();
                nodeId = owf.getNext(nodeId, this.getAD_Client_ID());
            }
            if (node != null && node.getDateFinishSchedule() != null) {
                order.setDateFinishSchedule(node.getDateFinishSchedule());
            }
        } else if (this.p_ScheduleType.equals(BACKWARD_SCHEDULING)) {
            Timestamp date = order.getDateFinishSchedule();
            int nodeId = owf.getNodeLastID(this.getAD_Client_ID());
            MPPOrderNode node = null;
            while (nodeId != 0) {
                node = owf.getNode(nodeId);
                if (visitedNodes.contains(nodeId)) {
                    throw new CRPException("Cyclic transition found - ").setPP_Order_Node(node);
                }
                visitedNodes.add(nodeId);
                this.log.info("PP_Order Node:" + node.getName() != null ? node.getName() : (" Description:" + node.getDescription() != null ? node.getDescription() : ""));
                MResource resource = MResource.get(this.getCtx(), node.getS_Resource_ID());
                if (resource == null) {
                    nodeId = owf.getPrevious(nodeId, this.getAD_Client_ID());
                    continue;
                }
                if (!this.reasoner.isAvailable(resource)) {
                    throw new CRPException("@ResourceNotInSlotDay@").setS_Resource(resource);
                }
                long nodeMillis = this.calculateMillisFor(node, owf.getDurationBaseSec());
                Timestamp dateStart = this.scheduleBackward(date, nodeMillis, resource);
                node.setDateStartSchedule(dateStart);
                node.setDateFinishSchedule(date);
                node.saveEx();
                date = node.getDateStartSchedule();
                nodeId = owf.getPrevious(nodeId, this.getAD_Client_ID());
            }
            if (node != null && node.getDateStartSchedule() != null) {
                order.setDateStartSchedule(node.getDateStartSchedule());
            }
        } else {
            throw new CRPException("Unknown scheduling method - " + this.p_ScheduleType);
        }
        order.saveEx(this.get_TrxName());
    }

    private long calculateMillisFor(MPPOrderNode node, long commonBase) {
        BigDecimal qty = node.getQtyToDeliver();
        long totalDuration = node.getQueuingTime() + node.getSetupTimeRequired().intValueExact() + node.getMovingTime() + node.getWaitingTime();
        BigDecimal workingTime = this.routingService.estimateWorkingTime(node, qty);
        totalDuration = (long)((double)totalDuration + workingTime.doubleValue());
        return totalDuration * commonBase * 1000L;
    }

    private long getAvailableDurationMillis(Timestamp dayStart, Timestamp dayEnd, I_S_Resource resource) {
        long availableDayDuration = dayEnd.getTime() - dayStart.getTime();
        this.log.info("--> availableDayDuration  " + availableDayDuration);
        if (availableDayDuration < 0L) {
            throw new CRPException("@TimeSlotStart@ > @TimeSlotEnd@ (" + dayEnd + " > " + dayStart + ")").setS_Resource(resource);
        }
        return availableDayDuration;
    }

    private Timestamp scheduleForward(Timestamp start, long nodeDurationMillis, MResource r) {
        MResourceType t = r.getResourceType();
        int iteration = 0;
        Timestamp currentDate = start;
        Timestamp end = null;
        long remainingMillis = nodeDurationMillis;
        do {
            long availableDayDuration;
            currentDate = this.reasoner.getAvailableDate(r, currentDate, false);
            Timestamp dayStart = t.getDayStart(currentDate);
            Timestamp dayEnd = t.getDayEnd(currentDate);
            if (currentDate.after(dayStart) && currentDate.before(dayEnd)) {
                dayStart = currentDate;
            }
            if ((availableDayDuration = this.getAvailableDurationMillis(dayStart, dayEnd, r)) >= remainingMillis) {
                end = new Timestamp(dayStart.getTime() + remainingMillis);
                remainingMillis = 0L;
                break;
            }
            currentDate = TimeUtil.addDays(TimeUtil.getDayBorder(currentDate, null, false), 1);
            remainingMillis -= availableDayDuration;
            if (++iteration <= this.p_MaxIterationsNo) continue;
            throw new CRPException("Maximum number of iterations exceeded (" + this.p_MaxIterationsNo + ") - Date:" + currentDate + ", RemainingMillis:" + remainingMillis);
        } while (remainingMillis > 0L);
        return end;
    }

    private Timestamp scheduleBackward(Timestamp end, long nodeDurationMillis, MResource r) {
        MResourceType t = r.getResourceType();
        this.log.info("--> ResourceType " + t);
        Timestamp start = null;
        Timestamp currentDate = end;
        long remainingMillis = nodeDurationMillis;
        int iteration = 0;
        do {
            long availableDayDuration;
            this.log.info("--> end=" + currentDate);
            this.log.info("--> nodeDuration=" + remainingMillis);
            currentDate = this.reasoner.getAvailableDate(r, currentDate, true);
            this.log.info("--> end(available)=" + currentDate);
            Timestamp dayEnd = t.getDayEnd(currentDate);
            Timestamp dayStart = t.getDayStart(currentDate);
            this.log.info("--> dayStart=" + dayStart + ", dayEnd=" + dayEnd);
            if (currentDate.before(dayEnd) && currentDate.after(dayStart)) {
                dayEnd = currentDate;
            }
            if ((availableDayDuration = this.getAvailableDurationMillis(dayStart, dayEnd, r)) >= remainingMillis) {
                this.log.info("--> availableDayDuration >= nodeDuration true " + availableDayDuration + "|" + remainingMillis);
                start = new Timestamp(dayEnd.getTime() - remainingMillis);
                remainingMillis = 0L;
                break;
            }
            this.log.info("--> availableDayDuration >= nodeDuration false " + availableDayDuration + "|" + remainingMillis);
            this.log.info("--> nodeDuration-availableDayDuration " + (remainingMillis - availableDayDuration));
            currentDate = TimeUtil.addDays(TimeUtil.getDayBorder(currentDate, null, true), -1);
            remainingMillis -= availableDayDuration;
            if (++iteration <= this.p_MaxIterationsNo) continue;
            throw new CRPException("Maximum number of iterations exceeded (" + this.p_MaxIterationsNo + ") - Date:" + start + ", RemainingMillis:" + remainingMillis);
        } while (remainingMillis > 0L);
        this.log.info("         -->  start=" + start + " <---------------------------------------- ");
        return start;
    }
}

