/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Properties;
import org.adempiere.core.domains.models.X_PP_WF_Node_Product;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPPWFNodeProduct
extends X_PP_WF_Node_Product {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, Collection<MPPWFNodeProduct>> s_cache = new CCache("PP_WF_Node_Product", 20);

    public static Collection<MPPWFNodeProduct> forAD_WF_Node_ID(Properties ctx, int AD_WF_Node_ID) {
        Collection<MPPWFNodeProduct> lines = s_cache.get(AD_WF_Node_ID);
        if (lines != null) {
            return lines;
        }
        String whereClause = "AD_WF_Node_ID=?";
        lines = new Query(ctx, "PP_WF_Node_Product", "AD_WF_Node_ID=?", null).setParameters(AD_WF_Node_ID).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        s_cache.put(AD_WF_Node_ID, lines);
        return lines;
    }

    public MPPWFNodeProduct(Properties ctx, int PP_WF_Node_Product_ID, String trxName) {
        super(ctx, PP_WF_Node_Product_ID, trxName);
        if (PP_WF_Node_Product_ID == 0) {
            // empty if block
        }
    }

    public MPPWFNodeProduct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0)+10 FROM PP_WF_Node_Product WHERE  AD_WF_Node_ID=? AND PP_WF_Node_Product_ID<>?";
            int seqNo = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(SeqNo),0)+10 FROM PP_WF_Node_Product WHERE  AD_WF_Node_ID=? AND PP_WF_Node_Product_ID<>?", this.getAD_WF_Node_ID(), this.get_ID());
            this.setSeqNo(seqNo);
        }
        if (this.getQty().compareTo(Env.ZERO) == 0 && this.isSubcontracting()) {
            this.setQty(Env.ONE);
        }
        return true;
    }
}

