/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.util;

import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPaySelectionCheck;
import org.eevolution.hr.model.MHRPaySelectionLine;
import org.eevolution.hr.util.HRPaymentExport;

public class HRGenericPaymentExport
implements HRPaymentExport {
    private static CLogger s_log = CLogger.getCLogger(HRGenericPaymentExport.class);
    private static final int BP_VALUE = 0;
    private static final int BP_NAME = 1;
    private static final int BP_CONTACT = 2;
    private static final int BP_ADDR1 = 3;
    private static final int BP_ADDR2 = 4;
    private static final int BP_CITY = 5;
    private static final int BP_REGION = 6;
    private static final int BP_POSTAL = 7;
    private static final int BP_COUNTRY = 8;
    private static final int BP_REFNO = 9;

    @Override
    public int exportToFile(List<MHRPaySelectionCheck> list, File file, StringBuffer stringBuffer) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        if (file.isDirectory()) {
            stringBuffer.append("No se puede escribir, el archivo seleccionado es un directorio - " + file.getAbsolutePath());
            s_log.log(Level.SEVERE, stringBuffer.toString());
            return -1;
        }
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            s_log.log(Level.WARNING, "Could not delete - " + file.getAbsolutePath(), exception);
        }
        char c = '\"';
        int n = 0;
        StringBuffer stringBuffer2 = null;
        try {
            FileWriter fileWriter = new FileWriter(file);
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(c).append("Value").append(c).append(",").append(c).append("Name").append(c).append(",").append(c).append("Contact").append(c).append(",").append(c).append("Addr1").append(c).append(",").append(c).append("Addr2").append(c).append(",").append(c).append("City").append(c).append(",").append(c).append("State").append(c).append(",").append(c).append("ZIP").append(c).append(",").append(c).append("Country").append(c).append(",").append(c).append("ReferenceNo").append(c).append(",").append(c).append("DocumentNo").append(c).append(",").append(c).append("PayDate").append(c).append(",").append(c).append("Currency").append(c).append(",").append(c).append("PayAmount").append(c).append(",").append(c).append("Comment").append(c).append(Env.NL);
            fileWriter.write(stringBuffer2.toString());
            ++n;
            for (MHRPaySelectionCheck mHRPaySelectionCheck : list) {
                if (mHRPaySelectionCheck == null) continue;
                String[] stringArray = HRGenericPaymentExport.getBPartnerInfo(mHRPaySelectionCheck.getC_BPartner_ID());
                StringBuffer stringBuffer3 = new StringBuffer();
                List<MHRPaySelectionLine> list2 = mHRPaySelectionCheck.getPaySelectionLines(false);
                for (MHRPaySelectionLine mHRPaySelectionLine : list2) {
                    MHRMovement mHRMovement = new MHRMovement(mHRPaySelectionLine.getCtx(), mHRPaySelectionLine.getHR_Movement_ID(), mHRPaySelectionLine.get_TrxName());
                    MHRConcept mHRConcept = new MHRConcept(mHRPaySelectionLine.getCtx(), mHRMovement.getHR_Concept_ID(), mHRPaySelectionLine.get_TrxName());
                    stringBuffer3.append(mHRConcept.getName());
                }
                stringBuffer2 = new StringBuffer();
                stringBuffer2.append(c).append(stringArray[0]).append(c).append(",").append(c).append(stringArray[1]).append(c).append(",").append(c).append(stringArray[2]).append(c).append(",").append(c).append(stringArray[3]).append(c).append(",").append(c).append(stringArray[4]).append(c).append(",").append(c).append(stringArray[5]).append(c).append(",").append(c).append(stringArray[6]).append(c).append(",").append(c).append(stringArray[7]).append(c).append(",").append(c).append(stringArray[8]).append(c).append(",").append(c).append(stringArray[9]).append(c).append(",").append(c).append(mHRPaySelectionCheck.getDocumentNo()).append(c).append(",").append(mHRPaySelectionCheck.getParent().getPayDate()).append(",").append(c).append(MCurrency.getISO_Code(Env.getCtx(), mHRPaySelectionCheck.getParent().getC_Currency_ID())).append(c).append(",").append(mHRPaySelectionCheck.getPayAmt()).append(",").append(c).append(stringBuffer3.toString()).append(c).append(Env.NL);
                fileWriter.write(stringBuffer2.toString());
                ++n;
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            stringBuffer.append(exception.toString());
            s_log.log(Level.SEVERE, "", exception);
            return -1;
        }
        return n;
    }

    private static String[] getBPartnerInfo(int n) {
        String[] stringArray = new String[10];
        String string = "SELECT bp.Value, bp.Name, c.Name AS Contact, a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, cc.Name AS Country, bp.ReferenceNo FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc WHERE bp.C_BPartner_ID=? AND bp.C_BPartner_ID=c.C_BPartner_ID(+) AND bp.C_BPartner_ID=l.C_BPartner_ID AND l.C_Location_ID=a.C_Location_ID AND a.C_Region_ID=r.C_Region_ID(+) AND a.C_Country_ID=cc.C_Country_ID ORDER BY l.IsBillTo DESC";
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string, null);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                stringArray[0] = resultSet.getString(1);
                if (stringArray[0] == null) {
                    stringArray[0] = "";
                }
                stringArray[1] = resultSet.getString(2);
                if (stringArray[1] == null) {
                    stringArray[1] = "";
                }
                stringArray[2] = resultSet.getString(3);
                if (stringArray[2] == null) {
                    stringArray[2] = "";
                }
                stringArray[3] = resultSet.getString(4);
                if (stringArray[3] == null) {
                    stringArray[3] = "";
                }
                stringArray[4] = resultSet.getString(5);
                if (stringArray[4] == null) {
                    stringArray[4] = "";
                }
                stringArray[5] = resultSet.getString(6);
                if (stringArray[5] == null) {
                    stringArray[5] = "";
                }
                stringArray[6] = resultSet.getString(7);
                if (stringArray[6] == null) {
                    stringArray[6] = "";
                }
                stringArray[7] = resultSet.getString(8);
                if (stringArray[7] == null) {
                    stringArray[7] = "";
                }
                stringArray[8] = resultSet.getString(9);
                if (stringArray[8] == null) {
                    stringArray[8] = "";
                }
                stringArray[9] = resultSet.getString(10);
                if (stringArray[9] == null) {
                    stringArray[9] = "";
                }
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            s_log.log(Level.SEVERE, string, sQLException);
        }
        return stringArray;
    }
}

