/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRLeave;
import org.eevolution.hr.model.MHRLeaveAssign;
import org.eevolution.hr.model.MHRLeaveType;
import org.eevolution.hr.process.LeaveCreditManualAbstract;
import org.spin.hr.util.TNAUtil;

public class LeaveCreditManual
extends LeaveCreditManualAbstract {
    @Override
    protected String doIt() throws Exception {
        BigDecimal bigDecimal;
        if (this.getNoOfLeavesAllocated() <= 0) {
            return "";
        }
        MHRLeaveAssign mHRLeaveAssign = new MHRLeaveAssign(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MHRLeaveType mHRLeaveType = MHRLeaveType.getById(this.getCtx(), mHRLeaveAssign.getHR_LeaveType_ID(), this.get_TrxName());
        Timestamp timestamp = mHRLeaveAssign.getValidFrom();
        boolean bl = false;
        if (this.getValidFrom() != null) {
            if (!TimeUtil.isValid(timestamp, mHRLeaveAssign.getValidTo(), this.getValidFrom())) {
                throw new AdempiereException("@Invalid@ @ValidFrom@");
            }
            timestamp = this.getValidFrom();
        } else {
            timestamp = mHRLeaveAssign.getDateLastRun();
            bl = true;
        }
        if (timestamp == null) {
            timestamp = mHRLeaveAssign.getValidFrom();
        }
        int n = mHRLeaveAssign.getBalance();
        if (this.getNoOfLeavesAllocated() < n) {
            n = this.getNoOfLeavesAllocated();
        }
        if (n == 0) {
            throw new AdempiereException("@HR_LeaveAssign_ID@ @Used@");
        }
        String string = TNAUtil.getDurationUnitFromTimeUnit(mHRLeaveType.getTimeUnit());
        if (Util.isEmpty(string)) {
            throw new AdempiereException("@Invalid@ @TimeUnit@");
        }
        if (string.equals("h")) {
            string = "D";
        }
        if ((bigDecimal = mHRLeaveType.getLeaveDurationTime()) == null || bigDecimal.compareTo(Env.ZERO) <= 0) {
            bigDecimal = Env.ONE;
        }
        if (bl) {
            timestamp = TimeUtil.addDuration(timestamp, string, bigDecimal);
        }
        for (int i = 0; i < n; ++i) {
            MHRLeave mHRLeave = new MHRLeave(this.getCtx(), 0, this.get_TrxName());
            mHRLeave.setHR_LeaveType_ID(mHRLeaveType.getHR_LeaveType_ID());
            mHRLeave.setHR_LeaveAssign_ID(mHRLeaveAssign.getHR_LeaveAssign_ID());
            mHRLeave.setHR_LeaveReason_ID(this.getLeaveReasonId());
            mHRLeave.setDateDoc(timestamp);
            mHRLeave.setC_BPartner_ID(mHRLeaveAssign.getC_BPartner_ID());
            mHRLeave.saveEx();
            if (!mHRLeave.processIt(this.getDocAction())) {
                throw new AdempiereException(mHRLeave.getProcessMsg());
            }
            mHRLeave.saveEx();
            this.addLog("@HR_Leave_ID@ " + mHRLeave.getDocumentNo() + " @DateDoc@: " + DisplayType.getDateFormat(15).format(mHRLeave.getDateDoc()));
            timestamp = TimeUtil.addDuration(timestamp, string, bigDecimal);
        }
        mHRLeaveAssign.setDateLastRun(timestamp);
        mHRLeaveAssign.saveEx();
        return "@Created@: " + n;
    }
}

