/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPaySelection;
import org.eevolution.hr.model.MHRPaySelectionCheck;
import org.eevolution.hr.model.MHRPaySelectionLine;
import org.eevolution.hr.process.HRPaySelectionCreateFromAbstract;

public class HRPaySelectionCreateCheck
extends HRPaySelectionCreateFromAbstract {
    private List<MHRPaySelectionCheck> paySelectionChecks = new ArrayList<MHRPaySelectionCheck>();

    @Override
    protected void prepare() {
        super.prepare();
        this.getProcessInfo().setTable_ID(MHRPaySelection.Table_ID);
    }

    @Override
    protected String doIt() {
        this.log.info("HR_PaySelection_ID=" + this.getRecord_ID() + ", PaymentRule=" + this.getPaymentRule());
        MHRPaySelection mHRPaySelection = (MHRPaySelection)this.getInstance(this.get_TrxName());
        if (mHRPaySelection.get_ID() == 0) {
            throw new IllegalArgumentException("Not found HR_PaySelection_ID=" + this.getRecord_ID());
        }
        if (mHRPaySelection.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        Arrays.stream(mHRPaySelection.getLines(true)).filter(mHRPaySelectionLine -> mHRPaySelectionLine != null && mHRPaySelectionLine.isActive() && !mHRPaySelectionLine.isProcessed()).forEach(mHRPaySelectionLine -> this.createCheck((MHRPaySelectionLine)mHRPaySelectionLine));
        mHRPaySelection.setProcessed(true);
        mHRPaySelection.save();
        return "@C_PaySelectionCheck_ID@ - #" + this.paySelectionChecks.size();
    }

    private void createCheck(MHRPaySelectionLine mHRPaySelectionLine) {
        this.paySelectionChecks.stream().filter(mHRPaySelectionCheck -> mHRPaySelectionCheck.getC_BPartner_ID() == new MHRMovement(mHRPaySelectionLine.getCtx(), mHRPaySelectionLine.getHR_Movement_ID(), mHRPaySelectionLine.get_TrxName()).getC_BPartner_ID()).forEach(mHRPaySelectionCheck -> {
            mHRPaySelectionCheck.addLine(mHRPaySelectionLine);
            mHRPaySelectionCheck.saveEx();
            mHRPaySelectionLine.setHR_PaySelectionCheck_ID(mHRPaySelectionCheck.getHR_PaySelectionCheck_ID());
            mHRPaySelectionLine.setProcessed(true);
            mHRPaySelectionCheck.saveEx();
        });
        Optional<String> optional = Optional.of(mHRPaySelectionLine.getPaymentRule());
        MHRPaySelectionCheck mHRPaySelectionCheck2 = new MHRPaySelectionCheck(mHRPaySelectionLine, optional.orElseGet(() -> "T"));
        mHRPaySelectionCheck2.setAD_Org_ID(mHRPaySelectionLine.getAD_Org_ID());
        mHRPaySelectionCheck2.saveEx();
        mHRPaySelectionLine.setHR_PaySelectionCheck_ID(mHRPaySelectionCheck2.getHR_PaySelectionCheck_ID());
        mHRPaySelectionLine.setProcessed(true);
        mHRPaySelectionLine.saveEx();
        this.paySelectionChecks.add(mHRPaySelectionCheck2);
    }
}

