/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_Period;
import org.adempiere.core.domains.models.X_HR_Payroll;
import org.adempiere.core.domains.models.X_HR_Year;
import org.compiere.model.MCalendar;
import org.compiere.model.MPeriod;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRPeriod;

public class MHRYear
extends X_HR_Year {
    private static final long serialVersionUID = -7789699154024839462L;

    public MHRYear(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setProcessing(false);
        }
    }

    public MHRYear(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRYear(MCalendar mCalendar) {
        this(mCalendar.getCtx(), 0, mCalendar.get_TrxName());
        this.setClientOrg(mCalendar);
    }

    public boolean createPeriods() {
        int n = 0;
        int n2 = DB.getSQLValueEx(this.get_TrxName(), "SELECT C_Calendar_ID FROM C_Year WHERE C_Year_ID = ?", this.getC_Year_ID());
        if (n2 <= 0) {
            return false;
        }
        Timestamp timestamp = null;
        Timestamp timestamp2 = null;
        for (int i = 1; i <= this.getQty(); ++i) {
            PO pO;
            int n3;
            if (12 == this.getQty() && (28 == this.getNetDays() || 29 == this.getNetDays() || 30 == this.getNetDays() || 31 == this.getNetDays())) {
                timestamp = i > 1 ? TimeUtil.addDays(timestamp2, 1) : TimeUtil.addDays(this.getStartDate(), 0);
                timestamp2 = TimeUtil.getMonthLastDay(timestamp);
            } else if (24 == this.getQty() && (15 == this.getNetDays() || 16 == this.getNetDays())) {
                timestamp = i > 1 ? TimeUtil.addDays(timestamp2, 1) : TimeUtil.addDays(this.getStartDate(), 0);
                int n4 = n3 = i % 2 == 0 ? 1 : 0;
                timestamp2 = n3 == 0 ? TimeUtil.addDays(timestamp, this.getNetDays() - 1) : TimeUtil.getMonthLastDay(timestamp);
            } else {
                n = i == 1 ? 0 : (i - 1) * this.getNetDays();
                timestamp = TimeUtil.addDays(this.getStartDate(), n);
                timestamp2 = TimeUtil.addDays(timestamp, this.getNetDays() - 1);
            }
            n3 = DB.getSQLValueEx(this.get_TrxName(), "SELECT C_Period_ID FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID)  WHERE  ? BETWEEN p.startdate AND p.endDate AND y.C_Calendar_ID=?", timestamp2, n2);
            if (n3 <= 0) {
                return false;
            }
            String string = DisplayType.getDateFormat(15).format(timestamp) + " " + Msg.translate(this.getCtx(), "To") + " " + DisplayType.getDateFormat(15).format(timestamp2);
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getHR_Payroll_ID() > 0) {
                pO = new MHRPayroll(this.getCtx(), this.getHR_Payroll_ID(), this.get_TrxName());
                stringBuffer.append(Msg.translate(this.getCtx(), "HR_Payroll_ID")).append(" ").append(((X_HR_Payroll)pO).getName().trim()).append(" ");
            }
            stringBuffer.append(Msg.translate(this.getCtx(), "HR_Period_ID")).append(" ").append(i).append(": ").append(Msg.translate(this.getCtx(), "From")).append(" ").append(string);
            pO = MPeriod.get(this.getCtx(), n3);
            MHRPeriod mHRPeriod = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            mHRPeriod.setAD_Org_ID(this.getAD_Org_ID());
            mHRPeriod.setHR_Year_ID(this.getHR_Year_ID());
            mHRPeriod.setHR_Payroll_ID(this.getHR_Payroll_ID());
            mHRPeriod.setName(string);
            mHRPeriod.setDescription(stringBuffer.toString());
            mHRPeriod.setPeriodNo(i);
            mHRPeriod.setC_Period_ID(n3);
            mHRPeriod.setC_Year_ID(((X_C_Period)pO).getC_Year_ID());
            mHRPeriod.setStartDate(timestamp);
            mHRPeriod.setEndDate(timestamp2);
            mHRPeriod.setDateAcct(timestamp2);
            mHRPeriod.setIsActive(true);
            mHRPeriod.saveEx();
        }
        return true;
    }
}

