/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_PaySelectionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRPaySelection;

public class MHRPaySelectionLine
extends X_HR_PaySelectionLine {
    private static final long serialVersionUID = -3486055138810301789L;

    public MHRPaySelectionLine(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setIsSOTrx(false);
            this.setOpenAmt(Env.ZERO);
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setDifferenceAmt(Env.ZERO);
            this.setIsManual(false);
        }
    }

    public MHRPaySelectionLine(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRPaySelectionLine(MHRPaySelection mHRPaySelection, int n, String string) {
        this(mHRPaySelection.getCtx(), 0, mHRPaySelection.get_TrxName());
        this.setClientOrg(mHRPaySelection);
        this.setHR_PaySelection_ID(mHRPaySelection.getHR_PaySelection_ID());
        this.setLine(n);
        this.setPaymentRule(string);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        this.setDifferenceAmt(this.getOpenAmt().subtract(this.getPayAmt()).subtract(this.getDiscountAmt()));
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        this.setHeader();
        return bl2;
    }

    @Override
    protected boolean afterDelete(boolean bl) {
        this.setHeader();
        return bl;
    }

    private void setHeader() {
        String string = "UPDATE HR_PaySelection ps SET TotalAmt = (SELECT COALESCE(SUM(psl.PayAmt),0) FROM HR_PaySelectionLine psl WHERE ps.HR_PaySelection_ID=psl.HR_PaySelection_ID AND psl.IsActive='Y') WHERE HR_PaySelection_ID=" + this.getHR_PaySelection_ID();
        DB.executeUpdate(string, this.get_TrxName());
    }
}

