/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_HR_PaySelection;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRPaySelectionLine;

public class MHRPaySelection
extends X_HR_PaySelection {
    private static final long serialVersionUID = -6521282913549455131L;
    private MHRPaySelectionLine[] m_lines = null;
    private int m_C_Currency_ID = 0;

    public MHRPaySelection(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setTotalAmt(Env.ZERO);
            this.setIsApproved(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MHRPaySelection(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRPaySelectionLine[] getLines(boolean bl) {
        if (this.m_lines != null && !bl) {
            MHRPaySelection.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        ArrayList<MHRPaySelectionLine> arrayList = new ArrayList<MHRPaySelectionLine>();
        String string = "SELECT * FROM HR_PaySelectionLine WHERE HR_PaySelection_ID=? ORDER BY Line";
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            cPreparedStatement.setInt(1, this.getHR_PaySelection_ID());
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(new MHRPaySelectionLine(this.getCtx(), resultSet, this.get_TrxName()));
            }
            resultSet.close();
            cPreparedStatement.close();
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, "getLines", exception);
        }
        try {
            if (cPreparedStatement != null) {
                cPreparedStatement.close();
            }
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            cPreparedStatement = null;
        }
        this.m_lines = new MHRPaySelectionLine[arrayList.size()];
        arrayList.toArray(this.m_lines);
        return this.m_lines;
    }

    public int getC_Currency_ID() {
        if (this.m_C_Currency_ID == 0) {
            String string = "SELECT C_Currency_ID FROM C_BankAccount WHERE C_BankAccount_ID=?";
            this.m_C_Currency_ID = DB.getSQLValue(null, string, this.getC_BankAccount_ID());
        }
        return this.m_C_Currency_ID;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MHRPaySelection[");
        stringBuffer.append(this.get_ID()).append(",").append(this.getName()).append("]");
        return stringBuffer.toString();
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        int n;
        if (this.getAD_Org_ID() == 0 && (n = Env.getAD_Org_ID(this.getCtx())) != 0) {
            this.setAD_Org_ID(n);
            this.log.warning("Changed Org to Context=" + n);
        }
        return true;
    }
}

