/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_EmployeeDependent;
import org.compiere.model.Query;
import org.eevolution.hr.model.MHRCareerLevel;
import org.eevolution.hr.model.MHRDegree;
import org.eevolution.hr.model.MHRGrade;
import org.eevolution.hr.model.MHRRace;
import org.eevolution.hr.model.MHRRelationship;

public class MHREmployeeDependent
extends X_HR_EmployeeDependent {
    private static final long serialVersionUID = 113089938678164180L;
    private List<MHREmployeeDependent> dependentList;

    public MHREmployeeDependent(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHREmployeeDependent(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Deprecated
    public static MHREmployeeDependent[] getEmployeeDependents(Properties properties, int n, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        return MHREmployeeDependent.getEmployeeDependents(properties, n, string, string2, bl, bl, bl3, null).toArray(new MHREmployeeDependent[0]);
    }

    public static List<MHREmployeeDependent> getEmployeeDependents(Properties properties, int n, String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stringBuffer.append("C_BPartner_ID").append("= ?");
        arrayList.add(n);
        if (string != null && string.length() > 0) {
            stringBuffer.append(" AND EXISTS(SELECT 1 FROM HR_Relationship r \t\t\t\t\t\t\t\tWHERE r.HR_Relationship_ID = HR_EmployeeDependent.HR_Relationship_ID \t\t\t\t\t\t\t\tAND r.Value = ?)");
            arrayList.add(string);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" AND EXISTS(SELECT 1 FROM HR_Grade g \t\t\t\t\t\t\t\tWHERE g.HR_Grade_ID = HR_EmployeeDependent.HR_Grade_ID \t\t\t\t\t\t\t\tAND g.Value = ?)");
            arrayList.add(string2);
        }
        if (bl) {
            stringBuffer.append(" AND IsDepending = ?");
            arrayList.add(true);
        }
        if (bl2) {
            stringBuffer.append(" AND IsScholarship = ?");
            arrayList.add(true);
        }
        if (bl3) {
            stringBuffer.append(" AND IsActiveStudent = ?");
            arrayList.add(true);
        }
        return new Query(properties, "HR_EmployeeDependent", stringBuffer.toString(), string3).setParameters(arrayList).setOnlyActiveRecords(true).list();
    }

    public static MHREmployeeDependent loadDependent(Properties properties, int n, String string) {
        return new MHREmployeeDependent(properties, 0, string).loadDependent(n);
    }

    public MHREmployeeDependent loadDependent(int n) {
        this.dependentList = new Query(this.getCtx(), "HR_EmployeeDependent", "C_BPartner_ID = ?", this.get_TrxName()).setParameters(n).setOnlyActiveRecords(true).list();
        return this;
    }

    public MHREmployeeDependent filterDepending(boolean bl) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.isDepending() == bl).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterActiveStudent(boolean bl) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.isActiveStudent() == bl).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterScholarship(boolean bl) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.isScholarship() == bl).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterDegreeValue(String string) {
        MHRDegree mHRDegree;
        if (string == null || string.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (mHRDegree = MHRDegree.getByValue(this.getCtx(), string, this.get_TrxName())) != null && mHRDegree.getHR_Degree_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.getHR_Degree_ID() == mHRDegree.getHR_Degree_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterGradeValue(String string) {
        MHRGrade mHRGrade;
        if (string == null || string.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (mHRGrade = MHRGrade.getByValue(this.getCtx(), string, this.get_TrxName())) != null && mHRGrade.getHR_Grade_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.getHR_Grade_ID() == mHRGrade.getHR_Grade_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterCareerLevelValue(String string) {
        MHRCareerLevel mHRCareerLevel;
        if (string == null || string.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (mHRCareerLevel = MHRCareerLevel.getByValue(this.getCtx(), string, this.get_TrxName())) != null && mHRCareerLevel.getHR_CareerLevel_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.getHR_CareerLevel_ID() == mHRCareerLevel.getHR_CareerLevel_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterRaceValue(String string) {
        MHRRace mHRRace;
        if (string == null || string.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (mHRRace = MHRRace.getByValue(this.getCtx(), string, this.get_TrxName())) != null && mHRRace.getHR_Race_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.getHR_Race_ID() == mHRRace.getHR_Race_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterRelationshipValue(String string) {
        MHRRelationship mHRRelationship;
        if (string == null || string.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (mHRRelationship = MHRRelationship.getByValue(this.getCtx(), string, this.get_TrxName())) != null && mHRRelationship.getHR_Relationship_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.getHR_Relationship_ID() == mHRRelationship.getHR_Relationship_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterIsSpecialCondition(boolean bl) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(mHREmployeeDependent -> mHREmployeeDependent.get_ValueAsBoolean("IsSpecialCondition") == bl).collect(Collectors.toList());
        }
        return this;
    }

    @Override
    public String toString() {
        return "MHREmployeeDependent[getName() " + this.getName() + "]";
    }
}

