/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.I_HR_Concept;
import org.adempiere.core.domains.models.X_HR_Attribute;
import org.adempiere.core.domains.models.X_HR_Payroll;
import org.adempiere.core.domains.models.X_I_HR_Attribute;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHRPayroll;

public class MHRAttribute
extends X_HR_Attribute {
    private static final long serialVersionUID = 3783311896401143394L;

    public static Optional<MHRAttribute> getByConceptValueAndPartnerId(Properties properties, String string, Integer n, String string2, String string3, String string4) {
        if (n == null) {
            return Optional.empty();
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stringBuilder.append("EXISTS (SELECT 1 FROM HR_Concept c WHERE c.IsEmployee=? AND c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value=?)");
        arrayList.add("Y");
        arrayList.add(string);
        if (n > 0) {
            stringBuilder.append(" AND ").append("C_BPartner_ID").append("=?");
            arrayList.add(n);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(" AND ").append("Description").append("=?");
            arrayList.add(string3);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" AND ").append("ReferenceNo").append("=?");
            arrayList.add(string2);
        }
        MHRAttribute mHRAttribute = (MHRAttribute)new Query(properties, "HR_Attribute", stringBuilder.toString(), string4).setClient_ID().setParameters(arrayList).first();
        return Optional.ofNullable(mHRAttribute);
    }

    public static List<MHRAttribute> findByConceptValueAndPartnerId(Properties properties, String string, Integer n, String string2, String string3, String string4) {
        List<MHRAttribute> list = new ArrayList<MHRAttribute>();
        if (n == null) {
            return list;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stringBuilder.append("EXISTS (SELECT 1 FROM HR_Concept c WHERE c.IsEmployee=? AND c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value=?)");
        arrayList.add("Y");
        arrayList.add(string);
        if (n > 0) {
            stringBuilder.append(" AND ").append("C_BPartner_ID").append("=?");
            arrayList.add(n);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(" AND ").append("Description").append("=?");
            arrayList.add(string3);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" AND ").append("ReferenceNo").append("=?");
            arrayList.add(string2);
        }
        list = new Query(properties, "HR_Attribute", stringBuilder.toString(), string4).setClient_ID().setParameters(arrayList).list();
        return list;
    }

    public static MHRAttribute getByConceptAndPartnerId(MHRConcept mHRConcept, Integer n, int n2, String string, String string2, Timestamp timestamp) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Concept_ID").append("=?");
        arrayList.add(mHRConcept.getHR_Concept_ID());
        if (n > 0) {
            stringBuffer.append(" AND ").append("C_BPartner_ID").append("=? ");
            arrayList.add(n);
        }
        if (string != null && string.length() > 0) {
            stringBuffer.append(" AND ").append("ReferenceNo").append("=? ");
            arrayList.add(string);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" AND ").append("Description").append("=? ");
            arrayList.add(string2);
        }
        if (n2 > 0) {
            stringBuffer.append(" AND ").append("HR_Payroll_ID").append("? ");
            arrayList.add(n2);
        }
        if (timestamp != null) {
            stringBuffer.append(" AND ").append("ValidFrom").append("=? ");
            arrayList.add(timestamp);
        }
        MHRAttribute mHRAttribute = (MHRAttribute)new Query(mHRConcept.getCtx(), "HR_Attribute", stringBuffer.toString(), mHRConcept.get_TrxName()).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        return mHRAttribute;
    }

    public static MHRAttribute getByConceptAndEmployee(MHRConcept mHRConcept, MHREmployee mHREmployee, int n, Timestamp timestamp, Timestamp timestamp2) {
        PO pO;
        String string = " DESC NULLS LAST";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("ValidFrom").append(string);
        stringBuffer.append("ValidFrom <= ? AND (ValidTo >= ? OR ValidTo IS NULL)");
        arrayList.add(timestamp);
        arrayList.add(timestamp2);
        stringBuffer.append(" AND HR_Concept_ID = ? ");
        arrayList.add(mHRConcept.getHR_Concept_ID());
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        stringBuffer.append(" AND (HR_Payroll_ID = ? OR HR_Payroll_ID IS NULL)");
        arrayList.add(n);
        stringBuffer2.append(", HR_Payroll_ID").append(string);
        if (mHREmployee != null) {
            if (mHRConcept.isEmployee()) {
                stringBuffer.append(" AND C_BPartner_ID = ? AND (HR_Employee_ID = ? OR HR_Employee_ID IS NULL)");
                arrayList.add(mHREmployee.getC_BPartner_ID());
                arrayList.add(mHREmployee.get_ID());
                stringBuffer2.append(", C_BPartner_ID").append(string);
            } else {
                stringBuffer.append(" AND C_BPartner_ID IS NULL ");
            }
            stringBuffer.append(" AND (HR_Department_ID = ? OR HR_Department_ID IS NULL)");
            arrayList.add(mHREmployee.getHR_Department_ID());
            stringBuffer2.append(", HR_Department_ID").append(string);
            stringBuffer.append(" AND (HR_Job_ID = ? OR HR_Job_ID IS NULL)");
            arrayList.add(mHREmployee.getHR_Job_ID());
            stringBuffer2.append(", HR_Job_ID").append(string);
            pO = MHRPayroll.getById(mHREmployee.getCtx(), n, mHRConcept.get_TrxName());
            stringBuffer.append(" AND (HR_Contract_ID = ? OR HR_Contract_ID IS NULL)");
            arrayList.add(((X_HR_Payroll)pO).getHR_Contract_ID());
            stringBuffer2.append(", HR_Contract_ID").append(string);
            if (mHREmployee.getHR_WorkGroup_ID() != 0) {
                stringBuffer.append(" AND (HR_WorkGroup_ID = ? OR HR_WorkGroup_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_WorkGroup_ID());
                stringBuffer2.append(", HR_WorkGroup_ID").append(string);
            }
            if (mHREmployee.getHR_ShiftGroup_ID() != 0) {
                stringBuffer.append(" AND (HR_ShiftGroup_ID = ? OR HR_ShiftGroup_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_ShiftGroup_ID());
                stringBuffer2.append(", HR_ShiftGroup_ID").append(string);
            }
            if (mHREmployee.getHR_Grade_ID() != 0) {
                stringBuffer.append(" AND (HR_Grade_ID = ? OR HR_Grade_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_Grade_ID());
                stringBuffer2.append(", HR_Grade_ID").append(string);
            }
            if (mHREmployee.getHR_Degree_ID() != 0) {
                stringBuffer.append(" AND (HR_Degree_ID = ? OR HR_Degree_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_Degree_ID());
                stringBuffer2.append(", HR_Degree_ID").append(string);
            }
            if (mHREmployee.getHR_Race_ID() != 0) {
                stringBuffer.append(" AND (HR_Race_ID = ? OR HR_Race_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_Race_ID());
                stringBuffer2.append(", HR_Race_ID").append(string);
            }
            if (mHREmployee.getHR_CareerLevel_ID() != 0) {
                stringBuffer.append(" AND (HR_CareerLevel_ID = ? OR HR_CareerLevel_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_CareerLevel_ID());
                stringBuffer2.append(", HR_CareerLevel_ID").append(string);
            }
            if (mHREmployee.getHR_JobEducation_ID() != 0) {
                stringBuffer.append(" AND (HR_JobEducation_ID = ? OR HR_JobEducation_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_JobEducation_ID());
                stringBuffer2.append(", HR_JobEducation_ID").append(string);
            }
            if (mHREmployee.getHR_EmployeeType_ID() != 0) {
                stringBuffer.append(" AND (HR_EmployeeType_ID = ? OR HR_EmployeeType_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_EmployeeType_ID());
                stringBuffer2.append(", HR_EmployeeType_ID").append(string);
            }
            if (mHREmployee.getHR_JobType_ID() != 0) {
                stringBuffer.append(" AND (HR_JobType_ID = ? OR HR_JobType_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_JobType_ID());
                stringBuffer2.append(", HR_JobType_ID").append(string);
            }
            if (mHREmployee.getHR_SkillType_ID() != 0) {
                stringBuffer.append(" AND (HR_SkillType_ID = ? OR HR_SkillType_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_SkillType_ID());
                stringBuffer2.append(", HR_SkillType_ID").append(string);
            }
            if (mHREmployee.getHR_Designation_ID() != 0) {
                stringBuffer.append(" AND (HR_Designation_ID = ? OR HR_Designation_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_Designation_ID());
                stringBuffer2.append(", HR_Designation_ID").append(string);
            }
            if (mHREmployee.getHR_SalaryStructure_ID() != 0) {
                stringBuffer.append(" AND (HR_SalaryStructure_ID = ? OR HR_SalaryStructure_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_SalaryStructure_ID());
                stringBuffer2.append(", HR_SalaryStructure_ID").append(string);
            }
            if (mHREmployee.getHR_SalaryRange_ID() != 0) {
                stringBuffer.append(" AND (HR_SalaryRange_ID = ? OR HR_SalaryRange_ID IS NULL)");
                arrayList.add(mHREmployee.getHR_SalaryRange_ID());
                stringBuffer2.append(", HR_SalaryRange_ID").append(string);
            }
            if (mHREmployee.getEmployeeStatus() != null) {
                stringBuffer.append(" AND (EmployeeStatus = ? OR EmployeeStatus IS NULL)");
                arrayList.add(mHREmployee.getEmployeeStatus());
                stringBuffer2.append(", EmployeeStatus").append(string);
            }
            if (mHREmployee.getC_Activity_ID() != 0) {
                stringBuffer.append(" AND (C_Activity_ID = ? OR C_Activity_ID IS NULL)");
                arrayList.add(mHREmployee.getC_Activity_ID());
                stringBuffer2.append(", C_Activity_ID").append(string);
            }
            if (mHREmployee.getC_Campaign_ID() != 0) {
                stringBuffer.append(" AND (C_Campaign_ID = ? OR C_Campaign_ID IS NULL)");
                arrayList.add(mHREmployee.getC_Campaign_ID());
                stringBuffer2.append(", C_Campaign_ID").append(string);
            }
            if (mHREmployee.getC_Project_ID() != 0) {
                stringBuffer.append(" AND (C_Project_ID = ? OR C_Project_ID IS NULL)");
                arrayList.add(mHREmployee.getC_Project_ID());
                stringBuffer2.append(", C_Project_ID").append(string);
            }
            if (mHREmployee.getAD_OrgTrx_ID() != 0) {
                stringBuffer.append(" AND (AD_OrgTrx_ID = ? OR AD_OrgTrx_ID IS NULL)");
                arrayList.add(mHREmployee.getAD_OrgTrx_ID());
                stringBuffer2.append(", AD_OrgTrx_ID").append(string);
            }
        }
        stringBuffer2.append(", Updated").append(string);
        pO = (MHRAttribute)new Query(mHRConcept.getCtx(), "HR_Attribute", stringBuffer.toString(), mHRConcept.get_TrxName()).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy(stringBuffer2.toString()).first();
        return pO;
    }

    public static MHRAttribute getByConceptIdAndPartnerId(Properties properties, int n, int n2, Timestamp timestamp, String string) {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append("C_BPartner_ID").append("=? OR ").append("C_BPartner_ID").append(" IS NULL) AND ");
        stringBuilder.append("ValidFrom").append("<=? AND ").append("EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.HR_Concept_ID=?)");
        return (MHRAttribute)new Query(properties, "HR_Attribute", stringBuilder.toString(), string).setParameters(n2, timestamp, n).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
    }

    public static MHRAttribute getByConceptValueAndPartnerId(Properties properties, String string, int n, Timestamp timestamp, String string2) {
        if (Util.isEmpty(string, true)) {
            return null;
        }
        int n2 = Env.getAD_Client_ID(properties);
        MHRAttribute mHRAttribute = (MHRAttribute)new Query(properties, "HR_Attribute", "C_BPartner_ID=? AND AD_Client_ID IN (?,?)  AND ValidFrom<=? AND EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.Value=?)", string2).setParameters(n, 0, n2, timestamp, string).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        return mHRAttribute;
    }

    public static MHRAttribute getByConceptValueAndPartnerId(Properties properties, String string, int n, Timestamp timestamp, Timestamp timestamp2, String string2) {
        if (Util.isEmpty(string, true)) {
            return null;
        }
        if (timestamp2 == null) {
            return MHRAttribute.getByConceptValueAndPartnerId(properties, string, n, timestamp, string2);
        }
        int n2 = Env.getAD_Client_ID(properties);
        MHRAttribute mHRAttribute = (MHRAttribute)new Query(properties, "HR_Attribute", "C_BPartner_ID=? AND AD_Client_ID IN (?,?)  AND ValidFrom<=? AND ValidTo>=? AND EXISTS (SELECT 1 FROM HR_Concept c WHERE HR_Attribute.HR_Concept_ID = c.HR_Concept_ID AND c.Value=?)", string2).setParameters(n, 0, n2, timestamp, timestamp2, string).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        return mHRAttribute;
    }

    public MHRAttribute(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRAttribute(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRAttribute(X_I_HR_Attribute x_I_HR_Attribute) {
        super(x_I_HR_Attribute.getCtx(), 0, x_I_HR_Attribute.get_TrxName());
        this.setAD_Org_ID(x_I_HR_Attribute.getAD_Org_ID());
        this.setHR_Employee_ID(x_I_HR_Attribute.getHR_Employee_ID());
        this.setC_BPartner_ID(x_I_HR_Attribute.getC_BPartner_ID());
        this.setC_Charge_ID(x_I_HR_Attribute.getC_Charge_ID());
        this.setHR_Concept_ID(x_I_HR_Attribute.getHR_Concept_ID());
        this.setDescription(x_I_HR_Attribute.getDescription());
        this.setIsPrinted(x_I_HR_Attribute.isPrinted());
    }

    @Override
    public I_HR_Concept getHR_Concept() {
        return MHRConcept.getById(this.getCtx(), this.getHR_Concept_ID(), this.get_TrxName());
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (this.getHR_Concept().isEmployee() && this.getC_BPartner_ID() <= 0) {
            throw new AdempiereException("@HR_Employee_ID@ @NotFound@");
        }
        if (!this.getHR_Concept().isEmployee()) {
            this.setHR_Employee_ID(-1);
        }
        return true;
    }
}

