/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.controller;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.I_HR_EmployeeInsurance;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CalloutEmployee
extends CalloutEngine {
    public void calculateInsuranceBalance(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (object == null || this.isCalloutActive()) {
            return;
        }
        I_HR_EmployeeInsurance i_HR_EmployeeInsurance = GridTabWrapper.create(gridTab, I_HR_EmployeeInsurance.class);
        BigDecimal bigDecimal = i_HR_EmployeeInsurance.getCoverageAmount().subtract(i_HR_EmployeeInsurance.getClaimedAmount());
        i_HR_EmployeeInsurance.setBalanceAmount(bigDecimal);
    }

    public String validateLastPaidDate(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        I_HR_EmployeeInsurance i_HR_EmployeeInsurance = GridTabWrapper.create(gridTab, I_HR_EmployeeInsurance.class);
        Timestamp timestamp = i_HR_EmployeeInsurance.getPayDate();
        Timestamp timestamp2 = (Timestamp)object;
        if (timestamp == null) {
            return "";
        }
        if (timestamp2.before(timestamp)) {
            return "";
        }
        String string = Msg.getMsg(Env.getCtx(), "Invalid") + "  " + Msg.parseTranslation(properties, "@PayDate@");
        i_HR_EmployeeInsurance.setDateLastPaid((Timestamp)gridField.getOldValue());
        gridTab.fireDataStatusEEvent(string, null, false);
        return "";
    }

    public String validateLastPremiumDate(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        I_HR_EmployeeInsurance i_HR_EmployeeInsurance = GridTabWrapper.create(gridTab, I_HR_EmployeeInsurance.class);
        Timestamp timestamp = i_HR_EmployeeInsurance.getPayDate();
        Timestamp timestamp2 = (Timestamp)object;
        if (timestamp == null) {
            return "";
        }
        if (timestamp2.after(timestamp)) {
            return "";
        }
        String string = Msg.getMsg(Env.getCtx(), "Invalid") + " " + Msg.parseTranslation(properties, "@HR_EmployeeInsurance_ID@");
        i_HR_EmployeeInsurance.setDateLastPremium((Timestamp)gridField.getOldValue());
        gridTab.fireDataStatusEEvent(string, null, false);
        return "";
    }

    public void bpartnerRelation(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (object == null || this.isCalloutActive()) {
            return;
        }
        Integer n2 = (Integer)object;
        if (n2 <= 0) {
            return;
        }
        MBPartner mBPartner = MBPartner.get(properties, n2);
        Object object2 = mBPartner.getName();
        if (mBPartner.getName2() != null && mBPartner.getName2().trim().length() > 0) {
            object2 = (String)object2 + " " + mBPartner.getName2();
        }
        gridTab.setValue("Name", object2);
    }
}

