/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.Cursor;
import java.awt.Frame;
import java.util.List;
import javax.swing.JFrame;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.Viewer;
import org.compiere.process.IPrintDocument;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.services.dsl.ProcessBuilder;

public class VPrintDocument
implements IPrintDocument {
    @Override
    public void print(PO document, int printFormatId, int windowNo, boolean askPrint) {
        JFrame window = Env.getWindow(windowNo);
        if (!askPrint) {
            this.loopAndPrint(document, printFormatId, windowNo, window);
        } else if (ADialog.ask(windowNo, window, "PrintDocument", document.getDisplayValue())) {
            this.loopAndPrint(document, printFormatId, windowNo, window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loopAndPrint(PO document, int printFormatId, int windowNo, JFrame window) {
        window.setCursor(Cursor.getPredefinedCursor(3));
        int retValue = ADialogDialog.A_CANCEL;
        do {
            try {
                this.printDocument(document, printFormatId, windowNo);
            }
            catch (Exception d) {
            }
            finally {
                ADialogDialog d = new ADialogDialog((Frame)window, Env.getHeader(Env.getCtx(), windowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3);
                retValue = d.getReturnCode();
            }
        } while (retValue == ADialogDialog.A_CANCEL);
        window.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void print(List<PO> documentList, int printFormatId, int windowNo, boolean askPrint) {
        JFrame window = Env.getWindow(windowNo);
        StringBuffer documentLabels = new StringBuffer();
        documentList.stream().forEach(document -> {
            if (documentLabels.length() > 0) {
                documentLabels.append(Env.NL);
            }
            documentLabels.append(document.getDisplayValue());
        });
        if (!askPrint) {
            window.setCursor(Cursor.getPredefinedCursor(3));
            documentList.stream().forEach(document -> this.printDocument((PO)document, printFormatId, windowNo));
            window.setCursor(Cursor.getDefaultCursor());
        } else if (ADialog.ask(windowNo, window, "PrintAllDocuments", documentLabels.toString())) {
            window.setCursor(Cursor.getPredefinedCursor(3));
            documentList.stream().forEach(document -> this.printDocument((PO)document, printFormatId, windowNo));
            window.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void printDocument(PO document, int printFormatId, int windowNo) {
        String keyColumnName = document.get_KeyColumns()[0];
        MPrintFormat format = MPrintFormat.get(Env.getCtx(), printFormatId, false);
        if (format.getJasperProcess_ID() != 0) {
            try {
                ProcessBuilder.create(document.getCtx()).process(format.getJasperProcess_ID()).withRecordId(document.get_Table_ID(), document.get_ID()).withoutPrintPreview().execute(document.get_TrxName());
            }
            catch (Exception exception) {}
        } else {
            MQuery query = new MQuery(document.get_TableName());
            query.addRestriction(keyColumnName, "=", document.get_ValueAsInt(keyColumnName));
            PrintInfo info = new PrintInfo(document.get_TableName(), document.get_Table_ID(), document.get_ValueAsInt(keyColumnName));
            ReportEngine reportEngine = new ReportEngine(Env.getCtx(), format, query, info, document.get_TrxName());
            reportEngine.print();
            new Viewer(reportEngine);
        }
    }
}

