/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MResource;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.CAbstractForm;
import org.eevolution.form.CRPDetail;
import org.eevolution.form.action.ZoomMenuAction;
import org.eevolution.form.crp.CRPDatasetFactory;
import org.eevolution.form.crp.CRPModel;
import org.eevolution.manufacturing.model.MPPOrderNode;
import org.eevolution.manufacturing.tools.worker.SingleWorker;
import org.eevolution.tools.swing.SwingTool;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class VCRPDetail
extends CRPDetail
implements FormPanel {
    CAbstractForm m_form = new CAbstractForm(){};
    private VLookup resource;
    private VDate dateFrom;
    private VDate dateTo;
    private ChartPanel chartPanel;
    private JSplitPane contentPanel;
    private SingleWorker worker;
    protected CRPModel model;
    protected JPopupMenu popup;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_form.init(WindowNo, frame);
        this.fillPicks();
        this.jbInit();
    }

    private void jbInit() {
        this.dateFrom = new VDate("DateFrom", true, false, true, 15, "DateFrom");
        this.dateTo = new VDate("DateTo", true, false, true, 15, "DateTo");
        CPanel northPanel = new CPanel();
        northPanel.setLayout(new GridBagLayout());
        northPanel.add((Component)new CLabel(Msg.translate(Env.getCtx(), "S_Resource_ID")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        northPanel.add((Component)this.resource, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        northPanel.add((Component)new CLabel(Msg.translate(Env.getCtx(), "DateFrom")), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        northPanel.add((Component)this.dateFrom, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        northPanel.add((Component)new CLabel(Msg.translate(Env.getCtx(), "DateTo")), new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        northPanel.add((Component)this.dateTo, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        ConfirmPanel confirmPanel = new ConfirmPanel(true);
        confirmPanel.addActionListener(new ActionHandler());
        this.contentPanel = new JSplitPane(1);
        this.contentPanel.setPreferredSize(new Dimension(800, 600));
        this.m_form.getWindow().getContentPane().add((Component)northPanel, "North");
        this.m_form.getWindow().getContentPane().add((Component)this.contentPanel, "Center");
        this.m_form.getWindow().getContentPane().add((Component)confirmPanel, "South");
    }

    private void fillPicks() {
        Properties ctx = Env.getCtx();
        MLookup resourceL = MLookupFactory.get(ctx, this.m_form.getWindowNo(), 0, MColumn.getColumn_ID("S_Resource", "S_Resource_ID"), 19);
        this.resource = new VLookup("S_Resource_ID", false, false, true, resourceL);
    }

    protected JPopupMenu createPopup(JTree tree) {
        JPopupMenu pm = new JPopupMenu();
        ZoomMenuAction action = null;
        try {
            action = new ZoomMenuAction(tree);
            pm.add(action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pm;
    }

    private void handleTreeEvent(MouseEvent e) {
        if (e.getButton() == 3) {
            this.model.getTree().setSelectionPath(this.model.getTree().getPathForLocation(e.getX(), e.getY()));
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.model.getTree().getSelectionPath().getLastPathComponent();
            if (!(node.getUserObject() instanceof Date) && !(node.getUserObject() instanceof MPPOrderNode)) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        SwingTool.setCursorsFromChild(e.getComponent(), false);
    }

    private void handleActionEvent(ActionEvent e) {
        Timestamp df = this.getDateFrom();
        Timestamp dt = this.getDateTo();
        MResource r = this.getResource(this.resource.getValue());
        if (df != null && dt != null && r != null) {
            this.model = CRPDatasetFactory.get(df, dt, r);
            JFreeChart jfreechart = this.createChart(this.model.getDataset(), this.getChartTitle(), this.getSourceUOM(this.resource.getValue()));
            this.chartPanel = new ChartPanel(jfreechart, false);
            this.contentPanel.setLeftComponent((Component)this.chartPanel);
            JTree tree = this.model.getTree();
            tree.addMouseListener(new TreeHandler());
            this.contentPanel.setRightComponent(new JScrollPane(tree));
            this.popup = this.createPopup(tree);
            this.contentPanel.setDividerLocation(0.7);
            this.contentPanel.setVisible(true);
            this.contentPanel.validate();
            this.contentPanel.repaint();
        }
        SwingTool.setCursorsFromParent(this.m_form.getWindow(), false);
    }

    private String getChartTitle() {
        MResource r = this.getResource(this.resource.getValue());
        String title = r.getName() != null ? r.getName() : "";
        title = title + " " + r.getDescription() != null ? r.getDescription() : "";
        return title;
    }

    public Timestamp getDateFrom() {
        Timestamp t = null;
        if (this.dateFrom.getValue() != null) {
            t = (Timestamp)this.dateFrom.getValue();
        }
        return t;
    }

    public Timestamp getDateTo() {
        Timestamp t = null;
        if (this.dateTo.getValue() != null) {
            t = (Timestamp)this.dateTo.getValue();
        }
        return t;
    }

    @Override
    public void dispose() {
        this.m_form.dispose();
        if (this.resource != null) {
            this.resource.dispose();
        }
        this.resource = null;
        if (this.dateFrom != null) {
            this.dateFrom.dispose();
        }
        this.dateFrom = null;
        if (this.dateTo != null) {
            this.dateTo.dispose();
        }
        this.dateTo = null;
        if (this.worker != null) {
            this.worker.stop();
        }
        this.worker = null;
        this.chartPanel = null;
        this.contentPanel = null;
        this.popup = null;
    }

    class FrameHandler
    extends WindowAdapter {
        FrameHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            VCRPDetail.this.dispose();
        }
    }

    class TreeHandler
    extends MouseInputAdapter
    implements TreeSelectionListener {
        TreeHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (VCRPDetail.this.model.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                return;
            }
            SwingTool.setCursorsFromChild(e.getComponent(), true);
            final MouseEvent evt = e;
            VCRPDetail.this.worker = new SingleWorker(){

                @Override
                protected Object doIt() {
                    VCRPDetail.this.handleTreeEvent(evt);
                    return null;
                }
            };
            VCRPDetail.this.worker.start();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Ok")) {
                SwingTool.setCursorsFromParent(VCRPDetail.this.m_form.getWindow(), true);
                final ActionEvent evt = e;
                VCRPDetail.this.worker = new SingleWorker(){

                    @Override
                    protected Object doIt() {
                        VCRPDetail.this.handleActionEvent(evt);
                        return null;
                    }
                };
                VCRPDetail.this.worker.start();
            }
            if (e.getActionCommand().equals("Cancel")) {
                VCRPDetail.this.dispose();
            }
        }
    }
}

