/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MViewDefinition;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.Waiting;
import org.compiere.apps.form.FormFrame;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.MQuery;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CFrame;
import org.compiere.swing.CPanel;
import org.compiere.swing.CollapsiblePanel;
import org.compiere.util.ASyncProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Splash;
import org.eevolution.form.VBrowserSearch;
import org.eevolution.grid.Browser;
import org.eevolution.grid.VBrowserTable;

public class VBrowser
extends Browser
implements ActionListener,
ListSelectionListener,
ASyncProcess {
    private ProcessPanel processParameterPanel;
    protected StatusBar statusBar = new StatusBar();
    private Worker m_worker = null;
    private Waiting m_waiting = null;
    private CButton bCancel;
    private CButton bDelete;
    private CButton bUpdate;
    private CButton bExport;
    private CButton bOk;
    private CButton bSearch;
    private CButton bSelectAll;
    private CButton bZoom;
    private CPanel buttonSearchPanel;
    private JScrollPane centerPanel;
    private CPanel footButtonPanel;
    private CPanel footPanel;
    private CPanel graphPanel;
    private CPanel processPanel;
    private CPanel searchTab;
    private JTabbedPane tabsPanel;
    private JToolBar toolsBar;
    private CPanel topPanel;
    private VBrowserTable detail;
    private CollapsiblePanel collapsibleSearch;
    private VBrowserSearch searchPanel;
    private FormFrame m_frame;

    public static CFrame openBrowse(int windowNo, int browserId, String whereClause, Boolean isSOTrx) {
        MBrowse browse = new MBrowse(Env.getCtx(), browserId, null);
        boolean modal = false;
        if (windowNo > 0) {
            modal = true;
        }
        String value = "";
        String keyColumn = "";
        boolean multiSelection = true;
        FormFrame ff = new FormFrame(windowNo);
        return new VBrowser(ff, modal, windowNo, value, browse, keyColumn, multiSelection, whereClause, isSOTrx).getFrame();
    }

    public VBrowser(FormFrame frame, boolean modal, int WindowNo, String value, MBrowse browse, String keyColumn, boolean multiSelection, String whereClause, Boolean isSOTrx) {
        super(modal, WindowNo, value, browse, keyColumn, multiSelection, whereClause);
        this.m_frame = frame;
        this.m_frame.setTitle(browse.getTitle());
        this.m_frame.getContentPane().add((Component)this.statusBar, "South");
        this.windowNo = Env.createWindowNo(this.m_frame.getContainer());
        Env.setContext(Env.getCtx(), this.windowNo, "IsSOTrx", isSOTrx != false ? "Y" : "N");
        this.setProcessInfo(frame.getProcessInfo());
        this.copyWinContext();
        this.setContextWhere(whereClause);
        this.init();
    }

    @Override
    public void init() {
        this.initComponents();
        this.statInit();
        int no = this.detail.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (this.isExecuteQueryByDefault() && this.searchPanel.validateParameters() == null) {
            this.executeQuery();
        }
    }

    private void statInit() {
        if (this.getAD_Process_ID() > 0) {
            this.initProcessInfo();
            this.processParameterPanel = new ProcessPanel(this.getWindowNo(), this.getBrowseProcessInfo());
            this.processParameterPanel.setColumns(2);
            this.processParameterPanel.setShowButtons(false);
            this.processParameterPanel.setShowDescription(false);
            this.processParameterPanel.createFieldsAndEditors();
            if (this.processParameterPanel.hasParameters()) {
                CollapsiblePanel collapsibleProcess = new CollapsiblePanel(Msg.getMsg(Env.getCtx(), "Parameter"));
                collapsibleProcess.add(this.processParameterPanel.getPanel());
                collapsibleProcess.validate();
                this.processPanel.add(collapsibleProcess);
            }
        }
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
        Thread.yield();
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    protected void executeQuery() {
        this.reloadDependents();
        String errorMsg = this.searchPanel.validateParameters();
        if (errorMsg == null) {
            if (this.getAD_Window_ID() > 1) {
                this.bZoom.setEnabled(true);
            }
            this.bSelectAll.setEnabled(true);
            this.bExport.setEnabled(true);
            if (this.isDeleteable()) {
                this.bDelete.setEnabled(true);
            }
            if (this.isUpdateable()) {
                this.bUpdate.setEnabled(true);
            }
            this.loadedOK = this.initBrowser();
            if (this.m_worker != null && this.m_worker.isAlive()) {
                return;
            }
            int no = this.testCount();
            if (no > 0 && !ADialog.ask(this.getWindowNo(), this.m_frame.getContainer(), "InfoHighRecordCount", String.valueOf(no))) {
                return;
            }
            this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
            this.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
            this.m_worker = new Worker();
            this.m_worker.start();
        } else {
            ADialog.error(this.windowNo, this.m_frame.getContentPane(), "FillMandatory", Msg.parseTranslation(Env.getCtx(), errorMsg));
        }
    }

    private void reloadDependents() {
        Env.setContext(Env.getCtx(), 0, "currWindowNo", this.getWindowNo());
        if (this.processParameterPanel != null) {
            this.processParameterPanel.refreshContext();
        }
    }

    private boolean initBrowser() {
        this.initBrowserTable(this.detail);
        if (this.browserFields.size() == 0) {
            ADialog.error(this.getWindowNo(), this.m_frame.getContainer(), "Error", "No Browse Fields");
            this.log.log(Level.SEVERE, "No Browser for view=" + this.getViewName());
            return false;
        }
        return true;
    }

    private void cmd_zoom() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        MQuery query = this.getMQuery(this.detail);
        if (query != null) {
            AEnv.zoom(this.m_frame.getContainer(), this.getAD_Window_ID(), query);
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.bZoom.setSelected(false);
    }

    private void cmd_deleteSelection() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        boolean deleted = false;
        if (ADialog.ask(this.getWindowNo(), this.m_frame.getContainer(), "DeleteSelection")) {
            int records = this.deleteSelection(this.detail);
            this.setStatusLine(Msg.getMsg(Env.getCtx(), "Deleted") + " " + records, false);
            deleted = true;
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.bDelete.setSelected(false);
        if (deleted) {
            this.executeQuery();
        }
    }

    private void cmd_updateSelection() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        if (ADialog.ask(this.getWindowNo(), this.m_frame.getContainer(), "UpdateSelection")) {
            int records = this.updateSelection(this.detail);
            this.setStatusLine(Msg.getMsg(Env.getCtx(), "Updated") + " " + records, false);
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.bUpdate.setSelected(false);
    }

    private void setupToolBar() {
        this.bOk = ConfirmPanel.createOKButton(false);
        this.bOk.addActionListener(this);
        this.bSearch = ConfirmPanel.createRefreshButton(true);
        this.bSearch.addActionListener(this);
        this.bCancel = ConfirmPanel.createCancelButton(false);
        this.bCancel.addActionListener(this);
        this.bZoom = ConfirmPanel.createZoomButton(true);
        this.bZoom.addActionListener(this);
        this.bExport = ConfirmPanel.createExportButton(true);
        this.bExport.addActionListener(this);
        this.bDelete = ConfirmPanel.createDeleteButton(true);
        this.bDelete.addActionListener(this);
        AppsAction updateAction = new AppsAction("Save", null, Msg.getMsg(Env.getCtx(), "Update"));
        updateAction.setDelegate(this);
        this.bUpdate = (CButton)updateAction.getButton();
        AppsAction selectAllAction = new AppsAction("SelectAll", null, Msg.getMsg(Env.getCtx(), "SelectAll"));
        selectAllAction.setDelegate(this);
        this.bSelectAll = (CButton)selectAllAction.getButton();
        this.toolsBar = new JToolBar();
    }

    private void initComponents() {
        this.toolsBar = new JToolBar();
        this.tabsPanel = new JTabbedPane();
        this.searchTab = new CPanel();
        this.topPanel = new CPanel();
        this.searchPanel = new VBrowserSearch(this.getWindowNo(), this.getAD_Browse_ID(), 2);
        this.searchPanel.init();
        this.buttonSearchPanel = new CPanel();
        this.centerPanel = new JScrollPane();
        this.detail = new VBrowserTable(this);
        this.detail.setRowSelectionAllowed(true);
        this.detail.getSelectionModel().addListSelectionListener(this);
        this.footPanel = new CPanel();
        this.footButtonPanel = new CPanel(new FlowLayout(1));
        this.processPanel = new CPanel();
        this.graphPanel = new CPanel();
        this.setupToolBar();
        this.toolsBar.setRollover(true);
        this.bSelectAll.setText(Msg.getMsg(Env.getCtx(), "SelectAll").replaceAll("[&]", ""));
        this.bSelectAll.setHorizontalTextPosition(0);
        this.bSelectAll.setVerticalTextPosition(3);
        this.bSelectAll.setEnabled(false);
        this.toolsBar.add(this.bSelectAll);
        this.bZoom.setText(Msg.getMsg(Env.getCtx(), "Zoom").replaceAll("[&]", ""));
        this.bZoom.setFocusable(false);
        this.bZoom.setHorizontalTextPosition(0);
        this.bZoom.setVerticalTextPosition(3);
        this.bZoom.setEnabled(false);
        if (this.getAD_Window_ID() > 0) {
            this.toolsBar.add(this.bZoom);
        }
        this.bExport.setText(Msg.getMsg(Env.getCtx(), "Export"));
        this.bExport.setFocusable(false);
        this.bExport.setHorizontalTextPosition(0);
        this.bExport.setVerticalTextPosition(3);
        this.bExport.setEnabled(false);
        this.toolsBar.add(this.bExport);
        this.bDelete.setText(Msg.getMsg(Env.getCtx(), "Delete").replaceAll("[&]", ""));
        this.bDelete.setFocusable(false);
        this.bDelete.setHorizontalTextPosition(0);
        this.bDelete.setVerticalTextPosition(3);
        this.bDelete.setEnabled(false);
        if (this.isDeleteable()) {
            this.toolsBar.add(this.bDelete);
        }
        this.bUpdate.setText(Msg.getMsg(Env.getCtx(), "Update").replaceAll("[&]", ""));
        this.bUpdate.setFocusable(false);
        this.bUpdate.setHorizontalTextPosition(0);
        this.bUpdate.setVerticalTextPosition(3);
        this.bUpdate.setEnabled(false);
        if (this.isUpdateable()) {
            this.toolsBar.add(this.bUpdate);
        }
        this.m_frame.getContentPane().add((Component)this.toolsBar, "First");
        this.searchTab.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.collapsibleSearch = new CollapsiblePanel(Msg.getMsg(Env.getCtx(), "SearchCriteria"));
        this.collapsibleSearch.add(this.searchPanel.getPanel());
        this.topPanel.add((Component)this.collapsibleSearch, "North");
        this.bSearch.setText(Msg.getMsg(Env.getCtx(), "StartSearch"));
        this.buttonSearchPanel.add(this.bSearch);
        this.collapsibleSearch.add(this.buttonSearchPanel);
        this.searchTab.add((Component)this.topPanel, "North");
        this.centerPanel.setViewportView(this.detail);
        this.searchTab.add((Component)this.centerPanel, "Center");
        this.footPanel.setLayout(new BorderLayout());
        this.footButtonPanel.add(this.bCancel);
        this.footButtonPanel.add(this.bOk);
        this.footPanel.add((Component)this.footButtonPanel, "South");
        this.processPanel.setLayout(new BorderLayout());
        this.footPanel.add((Component)this.processPanel, "Center");
        this.searchTab.add((Component)this.footPanel, "South");
        this.tabsPanel.addTab(Msg.getMsg(Env.getCtx(), "Search"), this.searchTab);
        this.graphPanel.setLayout(new BorderLayout());
        this.m_frame.getContentPane().add((Component)this.tabsPanel, "Center");
    }

    private void cmd_Process() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        this.m_ok = true;
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.log.config("Worker alive=" + this.m_worker.isAlive());
        }
        this.m_worker = null;
        this.saveResultSelection(this.detail);
        this.saveSelection(this.detail);
        boolean isOk = false;
        if (this.getAD_Process_ID() > 0 && this.getSelectedKeys() != null) {
            this.processParameterPanel.getProcessInfo().setAD_PInstance_ID(-1);
            if (this.processParameterPanel.validateParameters() == null && this.processParameterPanel.saveParameters() == null) {
                ProcessInfo pi = this.processParameterPanel.getProcessInfo();
                if (this.getFieldKey() != null && this.getFieldKey().get_ID() > 0) {
                    MViewDefinition viewDefinition = (MViewDefinition)this.getFieldKey().getAD_View_Column().getAD_View_Definition();
                    pi.setAliasForTableSelection(viewDefinition.getTableAlias());
                    pi.setTableSelectionId(viewDefinition.getAD_Table_ID());
                }
                pi.setSelectionValues(this.getSelectedValues());
                this.setBrowseProcessInfo(pi);
                ProcessCtl worker = new ProcessCtl(this, this.getWindowNo(), pi, null);
                String msg = Msg.getMsg(Env.getCtx(), "Processing");
                this.m_waiting = this.m_frame.isDialog() ? new Waiting((Dialog)this.m_frame.getCDialog(), msg, false, this.getBrowseProcessInfo().getEstSeconds()) : new Waiting((Frame)this.m_frame.getCFrame(), msg, false, this.getBrowseProcessInfo().getEstSeconds());
                worker.run();
                this.m_waiting.doNotWait();
                this.setStatusLine(pi.getSummary(), pi.isError());
                isOk = !pi.isError();
            }
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        if (isOk) {
            if (this.getParentWindowNo() > 0) {
                this.dispose();
                return;
            }
            this.loadedOK = this.initBrowser();
            this.collapsibleSearch.setCollapsed(false);
        }
    }

    private void cmd_Cancel() {
        this.dispose();
    }

    public void dispose() {
        Env.clearWinContext(this.getWindowNo());
        this.searchPanel.dispose();
        this.m_frame.dispose();
    }

    private void cmd_Search() {
        this.bZoom.setEnabled(true);
        this.bSelectAll.setEnabled(true);
        this.bExport.setEnabled(true);
        this.bDelete.setEnabled(true);
        this.bUpdate.setEnabled(true);
        Env.setContext(Env.getCtx(), 0, "currWindowNo", this.getWindowNo());
        if (this.getAD_Process_ID() > 0) {
            this.processParameterPanel.refreshContext();
        }
        this.executeQuery();
    }

    private void cmd_Export() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            File file = this.exportXLS(this.detail);
            Env.startBrowser(file.toURI().toString());
        }
        catch (Exception e) {
            throw new AdempiereException("Failed to render report", e);
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.bExport.setSelected(false);
    }

    public CFrame getForm() {
        return this.m_frame.getCFrame();
    }

    public static void main(String[] args) {
        Splash.getSplash();
        Adempiere.startup(true);
        Ini.setProperty("ApplicationUserID", "SuperUser");
        Ini.setProperty("ApplicationPassword", "System");
        Ini.setProperty("Role", "GardenWorld Admin");
        Ini.setProperty("Client", "GardenWorld");
        Ini.setProperty("Organization", "HQ");
        Ini.setProperty("Warehouse", "HQ Warehouse");
        Ini.setProperty("Language", "English");
        Login login = new Login(Env.getCtx());
        login.batchLogin();
        Properties m_ctx = Env.getCtx();
        MBrowse browse = new MBrowse(m_ctx, 50025, null);
        FormFrame frame = new FormFrame(0);
        boolean modal = true;
        int WindowNo = 0;
        String value = "";
        String keyColumn = "";
        boolean multiSelection = true;
        String whereClause = "";
        VBrowser browser = new VBrowser(frame, modal, WindowNo, value, browse, keyColumn, multiSelection, whereClause, true);
        browser.getFrame().setVisible(true);
        browser.getFrame().pack();
    }

    public CFrame getFrame() {
        return this.m_frame.getCFrame();
    }

    public Dimension getPreferredSize() {
        Dimension size = this.m_frame.getPreferredSize();
        if (size.width > 1024) {
            size.width = 994;
        }
        return size;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String action = actionEvent.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        this.log.info("VBrowser - actionPerformed: " + action);
        if (actionEvent.getSource().equals(this.bSelectAll)) {
            this.selectedRows(this.detail);
        } else if (actionEvent.getSource().equals(this.bSearch)) {
            this.cmd_Search();
        } else if (actionEvent.getSource().equals(this.bCancel)) {
            this.cmd_Cancel();
        } else if (actionEvent.getSource().equals(this.bOk)) {
            this.cmd_Process();
        } else if (actionEvent.getSource().equals(this.bExport)) {
            this.cmd_Export();
        } else if (actionEvent.getSource().equals(this.bDelete)) {
            this.cmd_deleteSelection();
        } else if (actionEvent.getSource().equals(this.bUpdate)) {
            this.cmd_updateSelection();
        } else if (actionEvent.getSource().equals(this.bZoom)) {
            this.cmd_zoom();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.detail.getRowCount() == 0) {
            return;
        }
        int rowTable = this.detail.getSelectedRow();
        int rowCurrent = this.detail.getData().getCurrentRow();
        this.log.config("(" + this.detail.toString() + ") Row in Table=" + rowTable + ", in Model=" + rowCurrent);
        if (rowTable == -1) {
            if (rowCurrent >= 0) {
                this.detail.setRowSelectionInterval(rowCurrent, rowCurrent);
                return;
            }
        } else if (rowTable != rowCurrent) {
            this.detail.getData().setCurrentRow(rowTable);
        }
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }

    @Override
    public boolean isUILocked() {
        return false;
    }

    @Override
    public void lockUI(ProcessInfo pi) {
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.processParameterPanel.setProcessInfo(pi);
        this.processParameterPanel.openResult();
    }

    @Override
    public LinkedHashMap<String, GridField> getPanelParameters() {
        LinkedHashMap<String, GridField> m_List = new LinkedHashMap<String, GridField>();
        for (Map.Entry<String, Object> entry : this.searchPanel.getParameters().entrySet()) {
            VEditor editor = (VEditor)entry.getValue();
            if (!((Component)((Object)editor)).isVisible() || editor.getField().isInfoOnly()) continue;
            GridField field = editor.getField();
            m_List.put(entry.getKey(), field);
        }
        return m_List;
    }

    class Worker
    extends Thread {
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;
        private String dataSql = null;

        Worker() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            int no = 0;
            this.dataSql = VBrowser.this.getSQL();
            int row = 0;
            VBrowser.this.detail.setRowCount(row);
            try {
                this.m_pstmt = VBrowser.this.getStatement(this.dataSql);
                VBrowser.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                this.m_rs = this.m_pstmt.executeQuery();
                VBrowser.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                row = VBrowser.this.detail.loadTable(this.m_rs);
            }
            catch (SQLException e) {
                VBrowser.this.log.log(Level.SEVERE, this.dataSql, e);
            }
            this.close();
            VBrowser.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            VBrowser.this.detail.autoSize();
            VBrowser.this.m_frame.setCursor(Cursor.getDefaultCursor());
            VBrowser.this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
            VBrowser.this.setStatusDB(Integer.toString(no));
            if (no == 0) {
                VBrowser.this.log.fine(this.dataSql);
            } else {
                VBrowser.this.detail.getSelectionModel().setSelectionInterval(0, 0);
                VBrowser.this.detail.requestFocus();
            }
            VBrowser.this.isAllSelected = VBrowser.this.isSelectedByDefault();
            if (VBrowser.this.isAllSelected) {
                VBrowser.this.selectedRows(VBrowser.this.detail);
            }
            if (row > 0) {
                VBrowser.this.collapsibleSearch.setCollapsed(VBrowser.this.isCollapsibleByDefault());
            }
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
        }
    }
}

