/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.adempiere.core.domains.models.X_M_AttributeSet;
import org.adempiere.core.domains.models.X_M_MovementLine;
import org.adempiere.core.domains.models.X_M_Storage;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.distribution.process.MovementGenerateAbstract;
import org.eevolution.distribution.services.InventoryMovementService;

public class MovementGenerate
extends MovementGenerateAbstract {
    private MMovement movement = null;
    private int createdCount = 0;
    private int lineNo = 0;
    private int lastPartnerLocationId = -1;
    private HashMap<SParameter, MStorage[]> storage = new HashMap();
    private SParameter lastParameter = null;
    private MStorage[] lastStorage = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MDDOrder> list;
        this.log.info("Selection=" + this.isSelection() + ", M_Warehouse_ID=" + this.getWarehouseId() + ", C_BPartner_ID=" + this.getBPartnerId() + ", Consolidate=" + this.isConsolidateDocument() + ", IsUnconfirmed=" + this.isUnconfirmedInOut() + ", Movement=" + this.getMovementDate());
        if (this.isSelection()) {
            list = this.getInstancesForSelection(this.get_TrxName());
        } else {
            if (this.getWarehouseId() <= 0) {
                throw new AdempiereException("@M_Warehouse_ID@ @NotFound@");
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            stringBuilder.append("DocStatus").append("=? AND ").append("IsDropShip").append("=? AND ").append("DeliveryViaRule").append("<>? AND ").append("EXISTS (SELECT 1 FROM DD_OrderLine ol WHERE ").append("EXISTS (SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID=ol.M_Locator_ID AND l.M_Warehouse_ID=?) ");
            arrayList.add("CO");
            arrayList.add(false);
            arrayList.add("M");
            arrayList.add(this.getWarehouseId());
            Optional.ofNullable(this.getDatePromised()).ifPresent(timestamp -> {
                stringBuilder.append("AND TRUNC(ol.DatePromised) <= TRUNC(?) ");
                arrayList.add(timestamp);
            });
            if (this.getBPartnerId() > 0) {
                stringBuilder.append(" AND ").append("C_BPartner_ID").append("=? ");
                arrayList.add(this.getBPartnerId());
            }
            stringBuilder.append("AND ol.DD_Order_ID=DD_Order.DD_Order_ID AND ol.QtyOrdered <> ol.QtyInTransit )");
            stringBuilder2.append("M_Warehouse_ID, PriorityRule, M_Shipper_ID, C_BPartner_ID, C_BPartner_Location_ID, DD_Order_ID");
            list = new Query(this.getCtx(), "DD_Order", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).setOrderBy(stringBuilder2.toString()).list();
        }
        return this.generate(list);
    }

    private MClient getClient() {
        return MClient.get(this.getCtx());
    }

    private String generate(List<MDDOrder> list) {
        list.stream().filter(mDDOrder -> mDDOrder != null).forEach(mDDOrder -> {
            this.getCurrentMovement().filter(mMovement -> mMovement != null || !this.isConsolidateDocument()).filter(mMovement -> mMovement.getC_BPartner_Location_ID() != mDDOrder.getC_BPartner_Location_ID() || mMovement.getM_Shipper_ID() != mDDOrder.getM_Shipper_ID()).ifPresent(mMovement -> this.completeMovement());
            this.log.fine("check: " + mDDOrder + " - DeliveryRule=" + mDDOrder.getDeliveryRule());
            Timestamp timestamp = this.getMovementDate();
            StringBuilder stringBuilder = new StringBuilder(" 1=1 ");
            if (this.getWarehouseId() > 0) {
                stringBuilder.append(" AND ").append(this.getWarehouseId()).append(" IN (SELECT l.M_Warehouse_ID FROM M_Locator l WHERE l.M_Locator_ID=M_Locator_ID) ");
            }
            if (this.getDatePromised() != null) {
                stringBuilder.append(" AND (TRUNC(DatePromised)<=").append(DB.TO_DATE(this.getDatePromised(), true)).append(" OR DatePromised IS NULL)");
            }
            if (!"F".equals(mDDOrder.getDeliveryRule())) {
                stringBuilder.append(" AND (DD_OrderLine.M_Product_ID IS NULL").append(" OR EXISTS (SELECT * FROM M_Product p ").append("WHERE DD_OrderLine.M_Product_ID=p.M_Product_ID").append(" AND IsExcludeAutoDelivery='N'))");
            }
            if (!this.isUnconfirmedInOut()) {
                stringBuilder.append(" AND NOT EXISTS (SELECT * FROM M_MovementLine iol").append(" INNER JOIN M_Movement io ON (iol.M_Movement_ID=io.M_Movement_ID) ").append("WHERE iol.DD_OrderLine_ID=DD_OrderLine.DD_OrderLine_ID AND io.DocStatus IN ('IP','WC'))");
            }
            List<MDDOrderLine> list = mDDOrder.getLines(stringBuilder.toString(), "M_Product_ID");
            list.stream().filter(mDDOrderLine -> mDDOrderLine.getM_Product_ID() > 0 || mDDOrderLine.getC_Charge_ID() > 0).filter(mDDOrderLine -> mDDOrderLine.getConfirmedQty().signum() != 0).forEach(mDDOrderLine -> {
                PO[] pOArray;
                String string;
                MLocator mLocator = new MLocator(this.getCtx(), mDDOrderLine.getM_Locator_ID(), this.get_TrxName());
                if (this.getWarehouseId() > 0 && mLocator.getM_Warehouse_ID() != this.getWarehouseId()) {
                    return;
                }
                this.log.fine("check: " + mDDOrderLine);
                BigDecimal bigDecimal = Env.ZERO;
                BigDecimal bigDecimal2 = mDDOrderLine.getConfirmedQty();
                MProduct mProduct = mDDOrderLine.getProduct();
                BigDecimal bigDecimal3 = Env.ZERO;
                if (this.isUnconfirmedInOut() && mProduct != null && bigDecimal2.signum() != 0) {
                    string = "EXISTS (SELECT * FROM M_Movement io WHERE io.M_Movement_ID=M_MovementLine.M_Movement_ID AND io.DocStatus IN ('IP','WC'))";
                    pOArray = MMovementLine.getOfOrderLine(this.getCtx(), mDDOrderLine.getDD_OrderLine_ID(), string, null);
                    bigDecimal3 = Arrays.asList(pOArray).stream().map(X_M_MovementLine::getMovementQty).reduce(BigDecimal.ZERO, BigDecimal::add);
                    String string2 = "Unconfirmed Qty=" + bigDecimal3 + " - ToDeliver=" + mDDOrderLine.getConfirmedQty() + "->";
                    bigDecimal2 = mDDOrderLine.getConfirmedQty().subtract(bigDecimal3);
                    string2 = string2 + bigDecimal2;
                    if (bigDecimal2.signum() < 0) {
                        bigDecimal2 = Env.ZERO;
                        string2 = string2 + " (set to 0)";
                    }
                    bigDecimal = bigDecimal.subtract(bigDecimal3);
                    this.log.fine(string2);
                }
                if (!(mProduct != null && mProduct.isStocked() || mDDOrderLine.getQtyOrdered().signum() != 0 && bigDecimal2.signum() == 0)) {
                    if (!"O".equals(mDDOrder.getDeliveryRule())) {
                        this.createLine((MDDOrder)mDDOrder, (MDDOrderLine)mDDOrderLine, bigDecimal2, null, false);
                    }
                    return;
                }
                string = this.getPolicyIssue(mProduct);
                pOArray = this.getStorages(mLocator.getM_Warehouse_ID(), mDDOrderLine.getM_Product_ID(), mDDOrderLine.getM_AttributeSetInstance_ID(), mProduct.getM_AttributeSet_ID(), mDDOrderLine.getM_AttributeSetInstance_ID() == 0, timestamp, "F".equals(string));
                bigDecimal = Arrays.asList(pOArray).stream().map(X_M_Storage::getQtyOnHand).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean bl = bigDecimal.compareTo(bigDecimal2) >= 0 || bigDecimal2.signum() < 0;
                boolean bl2 = "O".equals(mDDOrder.getDeliveryRule());
                if (bl2 && !bl) {
                    this.log.fine("Failed CompleteOrder - OnHand=" + bigDecimal + " (Unconfirmed=" + bigDecimal3 + "), ToDeliver=" + bigDecimal2 + " - " + mDDOrderLine);
                    return;
                }
                if (bl && "L".equals(mDDOrder.getDeliveryRule())) {
                    this.log.fine("CompleteLine - OnHand=" + bigDecimal + " (Unconfirmed=" + bigDecimal3 + ", ToDeliver=" + bigDecimal2 + " - " + mDDOrderLine);
                    this.createLine((MDDOrder)mDDOrder, (MDDOrderLine)mDDOrderLine, bigDecimal2, (MStorage[])pOArray, false);
                } else if ("A".equals(mDDOrder.getDeliveryRule()) && (bigDecimal.signum() > 0 || mDDOrderLine.getConfirmedQty().signum() < 0)) {
                    BigDecimal bigDecimal4 = mDDOrderLine.getConfirmedQty();
                    this.log.fine("Available - OnHand=" + bigDecimal + " (Unconfirmed=" + bigDecimal3 + "), ToDeliver=" + bigDecimal2 + ", Delivering=" + bigDecimal4 + " - " + mDDOrderLine);
                    if (bigDecimal4.compareTo(bigDecimal) > 0) {
                        bigDecimal4 = bigDecimal;
                    }
                    this.createLine((MDDOrder)mDDOrder, (MDDOrderLine)mDDOrderLine, bigDecimal4, (MStorage[])pOArray, false);
                } else if ("F".equals(mDDOrder.getDeliveryRule())) {
                    BigDecimal bigDecimal5 = bigDecimal2;
                    this.log.fine("Force - OnHand=" + bigDecimal + " (Unconfirmed=" + bigDecimal3 + "), ToDeliver=" + bigDecimal2 + ", Delivering=" + bigDecimal5 + " - " + mDDOrderLine);
                    this.createLine((MDDOrder)mDDOrder, (MDDOrderLine)mDDOrderLine, bigDecimal5, (MStorage[])pOArray, true);
                } else if ("M".equals(mDDOrder.getDeliveryRule())) {
                    this.log.fine("Manual - OnHand=" + bigDecimal + " (Unconfirmed=" + bigDecimal3 + ") - " + mDDOrderLine);
                } else {
                    this.log.fine("Failed: " + mDDOrder.getDeliveryRule() + " - OnHand=" + bigDecimal + " (Unconfirmed=" + bigDecimal3 + "), ToDeliver=" + bigDecimal2 + " - " + mDDOrderLine);
                }
            });
            boolean bl = "O".equals(mDDOrder.getDeliveryRule());
            if (bl && "O".equals(mDDOrder.getDeliveryRule())) {
                for (MDDOrderLine mDDOrderLine2 : list) {
                    MLocator mLocator = new MLocator(this.getCtx(), mDDOrderLine2.getM_Locator_ID(), this.get_TrxName());
                    if (this.getWarehouseId() > 0 && mLocator.getM_Warehouse_ID() != this.getWarehouseId()) continue;
                    MProduct mProduct = mDDOrderLine2.getProduct();
                    BigDecimal bigDecimal = mDDOrderLine2.getQtyOrdered().subtract(mDDOrderLine2.getQtyDelivered());
                    MStorage[] mStorageArray = null;
                    if (mProduct != null && mProduct.isStocked()) {
                        MProductCategory mProductCategory = MProductCategory.get(mDDOrder.getCtx(), mProduct.getM_Product_Category_ID());
                        String string = mProductCategory.getMMPolicy();
                        if (string == null || string.length() == 0) {
                            string = this.getClient().getMMPolicy();
                        }
                        mStorageArray = this.getStorages(mLocator.getM_Warehouse_ID(), mDDOrderLine2.getM_Product_ID(), mDDOrderLine2.getM_AttributeSetInstance_ID(), mProduct.getM_AttributeSet_ID(), mDDOrderLine2.getM_AttributeSetInstance_ID() == 0, timestamp, "F".equals(string));
                    }
                    this.createLine((MDDOrder)mDDOrder, mDDOrderLine2, bigDecimal, mStorageArray, false);
                }
            }
            this.lineNo += 1000;
            this.completeMovement();
        });
        return "@Created@ = " + this.createdCount;
    }

    private String getPolicyIssue(MProduct mProduct) {
        MProductCategory mProductCategory = MProductCategory.get(mProduct.getCtx(), mProduct.getM_Product_Category_ID());
        String string = mProductCategory.getMMPolicy();
        if (string == null || string.length() == 0) {
            string = this.getClient().getMMPolicy();
        }
        return string;
    }

    private void createLine(MDDOrder mDDOrder, MDDOrderLine mDDOrderLine, BigDecimal bigDecimal, MStorage[] mStorageArray, boolean bl) {
        Cloneable cloneable;
        if (this.lastPartnerLocationId != mDDOrder.getC_BPartner_Location_ID()) {
            this.completeMovement();
        }
        this.lastPartnerLocationId = mDDOrder.getC_BPartner_Location_ID();
        MMovement mMovement = this.getCurrentMovement().orElseGet(() -> {
            int n;
            MLocator mLocator = MLocator.get(this.getCtx(), mDDOrderLine.getM_Locator_ID());
            this.movement = InventoryMovementService.createMovementFromOrder(mDDOrder, this.getMovementDate());
            this.movement.setAD_Org_ID(mLocator.getAD_Org_ID());
            this.movement.setIsInTransit(true);
            if (mDDOrder.getC_BPartner_ID() != mDDOrder.getC_BPartner_ID()) {
                this.movement.setC_BPartner_ID(mDDOrder.getC_BPartner_ID());
            }
            if (mDDOrder.getC_BPartner_Location_ID() != mDDOrder.getC_BPartner_Location_ID()) {
                this.movement.setC_BPartner_Location_ID(mDDOrder.getC_BPartner_Location_ID());
            }
            if ((n = MDocType.getDocType("MMM", this.movement.getAD_Org_ID())) > 0) {
                this.movement.setC_DocType_ID(n);
            }
            this.movement.saveEx();
            this.addLog(this.movement.get_ID(), this.movement.getMovementDate(), BigDecimal.ZERO, this.movement.getDocumentInfo());
            this.setCurrentMovement(this.movement);
            return this.movement;
        });
        if (mStorageArray == null) {
            MMovementLine mMovementLine = new MMovementLine(mMovement);
            InventoryMovementService.setMovementOrderLine(mMovementLine, mDDOrderLine, Env.ZERO, false);
            mMovementLine.setMovementQty(bigDecimal);
            if (mDDOrderLine.getQtyEntered().compareTo(mDDOrderLine.getQtyOrdered()) != 0) {
                mMovementLine.setMovementQty(bigDecimal.multiply(mDDOrderLine.getQtyEntered()).divide(mDDOrderLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
            }
            mMovementLine.setLine(this.lineNo + mDDOrderLine.getLine());
            if (!mMovementLine.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            this.log.fine(mMovementLine.toString());
            return;
        }
        MProduct mProduct = mDDOrderLine.getProduct();
        boolean bl2 = false;
        if (mProduct.getM_AttributeSet_ID() != 0) {
            cloneable = MAttributeSet.get(this.getCtx(), mProduct.getM_AttributeSet_ID());
            bl2 = ((X_M_AttributeSet)cloneable).isInstanceAttribute();
        }
        cloneable = new ArrayList();
        BigDecimal bigDecimal2 = bigDecimal;
        for (int i = 0; i < mStorageArray.length; ++i) {
            BigDecimal bigDecimal3 = bigDecimal2;
            MStorage mStorage = mStorageArray[i];
            if (bigDecimal3.compareTo(mStorage.getQtyOnHand()) > 0 && mStorage.getQtyOnHand().signum() >= 0 && (!bl || bl && i + 1 != mStorageArray.length)) {
                bigDecimal3 = mStorage.getQtyOnHand();
            }
            if (bigDecimal3.signum() == 0) continue;
            int n = mStorage.getM_Locator_ID();
            X_M_MovementLine x_M_MovementLine = null;
            if (!bl2) {
                for (int j = 0; j < ((ArrayList)cloneable).size(); ++j) {
                    MMovementLine mMovementLine = (MMovementLine)((ArrayList)cloneable).get(j);
                    if (mMovementLine.getM_Locator_ID() != n) continue;
                    x_M_MovementLine = mMovementLine;
                    break;
                }
            }
            if (x_M_MovementLine == null) {
                x_M_MovementLine = new MMovementLine(mMovement);
                InventoryMovementService.setMovementOrderLine((MMovementLine)x_M_MovementLine, mDDOrderLine, bigDecimal3, false);
                ((MMovementLine)x_M_MovementLine).setMovementQty(bigDecimal3);
                ((ArrayList)cloneable).add(x_M_MovementLine);
            } else {
                ((MMovementLine)x_M_MovementLine).setMovementQty(x_M_MovementLine.getMovementQty().add(bigDecimal3));
            }
            if (mDDOrderLine.getQtyEntered().compareTo(mDDOrderLine.getQtyOrdered()) != 0) {
                ((MMovementLine)x_M_MovementLine).setMovementQty(x_M_MovementLine.getMovementQty().multiply(mDDOrderLine.getQtyEntered()).divide(mDDOrderLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
            }
            x_M_MovementLine.setLine(this.lineNo + mDDOrderLine.getLine());
            if (bl2) {
                x_M_MovementLine.setM_AttributeSetInstance_ID(mStorage.getM_AttributeSetInstance_ID());
            }
            x_M_MovementLine.saveEx();
            this.log.fine("ToDeliver=" + bigDecimal + "/" + bigDecimal3 + " - " + (MMovementLine)x_M_MovementLine);
            bigDecimal2 = bigDecimal2.subtract(bigDecimal3);
            mStorage.setQtyOnHand(mStorage.getQtyOnHand().subtract(bigDecimal3));
            if (bigDecimal2.signum() == 0) break;
        }
        if (bigDecimal2.signum() != 0) {
            throw new IllegalStateException("Not All Delivered - Remainder=" + bigDecimal2);
        }
    }

    private MStorage[] getStorages(int n, int n2, int n3, int n4, boolean bl, Timestamp timestamp, boolean bl2) {
        this.lastParameter = new SParameter(n, n2, n3, n4, bl, timestamp, bl2);
        this.lastStorage = this.storage.get(this.lastParameter);
        if (this.lastStorage == null) {
            this.lastStorage = MStorage.getWarehouse(this.getCtx(), n, n2, n3, n4, bl, timestamp, bl2, this.get_TrxName());
            this.storage.put(this.lastParameter, this.lastStorage);
        }
        return this.lastStorage;
    }

    private Optional<MMovement> getCurrentMovement() {
        return Optional.ofNullable(this.movement);
    }

    private void setCurrentMovement(MMovement mMovement) {
        this.movement = mMovement;
    }

    private void completeMovement() {
        this.getCurrentMovement().ifPresent(mMovement -> {
            if (!mMovement.processIt(this.getDocAction())) {
                this.log.warning("Failed: " + this.movement);
            }
            mMovement.saveEx();
            this.addLog(0, mMovement.getMovementDate(), null, mMovement.getDocumentInfo());
            ++this.createdCount;
            this.storage = new HashMap();
            this.lastParameter = null;
            this.lastStorage = null;
        });
        this.setCurrentMovement(null);
        this.lineNo = 0;
    }

    class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int n, int n2, int n3, int n4, boolean bl, Timestamp timestamp, boolean bl2) {
            this.M_Warehouse_ID = n;
            this.M_Product_ID = n2;
            this.M_AttributeSetInstance_ID = n3;
            this.M_AttributeSet_ID = n4;
            this.allAttributeInstances = bl;
            this.minGuaranteeDate = timestamp;
            this.FiFo = bl2;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof SParameter) {
                boolean bl;
                SParameter sParameter = (SParameter)object;
                boolean bl2 = bl = sParameter.M_Warehouse_ID == this.M_Warehouse_ID && sParameter.M_Product_ID == this.M_Product_ID && sParameter.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && sParameter.M_AttributeSet_ID == this.M_AttributeSet_ID && sParameter.allAttributeInstances == this.allAttributeInstances && sParameter.FiFo == this.FiFo;
                if (!(!bl || sParameter.minGuaranteeDate == null && this.minGuaranteeDate == null || sParameter.minGuaranteeDate != null && this.minGuaranteeDate != null && sParameter.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            long l = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                l *= -1L;
            }
            if (this.FiFo) {
                // empty if block
            }
            if ((l *= -2L) < 0L) {
                l = -l + 7L;
            }
            while (l > Integer.MAX_VALUE) {
                l -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                l += (long)this.minGuaranteeDate.hashCode();
                while (l > Integer.MAX_VALUE) {
                    l -= Integer.MAX_VALUE;
                }
            }
            return (int)l;
        }
    }
}

