/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.math.BigDecimal;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.PO;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.distribution.process.GenerateMovementMaterialAbstract;
import org.eevolution.distribution.services.InventoryMovementService;

public class GenerateMovementMaterial
extends GenerateMovementMaterialAbstract {
    protected MMovement movement = null;
    protected String result;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<?> list = this.getInstancesForSelection(this.get_TrxName());
        list.stream().filter(mDDOrderLine -> mDDOrderLine != null).forEach(mDDOrderLine -> {
            this.createMovement((MDDOrderLine)mDDOrderLine);
            MMovementLine mMovementLine = new MMovementLine(this.movement);
            BigDecimal bigDecimal = this.getSelectionAsBigDecimal(mDDOrderLine.get_ID(), "LINE_QtyInTransit");
            if (bigDecimal == null | bigDecimal.compareTo(mDDOrderLine.getQtyInTransit()) > 0) {
                throw new AdempiereException("Error @QtyInTransit@");
            }
            InventoryMovementService.setMovementOrderLine(mMovementLine, mDDOrderLine, bigDecimal, true);
            mMovementLine.saveEx();
        });
        this.movement.processIt("CO");
        this.movement.saveEx();
        this.printDocument((PO)this.movement, "Inventory Move Hdr (Example)");
        return this.result;
    }

    private void createMovement(MDDOrderLine mDDOrderLine) {
        if (this.movement != null && this.movement.get_ID() > 0) {
            return;
        }
        this.movement = InventoryMovementService.createMovementFromOrder(mDDOrderLine.getParent(), this.getMovementDate());
        int n = MDocType.getDocType("MMM", mDDOrderLine.getAD_Org_ID());
        if (n <= 0) {
            throw new AdempiereException("@C_DocType_ID@ @NotFound@");
        }
        this.movement.setC_DocType_ID(n);
        this.movement.saveEx();
    }
}

