/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.util.Arrays;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MMovement;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.process.GenerateMovementAbstract;
import org.eevolution.distribution.process.MovementGenerate;
import org.eevolution.services.dsl.ProcessBuilder;

public class GenerateMovement
extends GenerateMovementAbstract {
    private String result;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(MovementGenerate.getProcessId()).withTitle(GenerateMovement.getProcessName()).withRecordId(MDDOrder.Table_ID, 0).withSelectedRecordsIds(MDDOrder.Table_ID, this.getSelectionKeys()).withParameter("MovementDate", this.getMovementDate()).withParameter("DocAction", "CO").execute();
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        this.result = processInfo.getSummary();
        int[] nArray = processInfo.getIDs();
        if (nArray != null && nArray.length > 0) {
            Arrays.stream(nArray).filter(n -> n > 0).forEach(n -> {
                MMovement mMovement = new MMovement(this.getCtx(), n, null);
                StringBuffer stringBuffer = new StringBuffer(Msg.translate(Env.getCtx(), "DocumentNo") + " : " + mMovement.getDocumentNo());
                this.result = this.result == null ? " " + stringBuffer.toString() : this.result + " " + stringBuffer.toString();
                this.printDocument((PO)mMovement, "Inventory Move Hdr (Example)");
            });
        }
        return this.result;
    }
}

