/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_DocType;
import org.adempiere.core.domains.models.X_DD_Order;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MPeriod;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.distribution.process.GenerateMovement;
import org.eevolution.distribution.process.GenerateMovementMaterial;
import org.eevolution.services.dsl.ProcessBuilder;

public class MDDOrder
extends X_DD_Order
implements DocAction {
    private static final long serialVersionUID = -5997157712614274458L;
    private List<MDDOrderLine> orderLines = null;
    private boolean m_forceCreation = false;
    private String processMessage = null;
    private boolean justPrepared = false;

    public static MDDOrder copyFrom(MDDOrder mDDOrder, Timestamp timestamp, int n, boolean bl, boolean bl2, boolean bl3, String string) {
        MDDOrder mDDOrder2 = new MDDOrder(mDDOrder.getCtx(), 0, string);
        mDDOrder2.set_TrxName(string);
        PO.copyValues(mDDOrder, mDDOrder2, mDDOrder.getAD_Client_ID(), mDDOrder.getAD_Org_ID());
        mDDOrder2.set_ValueNoCheck("DD_Order_ID", I_ZERO);
        mDDOrder2.set_ValueNoCheck("DocumentNo", null);
        mDDOrder2.setDocStatus("DR");
        mDDOrder2.setDocAction("CO");
        mDDOrder2.setC_DocType_ID(0);
        mDDOrder2.setIsSOTrx(bl);
        mDDOrder2.setIsSelected(false);
        mDDOrder2.setDateOrdered(timestamp);
        mDDOrder2.setDatePromised(timestamp);
        mDDOrder2.setDatePrinted(null);
        mDDOrder2.setIsPrinted(false);
        mDDOrder2.setIsApproved(false);
        mDDOrder2.setIsDelivered(false);
        mDDOrder2.setPosted(false);
        mDDOrder2.setProcessed(false);
        if (bl2) {
            mDDOrder2.setRef_Order_ID(mDDOrder.getDD_Order_ID());
        } else {
            mDDOrder2.setRef_Order_ID(0);
        }
        if (!mDDOrder2.save(string)) {
            throw new IllegalStateException("Could not create Order");
        }
        if (bl2) {
            mDDOrder.setRef_Order_ID(mDDOrder2.getDD_Order_ID());
        }
        if (mDDOrder2.copyLinesFrom(mDDOrder, bl2, bl3) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        return mDDOrder2;
    }

    public MDDOrder(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsSelected(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsDelivered(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
        }
    }

    public MDDOrder(MProject mProject, boolean bl, String string) {
        this(mProject.getCtx(), 0, mProject.get_TrxName());
        this.setAD_Client_ID(mProject.getAD_Client_ID());
        this.setAD_Org_ID(mProject.getAD_Org_ID());
        this.setC_Campaign_ID(mProject.getC_Campaign_ID());
        this.setSalesRep_ID(mProject.getSalesRep_ID());
        this.setC_Project_ID(mProject.getC_Project_ID());
        this.setDescription(mProject.getName());
        Timestamp timestamp = mProject.getDateContract();
        if (timestamp != null) {
            this.setDateOrdered(timestamp);
        }
        if ((timestamp = mProject.getDateFinish()) != null) {
            this.setDatePromised(timestamp);
        }
        this.setC_BPartner_ID(mProject.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(mProject.getC_BPartner_Location_ID());
        this.setAD_User_ID(mProject.getAD_User_ID());
        this.setM_Warehouse_ID(mProject.getM_Warehouse_ID());
        this.setIsSOTrx(bl);
    }

    public MDDOrder(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    public void setShip_BPartner_ID(int n) {
        super.setC_BPartner_ID(n);
    }

    public void setShip_Location_ID(int n) {
        super.setC_BPartner_Location_ID(n);
    }

    public void setShip_User_ID(int n) {
        super.setAD_User_ID(n);
    }

    public void setBPartner(MBPartner mBPartner) {
        if (mBPartner == null) {
            return;
        }
        this.setC_BPartner_ID(mBPartner.getC_BPartner_ID());
        int n = 0;
        n = this.isSOTrx() ? mBPartner.getC_PaymentTerm_ID() : mBPartner.getPO_PaymentTerm_ID();
        n = this.isSOTrx() ? mBPartner.getM_PriceList_ID() : mBPartner.getPO_PriceList_ID();
        String string = mBPartner.getDeliveryRule();
        if (string != null) {
            this.setDeliveryRule(string);
        }
        if ((string = mBPartner.getDeliveryViaRule()) != null) {
            this.setDeliveryViaRule(string);
        }
        string = mBPartner.getInvoiceRule();
        if (this.getSalesRep_ID() == 0 && (n = Env.getAD_User_ID(this.getCtx())) != 0) {
            this.setSalesRep_ID(n);
        }
        List<MBPartnerLocation> list = Arrays.asList(mBPartner.getLocations(false));
        MBPartnerLocation mBPartnerLocation3 = list.stream().filter(mBPartnerLocation -> mBPartnerLocation.isShipTo()).reduce((mBPartnerLocation, mBPartnerLocation2) -> mBPartnerLocation2).orElseGet(() -> (MBPartnerLocation)list.stream().findFirst().orElseThrow(() -> new AdempiereException("@IsShipTo@ @NotFound@")));
        this.setC_BPartner_Location_ID(mBPartnerLocation3.getC_BPartner_Location_ID());
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "MDDOrder.setBPartner - Has no Ship To Address: " + mBPartner);
        }
        Arrays.asList(mBPartner.getContacts(false)).stream().findFirst().ifPresent(mUser -> this.setAD_User_ID(mUser.getAD_User_ID()));
    }

    public int copyLinesFrom(MDDOrder mDDOrder, boolean bl, boolean bl2) {
        if (this.isProcessed() || this.isPosted() || mDDOrder == null) {
            return 0;
        }
        List<MDDOrderLine> list = mDDOrder.getLines(false, null);
        list.stream().forEach(mDDOrderLine -> {
            MDDOrderLine mDDOrderLine2 = new MDDOrderLine(this);
            PO.copyValues(mDDOrderLine, mDDOrderLine2, this.getAD_Client_ID(), this.getAD_Org_ID());
            mDDOrderLine2.setDD_Order_ID(this.getDD_Order_ID());
            mDDOrderLine2.setOrder(this);
            if (!bl2) {
                mDDOrderLine2.setM_AttributeSetInstance_ID(0);
            }
            mDDOrderLine2.setQtyDelivered(Env.ZERO);
            mDDOrderLine2.setQtyReserved(Env.ZERO);
            mDDOrderLine2.setDateDelivered(null);
            mDDOrderLine2.setProcessed(false);
            mDDOrderLine2.saveEx(this.get_TrxName());
            this.orderLines.add(mDDOrderLine2);
        });
        if (list.size() != this.orderLines.size()) {
            this.log.log(Level.SEVERE, "Line difference - From=" + list.size() + " <> Saved=" + this.orderLines.size());
        }
        return this.orderLines.size();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MDDOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append("]");
        return stringBuffer.toString();
    }

    @Override
    public String getDocumentInfo() {
        I_C_DocType i_C_DocType = this.getC_DocType();
        return i_C_DocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return Optional.ofNullable(ReportEngine.get(this.getCtx(), 9, this.getDD_Order_ID())).orElseThrow(() -> new AdempiereException("@AD_PrintFormat_ID@ @NotFound@")).getPDF();
    }

    public List<MDDOrderLine> getLines(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("DD_Order_ID").append("=?");
        if (!Util.isEmpty(string, true)) {
            stringBuffer.append(" AND (").append(string).append(")");
        }
        return new Query(this.getCtx(), "DD_OrderLine", stringBuffer.toString(), this.get_TrxName()).setParameters(this.getDD_Order_ID()).setOrderBy(string2).list();
    }

    public List<MDDOrderLine> getLines(boolean bl, String string) {
        if (this.orderLines != null && !bl) {
            this.orderLines.stream().forEach(mDDOrderLine -> mDDOrderLine.set_TrxName(this.get_TrxName()));
            return this.orderLines;
        }
        Object object = "";
        object = string != null && string.length() > 0 ? (String)object + string : (String)object + "Line";
        this.orderLines = this.getLines(null, (String)object);
        return this.orderLines;
    }

    public List<MDDOrderLine> getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int n) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.orderLines = this.getLines(true, null);
        this.orderLines.stream().forEach(mDDOrderLine -> {
            mDDOrderLine.setLine(atomicInteger.updateAndGet(n -> n + 10));
            mDDOrderLine.save(this.get_TrxName());
        });
        this.orderLines = null;
    }

    public List<MMovement> getMovement() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DD_Order_ID").append("=?");
        return new Query(this.getCtx(), "M_Movement", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setOrderBy("Created").setParameters(this.getDD_Order_ID()).list();
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    @Override
    public void setDocAction(String string) {
        this.setDocAction(string, false);
    }

    @Override
    public void setProcessed(boolean bl) {
        super.setProcessed(bl);
        if (this.get_ID() == 0) {
            return;
        }
        this.getLines().stream().forEach(mDDOrderLine -> {
            mDDOrderLine.setProcessed(bl);
            mDDOrderLine.saveEx();
        });
        this.orderLines = null;
        this.log.fine("setProcessed - " + bl + " - Lines=" + this.getLines().size());
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        int n;
        if (this.getAD_Org_ID() == 0 && (n = Env.getAD_Org_ID(this.getCtx())) != 0) {
            this.setAD_Org_ID(n);
            this.log.warning("Changed Org to Context=" + n);
        }
        if (this.getAD_Client_ID() == 0) {
            this.processMessage = "AD_Client_ID = 0";
            return false;
        }
        if (bl && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            n = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
            if (n != 0) {
                this.setM_Warehouse_ID(n);
            } else {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_Warehouse_ID"));
                return false;
            }
        }
        if (!bl && this.is_ValueChanged("M_Warehouse_ID") && !this.getLines().stream().anyMatch(mDDOrderLine -> mDDOrderLine.canChangeWarehouse())) {
            return false;
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getSalesRep_ID() == 0 && (n = Env.getContextAsInt(this.getCtx(), "#AD_User_ID")) != 0) {
            this.setSalesRep_ID(n);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        if (!bl2 || bl) {
            return bl2;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            this.getMovement().stream().filter(mMovement -> !mMovement.getDocStatus().endsWith("RE")).filter(mMovement -> !mMovement.getDocStatus().endsWith("CL")).forEach(mMovement -> {
                mMovement.setDescription(this.getDescription());
                mMovement.setPOReference(this.getPOReference());
                mMovement.saveEx();
            });
        }
        this.afterSaveSync("AD_Org_ID");
        this.afterSaveSync("C_BPartner_ID");
        this.afterSaveSync("C_BPartner_Location_ID");
        this.afterSaveSync("DateOrdered");
        this.afterSaveSync("DatePromised");
        this.afterSaveSync("M_Shipper_ID");
        return true;
    }

    private void afterSaveSync(String string) {
        if (this.is_ValueChanged(string)) {
            List list = new Query(this.getCtx(), "DD_OrderLine", "DD_Order_ID=?", this.get_TrxName()).setParameters(this.getDD_Order_ID()).list();
            list.stream().forEach(mDDOrderLine -> {
                mDDOrderLine.set_ValueOfColumn(string, this.get_Value(string));
                mDDOrderLine.saveEx();
                this.log.fine(string + " Lines -> #" + this.get_Value(string));
            });
        }
    }

    public void setDocAction(String string, boolean bl) {
        super.setDocAction(string);
        this.m_forceCreation = bl;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        this.getLines().stream().forEach(mDDOrderLine -> mDDOrderLine.deleteEx(true));
        return true;
    }

    @Override
    public boolean processIt(String string) {
        this.processMessage = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMessage != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateOrdered(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.processMessage = "@PeriodClosed@";
            return "IN";
        }
        List<MDDOrderLine> list = this.getLines(true, "M_Product_ID");
        if (list.isEmpty()) {
            this.processMessage = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("O")) {
            list.stream().filter(mDDOrderLine -> mDDOrderLine.getProduct() != null && mDDOrderLine.getProduct().isExcludeAutoDelivery()).map(mDDOrderLine -> {
                this.processMessage = "@M_Product_ID@ " + mDDOrderLine.getProduct().getValue() + " @IsExcludeAutoDelivery@";
                return "IN";
            });
        }
        String string = "='Y'";
        String string2 = "SELECT COUNT(*) FROM DD_OrderLine ol INNER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID) INNER JOIN M_AttributeSet pas ON (p.M_AttributeSet_ID=pas.M_AttributeSet_ID) WHERE pas.MandatoryType" + string + " AND ol.M_AttributeSetInstance_ID IS NULL AND ol.DD_Order_ID=?";
        int n = DB.getSQLValue(this.get_TrxName(), string2, this.getDD_Order_ID());
        if (n != 0) {
            this.processMessage = "@LinesWithoutProductAttribute@ (" + n + ")";
            return "IN";
        }
        this.reserveStock(list);
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMessage != null) {
            return "IN";
        }
        this.justPrepared = true;
        return "IP";
    }

    public void reserveStock(List<MDDOrderLine> list) {
        list.stream().filter(mDDOrderLine -> mDDOrderLine.getCalculateQtyReserved().signum() != 0).filter(mDDOrderLine -> mDDOrderLine.getProduct() != null && mDDOrderLine.getProduct().isStocked()).forEach(mDDOrderLine -> {
            mDDOrderLine.orderedStock();
            mDDOrderLine.reserveStock();
            mDDOrderLine.saveEx();
        });
        this.updateVolume();
        this.updateWeight();
    }

    public BigDecimal updateWeight() {
        BigDecimal bigDecimal = this.getLines().stream().filter(mDDOrderLine -> mDDOrderLine.getProduct() != null && mDDOrderLine.getProduct().isStocked()).map(MDDOrderLine::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setWeight(bigDecimal);
        this.saveEx();
        return bigDecimal;
    }

    public BigDecimal updateVolume() {
        BigDecimal bigDecimal = this.getLines().stream().filter(mDDOrderLine -> mDDOrderLine.getProduct() != null && mDDOrderLine.getProduct().isStocked()).map(MDDOrderLine::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setVolume(bigDecimal);
        this.saveEx();
        return bigDecimal;
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        CharSequence charSequence;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.justPrepared && !"IP".equals(charSequence = this.prepareIt())) {
            return charSequence;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMessage != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        this.renumberLines(10);
        if (this.isDropShip()) {
            this.createDropShip();
        }
        this.log.info(this.toString());
        charSequence = new StringBuffer();
        String string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            if (((StringBuffer)charSequence).length() > 0) {
                ((StringBuffer)charSequence).append(" - ");
            }
            ((StringBuffer)charSequence).append(string);
            this.processMessage = ((StringBuffer)charSequence).toString();
            return "IN";
        }
        this.setProcessed(true);
        this.processMessage = ((StringBuffer)charSequence).toString();
        this.setDocAction("CL");
        return "CO";
    }

    private void createDropShip() {
        Date date = Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Timestamp timestamp = new Timestamp(date.getTime());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.getDD_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(GenerateMovement.getProcessId()).withTitle(GenerateMovement.getProcessName()).withRecordId(Table_ID, 0).withSelectedRecordsIds(Table_ID, arrayList).withParameter("MovementDate", timestamp).withParameter("DocAction", "CO").withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        LinkedHashMap<Integer, LinkedHashMap<String, Object>> linkedHashMap = new LinkedHashMap<Integer, LinkedHashMap<String, Object>>();
        this.getLines().stream().filter(mDDOrderLine -> mDDOrderLine != null).forEach(mDDOrderLine -> {
            arrayList2.add(mDDOrderLine.get_ID());
            LinkedHashMap<String, BigDecimal> linkedHashMap2 = new LinkedHashMap<String, BigDecimal>();
            linkedHashMap2.put("LINE_QtyInTransit", mDDOrderLine.getQtyInTransit());
            linkedHashMap.put(mDDOrderLine.get_ID(), linkedHashMap2);
        });
        processInfo = ProcessBuilder.create(this.getCtx()).process(GenerateMovementMaterial.getProcessId()).withTitle(GenerateMovementMaterial.getProcessName()).withRecordId(MDDOrderLine.Table_ID, 0).withSelectedRecordsIds(MDDOrderLine.Table_ID, arrayList2, linkedHashMap).withParameter("MovementDate", timestamp).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMessage != null) {
            return false;
        }
        List<MDDOrderLine> list = this.getLines(true, "M_Product_ID");
        list.stream().filter(mDDOrderLine -> mDDOrderLine.getQtyOrdered().signum() != 0).forEach(mDDOrderLine -> {
            mDDOrderLine.setDescription(Optional.ofNullable(mDDOrderLine.getDescription()).orElse("") + " " + Msg.parseTranslation(this.getCtx(), "@Voided@  @QtyOrdered@ (" + mDDOrderLine.getQtyOrdered() + ")"));
            mDDOrderLine.saveEx(this.get_TrxName());
        });
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.reserveStock(list);
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMessage != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMessage != null) {
            return false;
        }
        List<MDDOrderLine> list = this.getLines(true, "M_Product_ID");
        list.stream().filter(mDDOrderLine -> mDDOrderLine.getQtyOrdered().compareTo(mDDOrderLine.getQtyDelivered()) != 0).forEach(mDDOrderLine -> {
            mDDOrderLine.setQtyOrdered(mDDOrderLine.getQtyDelivered());
            mDDOrderLine.setDescription(Optional.ofNullable(mDDOrderLine.getDescription()).orElse("") + " " + Msg.parseTranslation(this.getCtx(), "@close@  @QtyOrdered@ (" + mDDOrderLine.getQtyOrdered() + ")"));
            mDDOrderLine.save(this.get_TrxName());
        });
        this.reserveStock(list);
        this.setProcessed(true);
        this.setDocAction("--");
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMessage == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.processMessage != null) {
            return false;
        }
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.processMessage != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.processMessage != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.orderLines != null) {
            stringBuffer.append(" (#").append(this.orderLines.size()).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMessage;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public boolean isComplete() {
        String string = this.getDocStatus();
        return "CO".equals(string) || "CL".equals(string) || "RE".equals(string);
    }
}

