/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_WF_NextCondition;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;

public class MWFNextCondition
extends X_AD_WF_NextCondition {
    private static final long serialVersionUID = 1690335423407194318L;
    private boolean m_numeric = true;

    public MWFNextCondition(Properties ctx, int id, String trxName) {
        super(ctx, id, trxName);
    }

    public MWFNextCondition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isOr() {
        return "O".equals(this.getAndOr());
    }

    public boolean evaluate(MWFActivity activity) {
        String value2;
        String value1;
        if (this.getAD_Column_ID() == 0) {
            throw new IllegalStateException("No Column defined - " + this);
        }
        PO po = activity.getPO();
        if (po == null || po.get_ID() == 0) {
            throw new IllegalStateException("Could not evaluate " + po + " - " + this);
        }
        Object valueObj = po.get_ValueOfColumn(this.getAD_Column_ID());
        if (valueObj == null) {
            valueObj = "";
        }
        if ((value1 = this.getDecodedValue(this.getValue(), po)) == null) {
            value1 = "";
        }
        if ((value2 = this.getDecodedValue(this.getValue2(), po)) == null) {
            value2 = "";
        }
        String resultStr = "PO:{" + valueObj + "} " + this.getOperation() + " Condition:{" + value1 + "}";
        if (this.getOperation().equals("SQ")) {
            throw new IllegalArgumentException("SQL Operator not implemented yet: " + resultStr);
        }
        if (this.getOperation().equals("AB")) {
            resultStr = resultStr + "{" + value2 + "}";
        }
        boolean result = false;
        result = valueObj instanceof Number ? this.compareNumber((Number)valueObj, value1, value2) : (valueObj instanceof Boolean ? this.compareBoolean((Boolean)valueObj, value1, value2) : this.compareString(valueObj, value1, value2));
        this.log.fine(resultStr + " -> " + result + (this.m_numeric ? " (#)" : " ($)"));
        return result;
    }

    protected String getDecodedValue(String sValue, PO po) {
        String sRet = sValue;
        if (sValue != null && sValue.startsWith("@")) {
            if (sValue.startsWith("@COL=")) {
                Object o = po.get_Value(sValue.substring(5));
                if (o != null) {
                    sRet = o.toString();
                }
            } else if (sValue.startsWith("@SQL=")) {
                String sql = sValue.substring(5);
                if (Util.isEmpty(sql = Env.parseVariable(sql, po, this.get_TrxName(), false))) {
                    this.log.log(Level.CONFIG, "(" + sValue + ") - Default SQL variable parse failed: " + sql);
                } else {
                    sRet = DB.getSQLValueString(this.get_TrxName(), sql, new Object[0]);
                    if (Util.isEmpty(sRet)) {
                        this.log.log(Level.CONFIG, "(" + sValue + ") - no Result: " + sql);
                    }
                }
            }
        }
        return sRet;
    }

    private boolean compareNumber(Number valueObj, String value1, String value2) {
        BigDecimal valueObjB = null;
        BigDecimal value1B = null;
        BigDecimal value2B = null;
        try {
            valueObjB = valueObj instanceof BigDecimal ? (BigDecimal)valueObj : (valueObj instanceof Integer ? new BigDecimal((Integer)valueObj) : new BigDecimal(String.valueOf(valueObj)));
        }
        catch (Exception e) {
            this.log.fine("compareNumber - valueObj=" + valueObj + " - " + e.toString());
            return this.compareString(valueObj, value1, value2);
        }
        try {
            value1B = new BigDecimal(value1);
        }
        catch (Exception e) {
            this.log.fine("compareNumber - value1=" + value1 + " - " + e.toString());
            return this.compareString(valueObj, value1, value2);
        }
        String op = this.getOperation();
        if ("==".equals(op)) {
            return valueObjB.compareTo(value1B) == 0;
        }
        if (">>".equals(op)) {
            return valueObjB.compareTo(value1B) > 0;
        }
        if (">=".equals(op)) {
            return valueObjB.compareTo(value1B) >= 0;
        }
        if ("<<".equals(op)) {
            return valueObjB.compareTo(value1B) < 0;
        }
        if ("<=".equals(op)) {
            return valueObjB.compareTo(value1B) <= 0;
        }
        if ("~~".equals(op)) {
            return valueObjB.compareTo(value1B) == 0;
        }
        if ("!=".equals(op)) {
            return valueObjB.compareTo(value1B) != 0;
        }
        if ("SQ".equals(op)) {
            throw new IllegalArgumentException("SQL not Implemented");
        }
        if ("AB".equals(op)) {
            if (valueObjB.compareTo(value1B) < 0) {
                return false;
            }
            try {
                value2B = new BigDecimal(String.valueOf(value2));
                return valueObjB.compareTo(value2B) <= 0;
            }
            catch (Exception e) {
                this.log.fine("compareNumber - value2=" + value2 + " - " + e.toString());
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown Operation=" + op);
    }

    private boolean compareString(Object valueObj, String value1S, String value2S) {
        this.m_numeric = false;
        String valueObjS = String.valueOf(valueObj);
        String op = this.getOperation();
        if ("==".equals(op)) {
            return valueObjS.compareTo(value1S) == 0;
        }
        if (">>".equals(op)) {
            return valueObjS.compareTo(value1S) > 0;
        }
        if (">=".equals(op)) {
            return valueObjS.compareTo(value1S) >= 0;
        }
        if ("<<".equals(op)) {
            return valueObjS.compareTo(value1S) < 0;
        }
        if ("<=".equals(op)) {
            return valueObjS.compareTo(value1S) <= 0;
        }
        if ("~~".equals(op)) {
            return valueObjS.compareTo(value1S) == 0;
        }
        if ("!=".equals(op)) {
            return valueObjS.compareTo(value1S) != 0;
        }
        if ("SQ".equals(op)) {
            throw new IllegalArgumentException("SQL not Implemented");
        }
        if ("AB".equals(op)) {
            if (valueObjS.compareTo(value1S) < 0) {
                return false;
            }
            return valueObjS.compareTo(value2S) <= 0;
        }
        throw new IllegalArgumentException("Unknown Operation=" + op);
    }

    private boolean compareBoolean(Boolean valueObj, String value1S, String value2S) {
        this.m_numeric = false;
        Boolean value1B = Boolean.valueOf(value1S) != false || "Y".equalsIgnoreCase(value1S);
        String op = this.getOperation();
        if ("==".equals(op)) {
            return valueObj.equals(value1B);
        }
        if ("!=".equals(op)) {
            return !valueObj.equals(value1B);
        }
        throw new IllegalArgumentException("Not Supported =" + op);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MWFNextCondition[");
        sb.append(this.get_ID()).append(",SeqNo=").append(this.getSeqNo()).append("]");
        return sb.toString();
    }
}

