/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.Env;
import org.compiere.util.PaymentExport;
import org.compiere.util.Util;

public abstract class PaymentExportList
implements PaymentExport {
    private FileWriter fileWriter = null;
    private int exportedPayments = 0;
    private StringBuffer errorMessage = new StringBuffer();
    private File file = null;

    @Override
    @Deprecated
    public int exportToFile(MPaySelectionCheck[] checks, File file, StringBuffer error) {
        return this.exportToFile(Arrays.asList(checks), file, error);
    }

    public abstract int exportToFile(List<MPaySelectionCheck> var1, File var2, StringBuffer var3);

    public void openFileWriter(File file) {
        if (this.fileWriter != null) {
            return;
        }
        try {
            this.fileWriter = new FileWriter(file);
            this.file = file;
        }
        catch (IOException e) {
            this.addError(e.getLocalizedMessage());
        }
    }

    public void closeFileWriter() {
        if (this.fileWriter == null) {
            return;
        }
        try {
            this.fileWriter.flush();
            this.fileWriter.close();
            this.fileWriter = null;
        }
        catch (IOException e) {
            this.addError(e.getLocalizedMessage());
        }
    }

    public void openFileWriter(File file, List<MPaySelectionCheck> checks) {
        MPaySelectionCheck check = checks.get(0);
        MPaySelection paymentSelection = check.getParent();
        MBankAccount bankAccount = MBankAccount.get(Env.getCtx(), paymentSelection.getC_BankAccount_ID());
        MBank bank = MBank.get(Env.getCtx(), bankAccount.getC_Bank_ID());
        String fileName = this.getFileName(file, bank.getName(), paymentSelection.getDocumentNo());
        this.openFileWriter(fileName);
    }

    public void openFileWriter(File file, MBankAccount bankAccount, List<MPayment> payments, String suffix) {
        if (Util.isEmpty(suffix)) {
            suffix = "";
        }
        MPayment firstPayment = payments.get(0);
        MPaymentBatch paymentBatch = (MPaymentBatch)firstPayment.getC_PaymentBatch();
        MBank bank = MBank.get(Env.getCtx(), bankAccount.getC_Bank_ID());
        String fileName = this.getFileName(file, bank.getName(), paymentBatch.getDocumentNo() + suffix);
        this.openFileWriter(fileName);
    }

    public void openFileWriter(File file, String bankName, String documentNo) {
        String fileName = this.getFileName(file, bankName, documentNo);
        this.openFileWriter(fileName);
    }

    public void openFileWriter(String newName) {
        File newFile = new File(newName);
        this.deleteIfExist(newFile);
        this.openFileWriter(newFile);
    }

    public String getParentFileName(File file) {
        StringBuffer pathName = new StringBuffer();
        if (file.isFile() || !file.exists()) {
            pathName.append(file.getParent());
        } else {
            pathName.append(file.getAbsolutePath());
        }
        return pathName.toString();
    }

    public String getFileName(File file, String bankName, String documentNo) {
        if (file == null) {
            return null;
        }
        String extension = ".txt";
        StringBuffer pathName = new StringBuffer(this.getParentFileName(file));
        pathName.append(File.separator).append(bankName).append("_").append(documentNo).append(extension);
        return pathName.toString().replace(" ", "_");
    }

    public boolean writeLine(String line) {
        if (this.fileWriter == null) {
            return false;
        }
        boolean ok = false;
        try {
            this.fileWriter.write(line);
            ++this.exportedPayments;
            ok = true;
        }
        catch (IOException e) {
            this.addError(e.getLocalizedMessage());
        }
        return ok;
    }

    public void deleteIfExist(File file) {
        if (file == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
    }

    public void addError(String error) {
        if (this.errorMessage.length() > 0) {
            this.errorMessage.append(Env.NL);
        }
        this.errorMessage.append(error);
    }

    public String getError() {
        return this.errorMessage.toString();
    }

    public int getExportedPayments() {
        return this.exportedPayments;
    }

    public void setExportedPayments(int exportedPayments) {
        this.exportedPayments = exportedPayments;
    }

    public String leftPadding(String text, int length, String padd) {
        return this.addPadding(text, length, padd, true);
    }

    public String rightPadding(String text, int length, String padd) {
        return this.addPadding(text, length, padd, false);
    }

    private String addPadding(String text, int length, String padd, boolean left) {
        if (text == null || padd == null) {
            return text;
        }
        String format = "%1$";
        if (!left) {
            format = "%1$-";
        }
        return String.format(format + length + "s", text).replace(" ", padd);
    }

    public String processValue(String value) {
        if (Util.isEmpty(value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$]", "");
    }

    public String leftPadding(String text, int length, String padding, boolean isFixedLength) {
        return this.leftPadding(text, length, padding, isFixedLength, false, null);
    }

    public String rightPadding(String text, int length, String padding, boolean isFixedLength) {
        return this.rightPadding(text, length, padding, isFixedLength, false, null);
    }

    public String leftPadding(String text, int length, String padding, boolean isFixedLength, boolean isMandatory, String mandatoryMessage) {
        return this.addPadding(text, length, padding, isFixedLength, isMandatory, mandatoryMessage, true);
    }

    public String rightPadding(String text, int length, String padding, boolean isFixedLength, boolean isMandatory, String mandatoryMessage) {
        return this.addPadding(text, length, padding, isFixedLength, isMandatory, mandatoryMessage, false);
    }

    private String addPadding(String text, int length, String padding, boolean isFixedLength, boolean isMandatory, String mandatoryMessage, boolean isLeft) {
        if (Util.isEmpty(text)) {
            if (isMandatory && !Util.isEmpty(mandatoryMessage)) {
                this.addError(mandatoryMessage);
                return null;
            }
            text = "";
        }
        String processedText = text;
        if (isFixedLength) {
            processedText = processedText.substring(0, processedText.length() >= length ? length : processedText.length());
        }
        processedText = isLeft ? this.leftPadding(processedText, length, padding) : this.rightPadding(processedText, length, padding);
        return processedText;
    }

    public MBPBankAccount getBPAccountInfo(MPaySelectionCheck check, boolean defaultWhenNull) {
        if (check.getC_BP_BankAccount_ID() != 0) {
            return (MBPBankAccount)check.getC_BP_BankAccount();
        }
        if (defaultWhenNull) {
            List<MBPBankAccount> bpAccountList = MBPBankAccount.getByPartner(check.getCtx(), check.getC_BPartner_ID());
            if (bpAccountList == null || bpAccountList.size() == 0) {
                return null;
            }
            Optional<MBPBankAccount> first = bpAccountList.stream().filter(account -> account.isACH()).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            bpAccountList.get(0);
        }
        return null;
    }

    public MBPBankAccount getBPAccountInfo(MPayment payment, boolean defaultWhenNull) {
        if (payment.getC_BP_BankAccount_ID() != 0) {
            return (MBPBankAccount)payment.getC_BP_BankAccount();
        }
        if (defaultWhenNull) {
            List<MBPBankAccount> bpAccountList = MBPBankAccount.getByPartner(Env.getCtx(), payment.getC_BPartner_ID());
            if (bpAccountList == null || bpAccountList.size() == 0) {
                return null;
            }
            Optional<MBPBankAccount> first = bpAccountList.stream().filter(account -> account.isACH()).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            bpAccountList.get(0);
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }
}

