/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;

public class CLogConsole
extends Handler {
    private static CLogConsole s_console = null;
    private boolean m_doneHeader = false;
    private PrintWriter m_writerOut = null;
    private PrintWriter m_writerErr = null;

    public static CLogConsole get(boolean create) {
        if (s_console == null && create) {
            s_console = new CLogConsole();
        }
        return s_console;
    }

    public CLogConsole() {
        if (s_console == null) {
            s_console = this;
        } else {
            this.reportError("Console Handler exists already", new IllegalStateException("Existing Handler"), 0);
        }
        this.initialize();
    }

    private void initialize() {
        String encoding = this.getEncoding();
        if (encoding != null) {
            try {
                this.m_writerOut = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
                this.m_writerErr = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, encoding));
            }
            catch (UnsupportedEncodingException ex) {
                this.reportError("Opening encoded Writers", ex, 4);
            }
        }
        if (this.m_writerOut == null) {
            this.m_writerOut = new PrintWriter(System.out);
        }
        if (this.m_writerErr == null) {
            this.m_writerErr = new PrintWriter(System.err);
        }
        this.setFormatter(CLogFormatter.get());
        this.setLevel(Level.INFO);
        this.setFilter(CLogFilter.get());
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        this.flush();
        this.initialize();
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        boolean enableJDBC;
        if (newLevel == null) {
            return;
        }
        super.setLevel(newLevel);
        boolean bl = enableJDBC = newLevel == Level.FINEST;
        if (enableJDBC) {
            DriverManager.setLogWriter(this.m_writerOut);
        } else {
            DriverManager.setLogWriter(null);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record) || this.m_writerOut == null) {
            return;
        }
        String msg = null;
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError("formatting", ex, 5);
            return;
        }
        try {
            if (!this.m_doneHeader) {
                this.m_writerOut.write(this.getFormatter().getHead(this));
                this.m_doneHeader = true;
            }
            if (record.getLevel() == Level.SEVERE || record.getLevel() == Level.WARNING) {
                this.flush();
                this.m_writerErr.write(msg);
                this.flush();
            } else {
                this.m_writerOut.write(msg);
                this.m_writerOut.flush();
            }
        }
        catch (Exception ex) {
            this.reportError("writing", ex, 1);
        }
    }

    @Override
    public void flush() {
        try {
            if (this.m_writerOut != null) {
                this.m_writerOut.flush();
            }
        }
        catch (Exception ex) {
            this.reportError("flush out", ex, 2);
        }
        try {
            if (this.m_writerErr != null) {
                this.m_writerErr.flush();
            }
        }
        catch (Exception ex) {
            this.reportError("flush err", ex, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this.m_writerOut == null) {
            return;
        }
        try {
            if (!this.m_doneHeader) {
                this.m_writerOut.write(this.getFormatter().getHead(this));
            }
            this.m_writerOut.write(this.getFormatter().getTail(this));
        }
        catch (Exception ex) {
            this.reportError("tail", ex, 1);
        }
        this.flush();
        try {
            this.m_writerOut.close();
        }
        catch (Exception ex) {
            this.reportError("close out", ex, 3);
        }
        this.m_writerOut = null;
        try {
            this.m_writerErr.close();
        }
        catch (Exception ex) {
            this.reportError("close err", ex, 3);
        }
        this.m_writerErr = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CLogConsole[");
        sb.append("Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }
}

