/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;

public class CCache<K, V>
extends HashMap<K, V>
implements CacheInterface {
    private static final long serialVersionUID = -2268565219001179841L;
    private String m_name = null;
    private int m_expire = 0;
    private volatile long m_timeExp = 0L;
    private boolean m_justReset = true;
    private VetoableChangeSupport m_changeSupport = null;
    private static String PROPERTYNAME = "cache";

    public CCache(String name, int initialCapacity) {
        this(name, initialCapacity, 120);
    }

    public CCache(String name, int initialCapacity, int expireMinutes) {
        super(initialCapacity);
        this.m_name = name;
        this.setExpireMinutes(expireMinutes);
        CacheMgt.get().register(this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setExpireMinutes(int expireMinutes) {
        if (expireMinutes > 0) {
            this.m_expire = expireMinutes;
            long addMS = 60000L * (long)this.m_expire;
            this.m_timeExp = System.currentTimeMillis() + addMS;
        } else {
            this.m_expire = 0;
            this.m_timeExp = 0L;
        }
    }

    public int getExpireMinutes() {
        return this.m_expire;
    }

    public boolean isReset() {
        return this.m_justReset;
    }

    public void setUsed() {
        this.m_justReset = false;
    }

    @Override
    public int reset() {
        int no = super.size();
        this.clear();
        return no;
    }

    private void expire() {
        if (this.m_expire != 0 && this.m_timeExp < System.currentTimeMillis()) {
            this.reset();
        }
    }

    @Override
    public String toString() {
        return "CCache[" + this.m_name + ",Exp=" + this.getExpireMinutes() + ", #" + super.size() + "]";
    }

    @Override
    public void clear() {
        if (this.m_changeSupport != null) {
            try {
                this.m_changeSupport.fireVetoableChange(PROPERTYNAME, super.size(), 0);
            }
            catch (Exception e) {
                System.out.println("CCache.clear - " + e);
                return;
            }
        }
        super.clear();
        if (this.m_expire != 0) {
            long addMS = 60000L * (long)this.m_expire;
            this.m_timeExp = System.currentTimeMillis() + addMS;
        }
        this.m_justReset = true;
    }

    @Override
    public boolean containsKey(Object key) {
        this.expire();
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.expire();
        return super.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expire();
        return super.entrySet();
    }

    @Override
    public V get(Object key) {
        this.expire();
        return super.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.expire();
        this.m_justReset = false;
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.expire();
        this.m_justReset = false;
        super.putAll(m);
    }

    @Override
    public boolean isEmpty() {
        this.expire();
        return super.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.expire();
        return super.keySet();
    }

    @Override
    public int size() {
        this.expire();
        return super.size();
    }

    public int sizeNoExpire() {
        return super.size();
    }

    @Override
    public Collection<V> values() {
        this.expire();
        return super.values();
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_changeSupport == null) {
            this.m_changeSupport = new VetoableChangeSupport(this);
        }
        if (listener != null) {
            this.m_changeSupport.addVetoableChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_changeSupport != null && listener != null) {
            this.m_changeSupport.removeVetoableChangeListener(listener);
        }
    }
}

