/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_TH
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "\u0e25\u0e49\u0e32\u0e19 "};
    private static final String[] hundredThousandNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e41\u0e2a\u0e19", "\u0e2a\u0e2d\u0e07\u0e41\u0e2a\u0e19", "\u0e2a\u0e32\u0e21\u0e41\u0e2a\u0e19", "\u0e2a\u0e35\u0e48\u0e41\u0e2a\u0e19", "\u0e2b\u0e49\u0e32\u0e41\u0e2a\u0e19", "\u0e2b\u0e01\u0e41\u0e2a\u0e19", "\u0e40\u0e08\u0e47\u0e14\u0e41\u0e2a\u0e19", "\u0e41\u0e1b\u0e14\u0e41\u0e2a\u0e19", "\u0e40\u0e01\u0e49\u0e32\u0e41\u0e2a\u0e19"};
    private static final String[] tenThousandNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2a\u0e2d\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2a\u0e32\u0e21\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2a\u0e35\u0e48\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2b\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2b\u0e01\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e40\u0e08\u0e47\u0e14\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e41\u0e1b\u0e14\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19"};
    private static final String[] thousandNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19", "\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19", "\u0e2a\u0e32\u0e21\u0e1e\u0e31\u0e19", "\u0e2a\u0e35\u0e48\u0e1e\u0e31\u0e19", "\u0e2b\u0e49\u0e32\u0e1e\u0e31\u0e19", "\u0e2b\u0e01\u0e1e\u0e31\u0e19", "\u0e40\u0e08\u0e47\u0e14\u0e1e\u0e31\u0e19", "\u0e41\u0e1b\u0e14\u0e1e\u0e31\u0e19", "\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19"};
    private static final String[] hundredNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22", "\u0e2a\u0e2d\u0e07\u0e23\u0e49\u0e2d\u0e22", "\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22", "\u0e2a\u0e35\u0e48\u0e23\u0e49\u0e2d\u0e22", "\u0e2b\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22", "\u0e2b\u0e01\u0e23\u0e49\u0e2d\u0e22", "\u0e40\u0e08\u0e47\u0e14\u0e23\u0e49\u0e2d\u0e22", "\u0e41\u0e1b\u0e14\u0e23\u0e49\u0e2d\u0e22", "\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22"};
    private static final String[] tensNames = new String[]{"", "\u0e2a\u0e34\u0e1a", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a", "\u0e2a\u0e32\u0e21\u0e2a\u0e34\u0e1a", "\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a", "\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a", "\u0e2b\u0e01\u0e2a\u0e34\u0e1a", "\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a", "\u0e41\u0e1b\u0e14\u0e2a\u0e34\u0e1a", "\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a"};
    private static final String[] numNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07", "\u0e2a\u0e2d\u0e07", "\u0e2a\u0e32\u0e21", "\u0e2a\u0e35\u0e48", "\u0e2b\u0e49\u0e32", "\u0e2b\u0e01", "\u0e40\u0e08\u0e47\u0e14", "\u0e41\u0e1b\u0e14", "\u0e40\u0e01\u0e49\u0e32", "\u0e2a\u0e34\u0e1a", "\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14", "\u0e2a\u0e34\u0e1a\u0e2a\u0e2d\u0e07", "\u0e2a\u0e34\u0e1a\u0e2a\u0e32\u0e21", "\u0e2a\u0e34\u0e1a\u0e2a\u0e35\u0e48", "\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32", "\u0e2a\u0e34\u0e1a\u0e2b\u0e01", "\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14", "\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14", "\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32"};

    private String convertLessThanOneMillion(int number) {
        Object soFar = new String();
        System.out.println("[convertLessThanOneMillion] number = " + number);
        if (number != 0) {
            soFar = numNames[number % 10];
            if (number != 1 && ((String)soFar).equals("\u0e2b\u0e19\u0e36\u0e48\u0e07")) {
                soFar = "\u0e40\u0e2d\u0e47\u0e14";
            }
            soFar = tensNames[(number /= 10) % 10] + (String)soFar;
            soFar = hundredNames[(number /= 10) % 10] + (String)soFar;
            soFar = thousandNames[(number /= 10) % 10] + (String)soFar;
            soFar = tenThousandNames[(number /= 10) % 10] + (String)soFar;
            soFar = hundredThousandNames[(number /= 10) % 10] + (String)soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + "\u0e23\u0e49\u0e2d\u0e22\u0e25\u0e49\u0e32\u0e19" + (String)soFar;
    }

    private String convert(int number) {
        if (number == 0) {
            return "\u0e28\u0e39\u0e19\u0e22\u0e4c";
        }
        String prefix = "";
        if (number < 0) {
            number = -number;
            prefix = "\u0e25\u0e1a ";
        }
        Object soFar = "";
        int place = 0;
        do {
            double d;
            int n;
            if ((n = (int)(d = (double)(number % 1000000))) != 0) {
                String s = this.convertLessThanOneMillion(n);
                place = place > 0 ? 1 : 0;
                soFar = s + majorNames[place] + (String)soFar;
            }
            ++place;
        } while ((number = (int)((double)number / 1000000.0)) > 0);
        return (prefix + (String)soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        int newpos = (amount = amount.replaceAll(",", "")).lastIndexOf(46);
        if (newpos != -1) {
            int pesos = Integer.parseInt(amount.substring(0, newpos));
            System.out.println(pesos);
            sb.append(this.convert(pesos)).append("\u0e1a\u0e32\u0e17");
            for (int i2 = 0; i2 < oldamt.length(); ++i2) {
                if (pos != i2) continue;
                String cents = oldamt.substring(i2 + 1);
                int stang = Integer.parseInt(cents);
                if (stang != 0) {
                    sb.append(this.convert(stang)).append("\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c");
                } else {
                    sb.append("\u0e16\u0e49\u0e27\u0e19");
                }
                break;
            }
        } else {
            int pesos = Integer.parseInt(amount);
            sb.append(this.convert(pesos)).append("\u0e1a\u0e32\u0e17").append("\u0e16\u0e49\u0e27\u0e19");
        }
        return sb.toString();
    }

    public String getAmtInWords(String amount, String iso) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        int newpos = (amount = amount.replaceAll(",", "")).lastIndexOf(46);
        if (newpos != -1) {
            int pesos = Integer.parseInt(amount.substring(0, newpos));
            System.out.println(pesos);
            if (iso.equals("THB")) {
                sb.append(this.convert(pesos)).append("\u0e1a\u0e32\u0e17");
                for (int i2 = 0; i2 < oldamt.length(); ++i2) {
                    if (pos != i2) continue;
                    String cents = oldamt.substring(i2 + 1);
                    int stang = Integer.parseInt(cents);
                    if (stang != 0) {
                        sb.append(this.convert(stang)).append("\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c");
                    } else {
                        sb.append("\u0e16\u0e49\u0e27\u0e19");
                    }
                    break;
                }
            } else {
                sb.append(this.convert(pesos)).append("\u0e40\u0e2b\u0e23\u0e35\u0e22\u0e0d");
                for (int i3 = 0; i3 < oldamt.length(); ++i3) {
                    if (pos != i3) continue;
                    String cents = oldamt.substring(i3 + 1);
                    int stang = Integer.parseInt(cents);
                    if (stang != 0) {
                        sb.append(this.convert(stang)).append("\u0e40\u0e0b\u0e47\u0e19\u0e15\u0e4c").append(" [" + iso + "]");
                    }
                    break;
                }
            }
        } else {
            int pesos = Integer.parseInt(amount);
            if (iso.equals("THB")) {
                sb.append(this.convert(pesos)).append("\u0e1a\u0e32\u0e17").append("\u0e16\u0e49\u0e27\u0e19");
            } else {
                sb.append(this.convert(pesos)).append("\u0e40\u0e2b\u0e23\u0e35\u0e22\u0e0d").append(" [" + iso + "]");
            }
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void print(String amt, String currency) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_TH aiw = new AmtInWords_TH();
        aiw.print("3,026.00");
        aiw.print("65341.78");
    }
}

