/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.plaf.CompiereColor;

public class CPanel
extends JPanel {
    private static final long serialVersionUID = 4153588317643163582L;

    public CPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    public CPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public CPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public CPanel() {
        this.init();
    }

    public CPanel(CompiereColor bc) {
        this();
        this.init();
        this.setBackgroundColor(bc);
    }

    private void init() {
        this.setOpaque(false);
    }

    @Override
    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        this.setBackgroundColor(new CompiereColor(bg));
    }

    public void setBackgroundColor(CompiereColor bg) {
        if (bg == null) {
            bg = new CompiereColor(AdempierePLAF.getFormBackground());
        }
        this.setOpaque(true);
        this.putClientProperty("CompiereBackground", bg);
        super.setBackground(bg.getFlatColor());
    }

    public CompiereColor getBackgroundColor() {
        try {
            return (CompiereColor)this.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            System.err.println("CPanel - ClientProperty: " + e.getMessage());
            return null;
        }
    }

    public void setTabLevel(int level) {
        if (level == 0) {
            this.putClientProperty("TabLevel", null);
        } else {
            this.putClientProperty("TabLevel", level);
        }
    }

    public int getTabLevel() {
        try {
            Integer ll = (Integer)this.getClientProperty("TabLevel");
            if (ll != null) {
                return ll;
            }
        }
        catch (Exception e) {
            System.err.println("ClientProperty: " + e.getMessage());
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("CPanel [");
        sb.append(super.toString());
        CompiereColor bg = this.getBackgroundColor();
        if (bg != null) {
            sb.append(bg.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

