/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_PA_ReportColumn;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.Query;
import org.compiere.report.MReportSource;
import org.compiere.report.MReportTree;

public class MReportColumn
extends X_PA_ReportColumn {
    private static final long serialVersionUID = 2395905882810790219L;
    private MReportSource[] m_sources = null;
    private String m_whereClause = null;

    public MReportColumn(Properties ctx, int PA_ReportColumn_ID, String trxName) {
        super(ctx, PA_ReportColumn_ID, trxName);
        if (PA_ReportColumn_ID == 0) {
            this.setIsPrinted(true);
            this.setSeqNo(0);
        } else {
            this.loadSources();
        }
    }

    public MReportColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadSources();
    }

    private void loadSources() {
        List<MReportSource> list = new Query(this.getCtx(), "PA_ReportSource", "PA_ReportColumn_ID = ?", this.get_TrxName()).setParameters(this.getPA_ReportColumn_ID()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("PA_ReportSource_ID ASC").list();
        this.m_sources = new MReportSource[list.size()];
        list.toArray(this.m_sources);
        this.log.finest("ID=" + this.getPA_ReportColumn_ID() + " - Size=" + list.size());
    }

    public MReportSource[] getSources() {
        return this.m_sources;
    }

    public boolean isWithSources() {
        return this.m_sources.length > 0;
    }

    public void list() {
        System.out.println("- " + this.toString());
        if (this.m_sources == null) {
            return;
        }
        for (int i = 0; i < this.m_sources.length; ++i) {
            System.out.println("  - " + this.m_sources[i].toString());
        }
    }

    public String getSourceColumnName() {
        String ColumnName = null;
        for (int i = 0; i < this.m_sources.length; ++i) {
            String col = MAcctSchemaElement.getColumnName(this.m_sources[i].getElementType());
            if (ColumnName == null || ColumnName.length() == 0) {
                ColumnName = col;
                continue;
            }
            if (ColumnName.equals(col)) continue;
            this.log.config("More than one: " + ColumnName + " - " + col);
            return null;
        }
        return ColumnName;
    }

    public String getSourceValueQuery() {
        if (this.m_sources != null && this.m_sources.length > 0) {
            return MAcctSchemaElement.getValueQuery(this.m_sources[0].getElementType());
        }
        return null;
    }

    public String getSelectClause(boolean withSum, MReportColumn reportColumn) {
        String amountType = this.getPAAmountType();
        StringBuffer sb = new StringBuffer();
        if (withSum) {
            sb.append("SUM(");
        }
        if ("B".equals(amountType)) {
            if (reportColumn.get_ValueAsBoolean("IsSourceAmt")) {
                sb.append("acctBalance(Account_ID,AmtSourceDr,AmtSourceCr)");
            } else {
                sb.append("acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)");
            }
        } else if ("S".equals(amountType)) {
            if (reportColumn.get_ValueAsBoolean("IsSourceAmt")) {
                sb.append("AmtSourceDr-AmtSourceCr");
            } else {
                sb.append("AmtAcctDr-AmtAcctCr");
            }
        } else if ("I".equals(amountType)) {
            if (reportColumn.get_ValueAsBoolean("IsSourceAmt")) {
                sb.append("AmtSourceCr-AmtSourceDr");
            } else {
                sb.append("AmtAcctCr-AmtAcctDr");
            }
        } else if ("C".equals(amountType)) {
            if (reportColumn.get_ValueAsBoolean("IsSourceAmt")) {
                sb.append("AmtSourceCr");
            } else {
                sb.append("AmtAcctCr");
            }
        } else if ("D".equals(amountType)) {
            if (reportColumn.get_ValueAsBoolean("IsSourceAmt")) {
                sb.append("AmtSourceDr");
            } else {
                sb.append("AmtAcctDr");
            }
        } else if ("R".equals(amountType)) {
            sb.append("Qty");
        } else if ("Q".equals(amountType)) {
            sb.append("acctBalance(Account_ID,Qty,0)");
        } else {
            this.log.log(Level.SEVERE, "AmountType=" + this.getPAAmountType() + ", at=" + amountType);
            return "NULL";
        }
        if (withSum) {
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isPeriod() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "P".equals(pt);
    }

    public boolean isYear() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "Y".equals(pt);
    }

    public boolean isTotal() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "T".equals(pt);
    }

    public boolean isNatural() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "N".equals(pt);
    }

    public String getWhereClause(int PA_Hierarchy_ID) {
        if (this.m_sources == null && !this.isColumnTypeSegmentValue()) {
            return "";
        }
        if (this.m_whereClause == null) {
            if (this.m_sources.length == 0) {
                this.m_whereClause = "";
            } else if (this.m_sources.length == 1) {
                this.m_whereClause = " AND " + this.m_sources[0].getWhereClause(PA_Hierarchy_ID);
                if (this.m_sources[0].getElementType().equals("PR") && this.m_sources[0].get_ValueAsInt("M_Product_Group_ID") > 0) {
                    this.m_whereClause = this.m_whereClause + " AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE M_Product_Group_ID = " + this.m_sources[0].get_ValueAsInt("M_Product_Group_ID") + ")";
                }
                if (this.m_sources[0].getElementType().equals("PR") && this.m_sources[0].get_ValueAsInt("M_Product_Class_ID") > 0) {
                    this.m_whereClause = this.m_whereClause + " AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE M_Product_Class_ID = " + this.m_sources[0].get_ValueAsInt("M_Product_Class_ID") + ")";
                }
                if (this.m_sources[0].getElementType().equals("BP") && this.m_sources[0].get_ValueAsInt("C_BP_Group_ID") > 0) {
                    this.m_whereClause = this.m_whereClause + " AND C_BPartner_ID IN (SELECT C_BPartner_ID FROM C_BPartner WHERE C_BP_Group_ID = " + this.m_sources[0].get_ValueAsInt("C_BP_Group_ID") + ")";
                }
                if (this.m_sources[0].get_ValueAsString("WhereClause") != null && !this.m_sources[0].get_ValueAsString("WhereClause").equalsIgnoreCase("")) {
                    this.m_whereClause = this.m_whereClause + " " + this.m_sources[0].get_ValueAsString("WhereClause");
                }
            } else {
                StringBuffer sb = new StringBuffer(" AND (");
                for (int i = 0; i < this.m_sources.length; ++i) {
                    if (i > 0) {
                        MReportSource source = this.m_sources[i];
                        String operator = source.get_ValueAsString("SQL_Operator");
                        if (operator != null && !operator.equalsIgnoreCase("")) {
                            sb.append(" " + operator + " ");
                        } else {
                            throw new AdempiereException("No hay operador definido en fuente de informe");
                        }
                    }
                    sb.append(this.m_sources[i].getWhereClause(PA_Hierarchy_ID));
                    if (this.m_sources[i].getElementType().equals("PR") && this.m_sources[i].get_ValueAsInt("M_Product_Group_ID") > 0) {
                        sb.append(" AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE M_Product_Group_ID = " + this.m_sources[i].get_ValueAsInt("M_Product_Group_ID") + ")");
                    }
                    if (this.m_sources[i].getElementType().equals("PR") && this.m_sources[i].get_ValueAsInt("M_Product_Class_ID") > 0) {
                        sb.append(" AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE M_Product_Class_ID = " + this.m_sources[i].get_ValueAsInt("M_Product_Class_ID") + ")");
                    }
                    if (this.m_sources[i].getElementType().equals("BP") && this.m_sources[i].get_ValueAsInt("C_BP_Group_ID") > 0) {
                        sb.append(" AND C_BPartner_ID IN (SELECT C_BPartner_ID FROM C_BPartner WHERE C_BP_Group_ID = " + this.m_sources[i].get_ValueAsInt("C_BP_Group_ID") + ")");
                    }
                    if (this.m_sources[i].get_ValueAsString("WhereClause") == null || this.m_sources[i].get_ValueAsString("WhereClause").equalsIgnoreCase("")) continue;
                    sb.append(" " + this.m_sources[i].get_ValueAsString("WhereClause"));
                }
                sb.append(")");
                this.m_whereClause = sb.toString();
            }
        }
        if (this.isColumnTypeSegmentValue()) {
            String elementType = this.getElementType();
            int dimensionId = 0;
            if ("AC".equals(elementType)) {
                dimensionId = this.getC_ElementValue_ID();
            } else if ("AY".equals(elementType)) {
                dimensionId = this.getC_Activity_ID();
            } else if ("BP".equals(elementType)) {
                dimensionId = this.getC_BPartner_ID();
            } else if ("MC".equals(elementType)) {
                dimensionId = this.getC_Campaign_ID();
            } else if ("LF".equals(elementType)) {
                dimensionId = this.getC_Location_ID();
            } else if ("LT".equals(elementType)) {
                dimensionId = this.getC_Location_ID();
            } else if ("OO".equals(elementType)) {
                dimensionId = this.getOrg_ID();
            } else if ("PR".equals(elementType)) {
                dimensionId = this.getM_Product_ID();
            } else if ("PJ".equals(elementType)) {
                dimensionId = this.getC_Project_ID();
            } else if ("SR".equals(elementType)) {
                dimensionId = this.getC_SalesRegion_ID();
            } else if ("OT".equals(elementType)) {
                dimensionId = this.getOrg_ID();
            } else if ("U1".equals(elementType)) {
                dimensionId = this.getUser1_ID();
            } else if ("U2".equals(elementType)) {
                dimensionId = this.getUser2_ID();
            } else if ("U3".equals(elementType)) {
                dimensionId = this.getUser3_ID();
            } else if ("U4".equals(elementType)) {
                dimensionId = this.getUser4_ID();
            } else {
                if ("X1".equals(elementType)) {
                    return " AND UserElement1_ID=" + this.getUserElement1_ID();
                }
                if ("X2".equals(elementType)) {
                    return " AND UserElement2_ID=" + this.getUserElement2_ID();
                }
                if ("CO".equals(elementType)) {
                    return this.getWhereCombination(PA_Hierarchy_ID);
                }
                this.log.warning("Unsupported Element Type=" + elementType);
            }
            if (dimensionId == 0) {
                this.log.fine("No Restrictions - No ID for EntityType=" + elementType);
                return this.m_whereClause;
            }
            this.m_whereClause = this.m_whereClause + " AND " + MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, elementType, dimensionId);
        }
        return this.m_whereClause;
    }

    private String getWhereCombination(int PA_Hierarchy_ID) {
        String whtree;
        StringBuffer whcomb = new StringBuffer();
        if (this.getC_ElementValue_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "AC", this.getC_ElementValue_ID());
            if (this.isIncludeNullsElementValue()) {
                whcomb.append(" AND (Account_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsElementValue()) {
            whcomb.append(" AND Account_ID IS NULL");
        }
        if (this.getC_Activity_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "AY", this.getC_Activity_ID());
            if (this.isIncludeNullsActivity()) {
                whcomb.append(" AND (C_Activity_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsActivity()) {
            whcomb.append(" AND C_Activity_ID IS NULL");
        }
        if (this.getC_BPartner_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "BP", this.getC_BPartner_ID());
            if (this.isIncludeNullsBPartner()) {
                whcomb.append(" AND (C_BPartner_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsBPartner()) {
            whcomb.append(" AND C_BPartner_ID IS NULL");
        }
        if (this.getC_Campaign_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "MC", this.getC_Campaign_ID());
            if (this.isIncludeNullsCampaign()) {
                whcomb.append(" AND (C_Campaign_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsCampaign()) {
            whcomb.append(" AND C_Campaign_ID IS NULL");
        }
        if (this.getC_Location_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "LF", this.getC_Location_ID());
            if (this.isIncludeNullsLocation()) {
                whcomb.append(" AND (C_LocFrom_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsLocation()) {
            whcomb.append(" AND C_LocFrom_ID IS NULL");
        }
        if (this.getOrg_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "OO", this.getOrg_ID());
            if (this.isIncludeNullsOrg()) {
                whcomb.append(" AND (AD_Org_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsOrg()) {
            whcomb.append(" AND AD_Org_ID IS NULL");
        }
        if (this.getAD_OrgTrx_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "OT", this.getAD_OrgTrx_ID());
            if (this.isIncludeNullsOrgTrx()) {
                whcomb.append(" AND (AD_OrgTrx_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsOrgTrx()) {
            whcomb.append(" AND AD_OrgTrx_ID IS NULL");
        }
        if (this.getM_Product_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "PR", this.getM_Product_ID());
            if (this.isIncludeNullsProduct()) {
                whcomb.append(" AND (M_Product_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsProduct()) {
            whcomb.append(" AND M_Product_ID IS NULL");
        }
        if (this.getC_Project_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "PJ", this.getC_Project_ID());
            if (this.isIncludeNullsProject()) {
                whcomb.append(" AND (C_Project_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsProject()) {
            whcomb.append(" AND C_Project_ID IS NULL");
        }
        if (this.getC_SalesRegion_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "SR", this.getC_SalesRegion_ID());
            if (this.isIncludeNullsSalesRegion()) {
                whcomb.append(" AND (C_SalesRegion_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsSalesRegion()) {
            whcomb.append(" AND C_SalesRegion_ID IS NULL");
        }
        if (this.getUserElement1_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "X1", this.getUserElement1_ID());
            if (this.isIncludeNullsUserElement1()) {
                whcomb.append(" AND (UserElement1_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUserElement1()) {
            whcomb.append(" AND UserElement1_ID IS NULL");
        }
        if (this.getUserElement2_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "X2", this.getUserElement2_ID());
            if (this.isIncludeNullsUserElement2()) {
                whcomb.append(" AND (UserElement2_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUserElement2()) {
            whcomb.append(" AND UserElement2_ID IS NULL");
        }
        if (this.getUser1_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "U1", this.getUser1_ID());
            if (this.isIncludeNullsUser1()) {
                whcomb.append(" AND (User1_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser1()) {
            whcomb.append(" AND User1_ID IS NULL");
        }
        if (this.getUser2_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "U2", this.getUser2_ID());
            if (this.isIncludeNullsUser2()) {
                whcomb.append(" AND (User2_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser2()) {
            whcomb.append(" AND User2_ID IS NULL");
        }
        if (this.getUser3_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "U3", this.getUser3_ID());
            if (this.isIncludeNullsUser3()) {
                whcomb.append(" AND (User3_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser3()) {
            whcomb.append(" AND User3_ID IS NULL");
        }
        if (this.getUser4_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "U4", this.getUser4_ID());
            if (this.isIncludeNullsUser4()) {
                whcomb.append(" AND (User4_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUser4()) {
            whcomb.append(" AND User4_ID IS NULL");
        }
        return whcomb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MReportColumn[").append(this.get_ID()).append(" - ").append(this.getName()).append(" - ").append(this.getDescription()).append(", SeqNo=").append(this.getSeqNo()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType()).append(", CurrencyType=").append(this.getCurrencyType()).append("/").append(this.getC_Currency_ID()).append(" - ColumnType=").append(this.getColumnType());
        if (this.isColumnTypeCalculation()) {
            sb.append(" - Calculation=").append(this.getCalculationType()).append(" - ").append(this.getOper_1_ID()).append(" - ").append(this.getOper_2_ID());
        } else if (this.isColumnTypeRelativePeriod()) {
            sb.append(" - Period=").append(this.getRelativePeriod());
        } else {
            sb.append(" - SegmentValue ElementType=").append(this.getElementType());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isCalculationTypeRange() {
        return "R".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeAdd() {
        return "A".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeSubtract() {
        return "S".equals(this.getCalculationType());
    }

    public boolean isCalculationTypePercent() {
        return "P".equals(this.getCalculationType());
    }

    public boolean isColumnTypeCalculation() {
        return "C".equals(this.getColumnType());
    }

    public boolean isColumnTypeRelativePeriod() {
        return "R".equals(this.getColumnType());
    }

    public boolean isColumnTypeSegmentValue() {
        return "S".equals(this.getColumnType());
    }

    public int getRelativePeriodAsInt() {
        BigDecimal bd = this.getRelativePeriod();
        if (bd == null) {
            return 0;
        }
        return bd.intValue();
    }

    @Override
    public BigDecimal getRelativePeriod() {
        if (this.getColumnType().equals("R") || this.getColumnType().equals("S")) {
            return super.getRelativePeriod();
        }
        return null;
    }

    @Override
    public String getElementType() {
        if (this.getColumnType().equals("S")) {
            return super.getElementType();
        }
        return null;
    }

    @Override
    public String getCalculationType() {
        if (this.getColumnType().equals("C")) {
            return super.getCalculationType();
        }
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String ct = this.getColumnType();
        if (ct.equals("R")) {
            this.setElementType(null);
            this.setCalculationType(null);
        } else if (ct.equals("C")) {
            this.setElementType(null);
            this.setRelativePeriod(null);
        } else if (ct.equals("S")) {
            this.setCalculationType(null);
        }
        return true;
    }

    public static MReportColumn copy(Properties ctx, int AD_Client_ID, int AD_Org_ID, int PA_ReportColumnSet_ID, MReportColumn source, String trxName) {
        MReportColumn retValue = new MReportColumn(ctx, 0, trxName);
        MReportColumn.copyValues(source, retValue, AD_Client_ID, AD_Org_ID);
        retValue.setPA_ReportColumnSet_ID(PA_ReportColumnSet_ID);
        retValue.setOper_1_ID(0);
        retValue.setOper_2_ID(0);
        return retValue;
    }
}

