/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MUOMConversion;
import org.compiere.project.process.ProjectGenOrder;
import org.compiere.project.process.ProjectPhaseGenOrderAbstract;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class ProjectPhaseGenOrder
extends ProjectPhaseGenOrderAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        int dropShipBPartnerLocationId;
        int dropShipBPartnerId;
        int documentTypeTargetId = this.getParameterAsInt("C_DocType_ID");
        Timestamp dateOrdered = this.getParameterAsTimestamp("DateOrdered");
        int projectId = 0;
        int projectPhaseId = 0;
        int projectTaskId = 0;
        String name = null;
        Object sql = "";
        int productId = 0;
        int seqNo = 0;
        String description = null;
        BigDecimal quantityToOrder = null;
        BigDecimal priceActual = null;
        BigDecimal quantityEntered = null;
        int projectUomId = 0;
        Timestamp datePromised = null;
        MProjectTask projectTask = null;
        MProjectPhase projectPhase = null;
        List<MProjectLine> projectLines = null;
        List<MProjectTask> tasks = null;
        this.log.info("doIt - C_ProjectPhase_ID=" + this.getRecord_ID());
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("C_ProjectPhase_ID == 0");
        }
        if (this.getDocSubTypeSO() == null) {
            throw new AdempiereException("@NotFound@ @DocSubTypeSO@");
        }
        if ("C_ProjectTask".equals(this.getTableName())) {
            projectTask = new MProjectTask(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            projectPhaseId = projectTask.getC_ProjectPhase_ID();
            projectTaskId = projectTask.getC_ProjectTask_ID();
            projectPhase = new MProjectPhase(this.getCtx(), projectPhaseId, this.get_TrxName());
            projectId = projectPhase.getC_Project_ID();
            name = projectTask.getName();
            productId = projectTask.getM_Product_ID() | 0;
            seqNo = projectTask.getSeqNo();
            description = projectTask.getDescription();
            quantityToOrder = projectTask.getQty();
            priceActual = projectTask.getPlannedAmt();
            quantityEntered = (BigDecimal)projectTask.get_Value("QtyEntered");
            projectUomId = projectTask.get_ValueAsInt("C_UOM_ID");
            projectLines = Arrays.asList(projectTask.getLines());
            sql = "select min(DatePromised) from c_projectline where c_projecttask_id = " + projectTaskId;
            datePromised = DB.getSQLValueTSEx(this.get_TrxName(), (String)sql, new Object[0]);
        } else if ("C_ProjectPhase".equals(this.getTableName())) {
            projectPhase = new MProjectPhase(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            projectId = projectPhase.getC_Project_ID();
            projectPhaseId = projectPhase.getC_ProjectPhase_ID();
            name = projectPhase.getName();
            productId = projectPhase.getM_Product_ID() | 0;
            seqNo = projectPhase.getSeqNo();
            description = projectPhase.getDescription();
            quantityToOrder = projectPhase.getQty();
            priceActual = projectPhase.getPlannedAmt();
            projectLines = projectPhase.getLines();
            quantityEntered = (BigDecimal)projectPhase.get_Value("QtyEntered");
            projectUomId = projectPhase.get_ValueAsInt("C_UOM_ID");
            tasks = projectPhase.getTasks();
            sql = "select min(DatePromised) from c_projectline where c_projectphase_id = " + projectPhaseId;
            datePromised = DB.getSQLValueTSEx(this.get_TrxName(), (String)sql, new Object[0]);
        }
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), projectId, this.get_TrxName());
        if (fromProject.getC_PaymentTerm_ID() <= 0) {
            throw new AdempiereException("@C_PaymentTerm_ID@ @NotFound@");
        }
        MOrder order = new MOrder(fromProject, true, this.getDocSubTypeSO());
        if (documentTypeTargetId > 0) {
            order.setC_DocTypeTarget_ID(documentTypeTargetId);
        }
        if (projectId > 0) {
            order.setC_Project_ID(projectId);
        }
        if (projectPhaseId > 0) {
            order.set_ValueOfColumn("C_ProjectPhase_ID", (Object)projectPhaseId);
            MProjectPhase phase = new MProjectPhase(this.getCtx(), projectPhaseId, this.get_TrxName());
            if (phase.get_ValueAsBoolean("IsDropShip")) {
                dropShipBPartnerId = phase.get_ValueAsInt("DropShip_BPartner_ID");
                dropShipBPartnerLocationId = phase.get_ValueAsInt("DropShip_Location_ID");
                if (dropShipBPartnerId > 0 && dropShipBPartnerLocationId > 0) {
                    order.setIsDropShip(phase.get_ValueAsBoolean("IsDropShip"));
                    order.setDropShip_BPartner_ID(dropShipBPartnerId);
                    order.setDropShip_Location_ID(dropShipBPartnerLocationId);
                }
            }
        }
        if (projectTaskId > 0) {
            order.set_ValueOfColumn("C_ProjectTask_ID", (Object)projectTaskId);
            MProjectTask task2 = new MProjectTask(this.getCtx(), projectTaskId, this.get_TrxName());
            if (task2.get_ValueAsBoolean("IsDropShip")) {
                dropShipBPartnerId = task2.get_ValueAsInt("DropShip_BPartner_ID");
                dropShipBPartnerLocationId = task2.get_ValueAsInt("DropShip_Location_ID");
                if (dropShipBPartnerId > 0 && dropShipBPartnerLocationId > 0) {
                    order.setIsDropShip(task2.get_ValueAsBoolean("IsDropShip"));
                    order.setDropShip_BPartner_ID(dropShipBPartnerId);
                    order.setDropShip_Location_ID(dropShipBPartnerLocationId);
                }
            }
        }
        if (dateOrdered != null) {
            order.setDateOrdered(dateOrdered);
        }
        for (MProjectLine pLine : projectLines) {
            Timestamp dateOrder;
            Timestamp datePromisedLine = (Timestamp)pLine.get_Value("DatePromised");
            if (datePromisedLine.compareTo(dateOrder = TimeUtil.addDays(order.getDateOrdered(), -1)) > 0) continue;
            throw new AdempiereException("ERROR: Fecha prometida de lineas debe ser mayor a fecha de la orden");
        }
        order.setDescription(order.getDescription() + " - " + name);
        if (datePromised != null) {
            order.setDatePromised(datePromised);
        }
        order.saveEx();
        if (productId != 0) {
            BigDecimal price;
            MProduct product = new MProduct(this.getCtx(), productId, this.get_TrxName());
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(seqNo);
            StringBuilder stringBuilder = new StringBuilder(name);
            if (!Util.isEmpty(description)) {
                stringBuilder.append(" - ").append(description);
            }
            orderLine.setDescription(stringBuilder.toString());
            orderLine.setM_Product_ID(productId, true);
            this.setQuantityToOrder(orderLine, product, projectUomId, quantityEntered, quantityToOrder);
            orderLine.setPrice();
            orderLine.setC_Project_ID(fromProject.getC_Project_ID());
            if (projectPhaseId > 0) {
                orderLine.setC_ProjectPhase_ID(projectPhaseId);
            }
            if (projectTaskId > 0) {
                orderLine.setC_ProjectTask_ID(projectTaskId);
            }
            if ((price = priceActual) != null && price.compareTo(Env.ZERO) != 0) {
                orderLine.setPrice(price);
            }
            orderLine.setTax();
            orderLine.saveEx();
            return "@C_Order_ID@ " + order.getDocumentNo() + " (1)";
        }
        AtomicInteger count = new AtomicInteger(0);
        if (projectLines != null) {
            projectLines.stream().forEach(projectLine -> {
                MOrderLine orderLine = new MOrderLine(order);
                orderLine.setLine(projectLine.getLine());
                orderLine.setDescription(projectLine.getDescription());
                orderLine.setM_Product_ID(projectLine.getM_Product_ID(), true);
                MProduct product = new MProduct(this.getCtx(), projectLine.getM_Product_ID(), this.get_TrxName());
                BigDecimal toOrder = projectLine.getPlannedQty().subtract(projectLine.getInvoicedQty());
                this.setQuantityToOrder(orderLine, product, projectLine.get_ValueAsInt("C_UOM_ID"), (BigDecimal)projectLine.get_Value("Qtyentered"), toOrder);
                orderLine.setPrice();
                if (projectLine.getPlannedPrice() != null && projectLine.getPlannedPrice().compareTo(Env.ZERO) != 0) {
                    orderLine.setPrice(projectLine.getPlannedPrice());
                    orderLine.setPriceList(projectLine.getPlannedPrice());
                }
                orderLine.setDiscount();
                orderLine.setTax();
                orderLine.setC_Project_ID(fromProject.getC_Project_ID());
                orderLine.setC_ProjectPhase_ID(projectLine.getC_ProjectPhase_ID());
                if (projectLine.get_Value("DatePromised") != null) {
                    orderLine.setDatePromised((Timestamp)projectLine.get_Value("DatePromised"));
                }
                if (projectLine.getC_ProjectTask_ID() > 0) {
                    orderLine.setC_ProjectTask_ID(projectLine.getC_ProjectTask_ID());
                }
                orderLine.set_ValueOfColumn("IsBonusProduct", projectLine.get_Value("IsBonusProduct"));
                orderLine.set_ValueOfColumn("EndDate", projectLine.get_Value("EndDate"));
                orderLine.set_ValueOfColumn("Reference", projectLine.get_Value("Reference"));
                orderLine.set_ValueOfColumn("DescriptionURL", projectLine.get_Value("DescriptionURL"));
                orderLine.saveEx();
                count.getAndUpdate(no -> no + 1);
            });
            if (projectLines.size() != count.get()) {
                this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + projectLines.size() + " <> Saved=" + count.get());
            }
        }
        if (tasks != null) {
            tasks.stream().filter(task -> task.getM_Product_ID() != 0).forEach(fromTask -> {
                MOrderLine orderLine = new MOrderLine(order);
                orderLine.setLine(fromTask.getSeqNo());
                StringBuilder stringBuilder = new StringBuilder(fromTask.getName());
                if (fromTask.getDescription() != null && fromTask.getDescription().length() > 0) {
                    stringBuilder.append(" - ").append(fromTask.getDescription());
                }
                orderLine.setDescription(stringBuilder.toString());
                orderLine.setM_Product_ID(fromTask.getM_Product_ID(), true);
                MProduct productLine = new MProduct(this.getCtx(), fromTask.getM_Product_ID(), this.get_TrxName());
                this.setQuantityToOrder(orderLine, productLine, fromTask.get_ValueAsInt("C_UOM_ID"), (BigDecimal)fromTask.get_Value("Qtyentered"), fromTask.getQty());
                orderLine.setPrice();
                orderLine.setC_Project_ID(fromProject.getC_Project_ID());
                orderLine.setC_ProjectPhase_ID(fromTask.getC_ProjectPhase_ID());
                orderLine.setC_ProjectTask_ID(fromTask.getC_ProjectTask_ID());
                orderLine.setTax();
                orderLine.set_ValueOfColumn("IsBonusProduct", fromTask.get_Value("IsBonusProduct"));
                orderLine.set_ValueOfColumn("EndDate", fromTask.get_Value("EndDate"));
                orderLine.set_ValueOfColumn("Reference", fromTask.get_Value("Reference"));
                orderLine.saveEx();
                count.getAndUpdate(no -> no + 1);
            });
            if (tasks.size() != count.get() - projectLines.size()) {
                this.log.log(Level.SEVERE, "doIt - Lines difference - ProjectTasks=" + tasks.size() + " <> Saved=" + count.get());
            }
        }
        return "@C_Order_ID@ " + order.getDocumentNo() + " (" + count + ")";
    }

    private void setQuantityToOrder(MOrderLine orderLine, MProduct product, int uomToId, BigDecimal quantityEntered, BigDecimal quantityOrdered) {
        int uomId = product.getC_UOM_ID();
        if (uomToId > 0 && quantityEntered != null && quantityEntered != Env.ZERO) {
            uomId = uomToId;
            if (uomId != product.getC_UOM_ID()) {
                BigDecimal convertedQuantity = MUOMConversion.convertProductFrom(this.getCtx(), product.getM_Product_ID(), uomToId, quantityEntered);
                if (convertedQuantity == null) {
                    quantityEntered = quantityOrdered;
                } else {
                    quantityOrdered = convertedQuantity;
                }
                orderLine.setQty(quantityEntered);
                orderLine.setQtyOrdered(quantityOrdered);
            } else {
                orderLine.setQty(quantityOrdered);
            }
        } else {
            orderLine.setQty(quantityOrdered);
        }
        orderLine.setC_UOM_ID(uomId);
    }
}

