/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MUOMConversion;
import org.compiere.project.process.ProjectGenOrderAbstract;
import org.compiere.util.Env;

public class ProjectGenOrder
extends ProjectGenOrderAbstract {
    @Override
    protected String doIt() throws Exception {
        this.log.info("C_Project_ID=" + this.getRecord_ID());
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Project_ID@ @NotFound@");
        }
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        Env.setSOTrx(this.getCtx(), true);
        MOrder order = new MOrder(fromProject, true, "WI");
        order.setC_DocTypeTarget_ID(this.getDocTypeId());
        order.saveEx();
        AtomicInteger count = new AtomicInteger(0);
        if ("S".equals(fromProject.getProjectCategory())) {
            throw new AdempiereException("Service Charge Projects are on the TODO List");
        }
        List<MProjectLine> fromProjectLines = fromProject.getLines();
        fromProjectLines.stream().forEach(projectLine -> {
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(projectLine.getLine());
            orderLine.setDescription(projectLine.getDescription());
            orderLine.setM_Product_ID(projectLine.getM_Product_ID(), true);
            BigDecimal quantityToOrder = projectLine.getPlannedQty().subtract(projectLine.getInvoicedQty());
            MProduct product = MProduct.get(this.getCtx(), projectLine.getM_Product_ID());
            int uomId = product.getC_UOM_ID();
            if (projectLine.get_ValueAsInt("C_UOM_ID") > 0 && projectLine.get_Value("Qtyentered") != null) {
                uomId = projectLine.get_ValueAsInt("C_UOM_ID");
                if (uomId != product.getC_UOM_ID()) {
                    BigDecimal quantityEntered = MUOMConversion.convertProductTo(this.getCtx(), projectLine.getM_Product_ID(), uomId, quantityToOrder);
                    if (quantityEntered == null) {
                        quantityEntered = quantityToOrder;
                    }
                    orderLine.setQty(quantityEntered);
                    orderLine.setQtyOrdered(quantityToOrder);
                } else {
                    orderLine.setQty(quantityToOrder);
                }
            } else {
                orderLine.setQty(quantityToOrder);
            }
            orderLine.setC_UOM_ID(uomId);
            orderLine.setPrice();
            if (projectLine.getPlannedPrice() != null && projectLine.getPlannedPrice().compareTo(Env.ZERO) != 0) {
                orderLine.setPrice(projectLine.getPlannedPrice());
            }
            orderLine.setDiscount();
            orderLine.setC_Project_ID(projectLine.getC_Project_ID());
            if (projectLine.getC_ProjectPhase_ID() > 0) {
                orderLine.setC_ProjectPhase_ID(projectLine.getC_ProjectPhase_ID());
            }
            if (projectLine.getC_ProjectTask_ID() > 0) {
                orderLine.setC_ProjectTask_ID(projectLine.getC_ProjectTask_ID());
            }
            orderLine.setTax();
            orderLine.saveEx();
            count.getAndUpdate(no -> no + 1);
        });
        if (fromProjectLines.size() != count.get()) {
            this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + fromProjectLines.size() + " <> Saved=" + count.get());
        }
        return "@C_Order_ID@ " + order.getDocumentNo() + " (" + count + ")";
    }

    protected static MProject getProject(Properties ctx, int projectId, String trxName) {
        MProject fromProject = new MProject(ctx, projectId, trxName);
        if (fromProject.getC_Project_ID() == 0) {
            throw new AdempiereException("@C_Project_ID@ @NotFound@" + projectId);
        }
        if (fromProject.getM_PriceList_ID() == 0) {
            throw new AdempiereException("@M_PriceList_ID@ @NotFound@ @To@ @C_Project_ID@");
        }
        if (fromProject.getM_Warehouse_ID() == 0) {
            throw new AdempiereException("@M_Warehouse_ID@ @NotFound@ @To@ @C_Project_ID@");
        }
        if (fromProject.getC_BPartner_ID() == 0) {
            throw new AdempiereException("@C_BPartner_ID@ @NotFound@");
        }
        if (fromProject.getC_BPartner_Location_ID() == 0) {
            throw new AdempiereException("@C_BPartner_Location_ID@ @NotFound@");
        }
        return fromProject;
    }
}

