/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.project.controller;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_ProjectPhase;
import org.adempiere.core.domains.models.I_C_ProjectTask;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProduct;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutProject
extends CalloutEngine {
    public String planned(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal PlannedAmt;
        BigDecimal PlannedPrice;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int StdPrecision = Env.getContextAsInt(ctx, WindowNo, "StdPrecision");
        BigDecimal PlannedQty = (BigDecimal)mTab.getValue("PlannedQty");
        if (PlannedQty == null) {
            PlannedQty = Env.ONE;
        }
        if ((PlannedPrice = (BigDecimal)mTab.getValue("PlannedPrice")) == null) {
            PlannedPrice = Env.ZERO;
        }
        if ((PlannedAmt = PlannedQty.multiply(PlannedPrice)).scale() > StdPrecision) {
            PlannedAmt = PlannedAmt.setScale(StdPrecision, 4);
        }
        this.log.fine("PlannedQty=" + PlannedQty + " * PlannedPrice=" + PlannedPrice + " -> PlannedAmt=" + PlannedAmt + " (Precision=" + StdPrecision + ")");
        mTab.setValue("PlannedAmt", (Object)PlannedAmt);
        return "";
    }

    public String projectPhase(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        Optional<I_C_ProjectPhase> projectPhaseOptional = Optional.of(GridTabWrapper.create(gridTab, I_C_ProjectPhase.class));
        projectPhaseOptional.ifPresent(projectPhase -> {
            MProjectTypePhase projectTypePhase = (MProjectTypePhase)projectPhase.getC_Phase();
            if (projectPhase.getC_Phase_ID() > 0) {
                if (projectPhase.getName() == null || projectPhase.getName().isEmpty()) {
                    projectPhase.setName(projectTypePhase.getName());
                }
                if (projectPhase.getDescription() == null || projectPhase.getDescription().isEmpty()) {
                    projectPhase.setDescription(projectTypePhase.getDescription());
                }
                if (projectPhase.getHelp() == null || projectPhase.getHelp().isEmpty()) {
                    projectPhase.setHelp(projectTypePhase.getHelp());
                }
                if (projectPhase.getPriorityRule() == null || projectPhase.getPriorityRule().isEmpty()) {
                    projectPhase.setPriorityRule(projectTypePhase.getPriorityRule());
                }
                projectPhase.setIsMilestone(projectTypePhase.isMilestone());
                if (projectPhase.getDurationUnit() == null || projectPhase.getDurationUnit().isEmpty()) {
                    projectPhase.setDurationUnit(projectTypePhase.getDurationUnit());
                }
                if (projectPhase.getDurationEstimated().signum() == 0) {
                    projectPhase.setDurationEstimated(projectTypePhase.getDurationEstimated());
                }
                if (projectPhase.getM_Product_ID() <= 0) {
                    projectPhase.setM_Product_ID(projectTypePhase.getM_Product_ID());
                }
                if (projectPhase.getPP_Product_BOM_ID() <= 0) {
                    projectPhase.setPP_Product_BOM_ID(projectTypePhase.getPP_Product_BOM_ID());
                }
                if (projectPhase.getAD_Workflow_ID() <= 0) {
                    projectPhase.setAD_Workflow_ID(projectTypePhase.getAD_Workflow_ID());
                }
                if (projectPhase.getQty().signum() == 0) {
                    projectPhase.setQty(projectTypePhase.getStandardQty());
                }
                projectPhase.setIsIndefinite(projectTypePhase.isIndefinite());
                projectPhase.setIsRecurrent(projectTypePhase.isRecurrent());
                projectPhase.setFrequencyType(projectTypePhase.getFrequencyType());
                projectPhase.setFrequency(projectTypePhase.getFrequency());
                projectPhase.setRunsMax(projectTypePhase.getRunsMax());
            }
        });
        return "";
    }

    public String projectTask(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        Optional<I_C_ProjectTask> projectTaskOptional = Optional.of(GridTabWrapper.create(gridTab, I_C_ProjectTask.class));
        projectTaskOptional.ifPresent(projectTask -> {
            MProjectTypeTask projectTypeTask = (MProjectTypeTask)projectTask.getC_Task();
            if (projectTask.getC_Task_ID() > 0) {
                if (projectTask.getName() == null || projectTask.getName().isEmpty()) {
                    projectTask.setName(projectTypeTask.getName());
                }
                if (projectTask.getDescription() == null || projectTask.getDescription().isEmpty()) {
                    projectTask.setDescription(projectTypeTask.getDescription());
                }
                if (projectTask.getHelp() == null || projectTask.getHelp().isEmpty()) {
                    projectTask.setHelp(projectTypeTask.getHelp());
                }
                if (projectTask.getPriorityRule() == null || projectTask.getPriorityRule().isEmpty()) {
                    projectTask.setPriorityRule(projectTypeTask.getPriorityRule());
                }
                projectTask.setIsMilestone(projectTypeTask.isMilestone());
                if (projectTask.getDurationUnit() == null || projectTask.getDurationUnit().isEmpty()) {
                    projectTask.setDurationUnit(projectTypeTask.getDurationUnit());
                }
                if (projectTask.getDurationEstimated().signum() == 0) {
                    projectTask.setDurationEstimated(projectTypeTask.getDurationEstimated());
                }
                if (projectTask.getM_Product_ID() <= 0) {
                    projectTask.setM_Product_ID(projectTypeTask.getM_Product_ID());
                }
                if (projectTask.getPP_Product_BOM_ID() <= 0) {
                    projectTask.setPP_Product_BOM_ID(projectTypeTask.getPP_Product_BOM_ID());
                }
                if (projectTask.getAD_Workflow_ID() <= 0) {
                    projectTask.setAD_Workflow_ID(projectTypeTask.getAD_Workflow_ID());
                }
                projectTask.setIsIndefinite(projectTypeTask.isIndefinite());
                projectTask.setIsRecurrent(projectTypeTask.isRecurrent());
                projectTask.setFrequencyType(projectTypeTask.getFrequencyType());
                projectTask.setFrequency(projectTypeTask.getFrequency());
                projectTask.setRunsMax(projectTypeTask.getRunsMax());
            }
        });
        return "";
    }

    public String completeTask(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        Optional<I_C_ProjectTask> projectTaskOptional = Optional.of(GridTabWrapper.create(gridTab, I_C_ProjectTask.class));
        projectTaskOptional.ifPresent(projectTask -> {
            if (projectTask.getPercentageCompleted().compareTo(new BigDecimal(100)) == 0 && !projectTask.isComplete()) {
                projectTask.setIsComplete(true);
            }
            if (projectTask.isComplete() && projectTask.getPercentageCompleted().compareTo(new BigDecimal(100)) <= 0) {
                projectTask.setPercentageCompleted(new BigDecimal(100));
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, lship.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, lbill.C_BPartner_Location_ID AS Bill_Location_ID, p.SOCreditStatus,  p.SalesRep_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String cont;
                String loc;
                Integer salesRep = rs.getInt("SalesRep_ID");
                if (IsSOTrx && salesRep != 0) {
                    mTab.setValue("SalesRep_ID", (Object)salesRep);
                }
                Integer salesRepPO = rs.getInt("SalesRep_ID");
                if (!IsSOTrx && salesRepPO != 0) {
                    mTab.setValue("C_BPartnerSR_ID", (Object)salesRepPO);
                }
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = Env.getContextAsInt(ctx, "#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    shipTo_ID = Integer.parseInt(loc);
                }
                if (shipTo_ID == 0) {
                    mTab.setValue("C_BPartner_Location_ID", null);
                } else {
                    mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(shipTo_ID));
                }
                int contID = rs.getInt("AD_User_ID");
                if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (cont = Env.getContext(ctx, WindowNo, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                }
                String s = rs.getString("POReference");
                if (s != null && s.length() != 0) {
                    mTab.setValue("POReference", (Object)s);
                }
                if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                mTab.setValue("PaymentRule", (Object)"P");
            }
        }
        catch (SQLException e) {
            String string;
            try {
                this.log.log(Level.SEVERE, sql, e);
                string = e.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String quantity(Properties ctx, int windowNo, GridTab tab, GridField field, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int productId = 0;
        if (!(field.getColumnName().equals("PlannedQty") || field.getColumnName().equals("Qty") || field.getColumnName().equals("QtyEntered") || field.getColumnName().equals("C_UOM_ID") || field.getColumnName().equals("M_Product_ID"))) {
            return "";
        }
        int uOmToId = Env.getContextAsInt(ctx, windowNo, "C_UOM_ID");
        if (tab.getValue("M_Product_ID") != null) {
            productId = (Integer)tab.getValue("M_Product_ID");
            if (productId <= 0) {
                return "";
            }
        } else if (field.getColumnName().equals("QtyEntered")) {
            throw new AdempiereException("Debe seleccionar producto");
        }
        BigDecimal quantityEntered = (BigDecimal)tab.getValue("QtyEntered");
        BigDecimal plannedQuantity = (BigDecimal)tab.getValue("PlannedQty");
        if (plannedQuantity == null) {
            plannedQuantity = (BigDecimal)tab.getValue("Qty");
        }
        if (quantityEntered == null) {
            quantityEntered = Env.ZERO;
        }
        if (plannedQuantity == null) {
            plannedQuantity = Env.ZERO;
        }
        this.log.fine("QtyEntered = " + quantityEntered + ", PlannedQty=" + plannedQuantity + ", UOM=" + uOmToId);
        if (field.getColumnName().equals("QtyEntered") || field.getColumnName().equals("C_UOM_ID") || field.getColumnName().equals("M_Product_ID")) {
            BigDecimal quantityEnteredRounded = quantityEntered.setScale(MUOM.getPrecision(ctx, uOmToId), 4);
            if (quantityEntered.compareTo(quantityEnteredRounded) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + uOmToId + "; QtyEntered=" + quantityEntered + "->" + quantityEnteredRounded);
                quantityEntered = quantityEnteredRounded;
                tab.setValue("QtyEntered", (Object)quantityEntered);
            }
            if ((plannedQuantity = MUOMConversion.convertProductFrom(ctx, productId, uOmToId, quantityEntered)) == null) {
                plannedQuantity = quantityEntered;
            }
            boolean conversion = quantityEntered.compareTo(plannedQuantity) != 0;
            this.log.fine("UOM=" + uOmToId + ", QtyEntered=" + quantityEntered + " -> " + conversion + " PlannedQty=" + plannedQuantity);
            tab.setValue("PlannedQty", (Object)plannedQuantity);
            tab.setValue("Qty", (Object)plannedQuantity);
        } else if (field.getColumnName().equals("PlannedQty") || field.getColumnName().equals("Qty")) {
            int precision = MProduct.get(ctx, productId).getUOMPrecision();
            BigDecimal quantityRounded = plannedQuantity.setScale(precision, 4);
            if (plannedQuantity.compareTo(quantityRounded) != 0) {
                this.log.fine("Corrected PlannedQty Scale " + plannedQuantity + "->" + quantityRounded);
                plannedQuantity = quantityRounded;
                tab.setValue("PlannedQty", (Object)plannedQuantity);
            }
            if ((quantityEntered = MUOMConversion.convertProductTo(ctx, productId, uOmToId, plannedQuantity)) == null) {
                quantityEntered = plannedQuantity;
            }
            boolean conversion = plannedQuantity.compareTo(quantityEntered) != 0;
            this.log.fine("UOM=" + uOmToId + ", PlannedQty=" + plannedQuantity + " -> " + conversion + " QtyEntered=" + quantityEntered);
            tab.setValue("QtyEntered", (Object)quantityEntered);
        }
        if (plannedQuantity == null) {
            plannedQuantity = quantityEntered;
        }
        return "";
    }
}

