/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;

public class TabCreateFields
extends SvrProcess {
    private int tabId = 0;
    private int count = 0;

    @Override
    protected void prepare() {
        this.tabId = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MTab tab = new MTab(this.getCtx(), this.tabId, this.get_TrxName());
        if (this.tabId == 0 || tab.get_ID() == 0) {
            throw new AdempiereSystemError("@NotFound@: @AD_Tab_ID@ " + this.tabId);
        }
        this.log.info(tab.toString());
        String whereClause = "NOT EXISTS(SELECT 1 FROM AD_Field f WHERE AD_Column.AD_Column_ID = f.AD_Column_ID \t\t\t\t\t\tAND AD_Column.AD_Table_ID = ? \t\t\t\t\t\tAND f.AD_Tab_ID = ?) AND AD_Table_ID=? AND NOT (Name LIKE 'Created%' OR Name LIKE 'Updated%')";
        List columns = new Query(this.getCtx(), "AD_Column", whereClause, this.get_TrxName()).setParameters(tab.getAD_Table_ID(), tab.getAD_Tab_ID(), tab.getAD_Table_ID()).setOnlyActiveRecords(true).setOrderBy("Name").list();
        columns.stream().forEach(column -> {
            MField field = new MField(tab);
            field.setColumn((MColumn)column);
            if ("D".equals(column.getEntityType())) {
                field.setEntityType(tab.getEntityType());
            } else {
                field.setEntityType(column.getEntityType());
            }
            if (column.isKey() || column.getColumnName().equals("UUID")) {
                field.setIsDisplayed(false);
            }
            if (field.save()) {
                this.addLog(0, null, null, column.getName());
                ++this.count;
            }
        });
        return "@Created@ #" + this.count;
    }
}

