/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.compiere.Adempiere;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.RoleAccessUpdateAbstract;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.eevolution.services.dsl.ProcessBuilder;

public class RoleAccessUpdate
extends RoleAccessUpdateAbstract {
    private static CLogger logger = CLogger.getCLogger(RoleAccessUpdate.class);

    @Override
    protected String doIt() throws Exception {
        this.getProcessLog().info("AD_Client_ID=" + this.getClientId() + ", AD_Role_ID=" + this.getRoleId());
        this.getRoles(this.getClientId(), this.getRoleId()).forEach(this::updateRole);
        return "";
    }

    Stream<MRole> getRoles(int clientId, int roleId) {
        ArrayList<Object> params = new ArrayList<Object>();
        Object whereClause = "";
        if (this.getClientId() > 0) {
            whereClause = "AD_Client_ID=?";
            params.add(this.getClientId());
        }
        if (this.getRoleId() >= 0) {
            if (!((String)whereClause).isEmpty()) {
                whereClause = (String)whereClause + " AND ";
            }
            whereClause = (String)whereClause + "AD_Role_ID=?";
            params.add(this.getRoleId());
        }
        return this.getRoleQuery((String)whereClause).setOnlyActiveRecords(true).setParameters(params).setOrderBy("AD_Client_ID, Name").list().stream();
    }

    CLogger getProcessLog() {
        return this.log;
    }

    Query getRoleQuery(String whereClause) {
        return new Query(this.getCtx(), "AD_Role", whereClause, this.get_TrxName());
    }

    protected void updateRole(MRole role) {
        this.addLog(0, null, null, role.getName() + ": " + role.updateAccessRecords());
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.FINE);
        logger.info("Role Access Update");
        logger.info("------------------");
        ProcessInfo pi = ProcessBuilder.create(Env.getCtx()).process(RoleAccessUpdate.class).withParameter("AD_Client_ID", 0).withParameter("AD_Role_ID", null).execute();
        logger.info("Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
    }
}

