/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.adempiere.exceptions.NoVendorForProductException;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.process.RequisitionPOCreateAbstract;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class RequisitionPOCreate
extends RequisitionPOCreateAbstract {
    private MOrder purchaseOrder = null;
    private MOrderLine purcaseOrderLine = null;
    private HashMap<MultiKey, MOrder> purchaseOrdersCache = new HashMap();
    private int requisitionId = 0;
    private int productId = 0;
    private int attributeSetInstanceId = 0;
    private MBPartner businessPartner = null;
    private List<Integer> m_excludedVendors = new ArrayList<Integer>();

    @Override
    protected void prepare() {
        super.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (this.getSelectionKeys() != null && this.getSelectionKeys().size() > 0) {
            for (int requisitionLineId : this.getSelectionKeys()) {
                MRequisitionLine requisitionLine = new MRequisitionLine(this.getCtx(), requisitionLineId, this.get_TrxName());
                this.process(requisitionLine);
            }
            this.closeOrder();
            return "";
        }
        if (this.getRequisitionId() != 0) {
            this.log.info("M_Requisition_ID=" + this.getRequisitionId());
            MRequisition requisition = new MRequisition(this.getCtx(), this.getRequisitionId(), this.get_TrxName());
            if (!"CO".equals(requisition.getDocStatus())) {
                throw new AdempiereUserError("@DocStatus@ = " + requisition.getDocStatus());
            }
            MRequisitionLine[] requisitionLines = requisition.getLines();
            for (int i2 = 0; i2 < requisitionLines.length; ++i2) {
                if (requisitionLines[i2].getC_OrderLine_ID() != 0) continue;
                this.process(requisitionLines[i2]);
            }
            this.closeOrder();
            return "";
        }
        this.log.info("AD_Org_ID=" + this.getOrgId() + ", M_Warehouse_ID=" + this.getWarehouseId() + ", DateDoc=" + this.getDateDoc() + "/" + this.getDateDocTo() + ", DateRequired=" + this.getDateRequired() + "/" + this.getDateRequiredTo() + ", PriorityRule=" + this.getPriorityRule() + ", AD_User_ID=" + this.getUserId() + ", M_Product_ID=" + this.getProductId() + ", ConsolidateDocument" + this.isConsolidateDocument());
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("C_OrderLine_ID IS NULL");
        if (this.getOrgId() > 0) {
            whereClause.append(" AND AD_Org_ID=?");
            params.add(this.getOrgId());
        }
        if (this.getProductId() > 0) {
            whereClause.append(" AND M_Product_ID=?");
            params.add(this.getProductId());
        } else if (this.getProductCategoryId() > 0) {
            whereClause.append(" AND EXISTS (SELECT 1 FROM M_Product p WHERE M_RequisitionLine.M_Product_ID=p.M_Product_ID").append(" AND p.M_Product_Category_ID=?)");
            params.add(this.getProductCategoryId());
        }
        if (this.getBPGroupId() > 0) {
            whereClause.append(" AND (").append("M_RequisitionLine.C_BPartner_ID IS NULL").append(" OR EXISTS (SELECT 1 FROM C_BPartner bp WHERE M_RequisitionLine.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)").append(")");
            params.add(this.getBPGroupId());
        }
        whereClause.append(" AND EXISTS (SELECT 1 FROM M_Requisition r WHERE M_RequisitionLine.M_Requisition_ID=r.M_Requisition_ID").append(" AND r.DocStatus=?");
        params.add("CO");
        if (this.getWarehouseId() > 0) {
            whereClause.append(" AND r.M_Warehouse_ID=?");
            params.add(this.getWarehouseId());
        }
        if (this.getDateDoc() != null) {
            whereClause.append(" AND r.DateDoc >= ?");
            params.add(this.getDateDoc());
        }
        if (this.getDateDocTo() != null) {
            whereClause.append(" AND r.DateDoc <= ?");
            params.add(this.getDateDocTo());
        }
        if (this.getDateRequired() != null) {
            whereClause.append(" AND r.DateRequired >= ?");
            params.add(this.getDateRequired());
        }
        if (this.getDateRequiredTo() != null) {
            whereClause.append(" AND r.DateRequired <= ?");
            params.add(this.getDateRequiredTo());
        }
        if (this.getPriorityRule() != null) {
            whereClause.append(" AND r.PriorityRule >= ?");
            params.add(this.getPriorityRule());
        }
        if (this.getUserId() > 0) {
            whereClause.append(" AND r.AD_User_ID=?");
            params.add(this.getUserId());
        }
        whereClause.append(")");
        StringBuffer orderClause = new StringBuffer();
        if (!this.isConsolidateDocument()) {
            orderClause.append("M_Requisition_ID, ");
        }
        orderClause.append("(SELECT DateRequired FROM M_Requisition r WHERE M_RequisitionLine.M_Requisition_ID=r.M_Requisition_ID),");
        orderClause.append("M_Product_ID, C_Charge_ID, M_AttributeSetInstance_ID");
        POResultSet rs = new Query(this.getCtx(), "M_RequisitionLine", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy(orderClause.toString()).setClient_ID().scroll();
        try {
            while (rs.hasNext()) {
                this.process((MRequisitionLine)rs.next());
            }
        }
        finally {
            DB.close(rs);
            rs = null;
        }
        this.closeOrder();
        return "";
    }

    private void process(MRequisitionLine requisitionLine) throws Exception {
        if (requisitionLine.getM_Product_ID() == 0 && requisitionLine.getC_Charge_ID() == 0) {
            this.log.warning("Ignored Line" + requisitionLine.getLine() + " " + requisitionLine.getDescription() + " - " + requisitionLine.getLineNetAmt());
            return;
        }
        if (!this.isConsolidateDocument() && requisitionLine.getM_Requisition_ID() != this.requisitionId) {
            this.closeOrder();
        }
        if (this.purcaseOrderLine == null || requisitionLine.getM_Product_ID() != this.productId || requisitionLine.getM_AttributeSetInstance_ID() != this.attributeSetInstanceId || requisitionLine.getC_Charge_ID() != 0 || this.purchaseOrder == null || this.purchaseOrder.getDatePromised().compareTo(requisitionLine.getDateRequired()) != 0) {
            this.newLine(requisitionLine);
            if (this.purcaseOrderLine == null) {
                return;
            }
        }
        this.purcaseOrderLine.setQty(this.purcaseOrderLine.getQtyOrdered().add(requisitionLine.getQty()));
        requisitionLine.setC_OrderLine_ID(this.purcaseOrderLine.getC_OrderLine_ID());
        requisitionLine.saveEx();
    }

    private void newOrder(MRequisitionLine requisitionLine, int partnerId) throws Exception {
        if (this.purchaseOrder != null) {
            this.closeOrder();
        }
        if (this.businessPartner == null || partnerId != this.businessPartner.get_ID()) {
            this.businessPartner = MBPartner.get(this.getCtx(), partnerId);
        }
        Timestamp dateRequired = requisitionLine.getDateRequired();
        int priceListId = requisitionLine.getParent().getM_PriceList_ID();
        MultiKey key = new MultiKey((Object)partnerId, (Object)dateRequired, (Object)priceListId);
        this.purchaseOrder = this.purchaseOrdersCache.get(key);
        if (this.purchaseOrder == null) {
            this.purchaseOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
            this.purchaseOrder.setAD_Org_ID(requisitionLine.getAD_Org_ID());
            this.purchaseOrder.setM_Warehouse_ID(requisitionLine.getParent().getM_Warehouse_ID());
            this.purchaseOrder.setDatePromised(dateRequired);
            this.purchaseOrder.setIsSOTrx(false);
            this.purchaseOrder.setC_DocTypeTarget_ID();
            this.purchaseOrder.setBPartner(this.businessPartner);
            this.purchaseOrder.setM_PriceList_ID(priceListId);
            if (!this.isConsolidateDocument()) {
                this.purchaseOrder.setDescription(Msg.getElement(this.getCtx(), "M_Requisition_ID") + ": " + requisitionLine.getParent().getDocumentNo());
            }
            this.purchaseOrder.saveEx();
            this.purchaseOrdersCache.put(key, this.purchaseOrder);
        }
        this.requisitionId = requisitionLine.getM_Requisition_ID();
    }

    private void closeOrder() throws Exception {
        if (this.purcaseOrderLine != null) {
            this.purcaseOrderLine.saveEx();
        }
        if (this.purchaseOrder != null) {
            this.purchaseOrder.load(this.get_TrxName());
            this.addLog(0, null, this.purchaseOrder.getGrandTotal(), this.purchaseOrder.getDocumentNo());
        }
        this.purchaseOrder = null;
        this.purcaseOrderLine = null;
    }

    private void newLine(MRequisitionLine requisitionLine) throws Exception {
        if (this.purcaseOrderLine != null) {
            this.purcaseOrderLine.saveEx();
        }
        this.purcaseOrderLine = null;
        MProduct product = MProduct.get(this.getCtx(), requisitionLine.getM_Product_ID());
        int partnerId = requisitionLine.getC_BPartner_ID();
        if (partnerId == 0) {
            if (requisitionLine.getC_Charge_ID() != 0) {
                MCharge charge = MCharge.get(this.getCtx(), requisitionLine.getC_Charge_ID());
                partnerId = charge.getC_BPartner_ID();
                if (partnerId == 0) {
                    throw new AdempiereUserError("No Vendor for Charge " + charge.getName());
                }
            } else {
                MProductPO[] pproductPurchaseInfo = MProductPO.getOfProduct(this.getCtx(), product.getM_Product_ID(), null);
                for (int i2 = 0; i2 < pproductPurchaseInfo.length; ++i2) {
                    if (!pproductPurchaseInfo[i2].isCurrentVendor() || pproductPurchaseInfo[i2].getC_BPartner_ID() == 0) continue;
                    partnerId = pproductPurchaseInfo[i2].getC_BPartner_ID();
                    break;
                }
                if (partnerId == 0 && pproductPurchaseInfo.length > 0) {
                    partnerId = pproductPurchaseInfo[0].getC_BPartner_ID();
                }
                if (partnerId == 0) {
                    throw new NoVendorForProductException(product.getName());
                }
            }
        }
        if (!this.isGenerateForVendor(partnerId)) {
            this.log.info("Skip for partner " + partnerId);
            return;
        }
        if (this.purchaseOrder == null || this.purchaseOrder.getC_BPartner_ID() != partnerId) {
            this.newOrder(requisitionLine, partnerId);
        }
        this.purcaseOrderLine = new MOrderLine(this.purchaseOrder);
        this.purcaseOrderLine.setDatePromised(requisitionLine.getDateRequired());
        if (product != null) {
            this.purcaseOrderLine.setProduct(product);
            this.purcaseOrderLine.setM_AttributeSetInstance_ID(requisitionLine.getM_AttributeSetInstance_ID());
        } else {
            this.purcaseOrderLine.setC_Charge_ID(requisitionLine.getC_Charge_ID());
            this.purcaseOrderLine.setPriceActual(requisitionLine.getPriceActual());
        }
        this.purcaseOrderLine.setAD_Org_ID(requisitionLine.getAD_Org_ID());
        this.productId = requisitionLine.getM_Product_ID();
        this.attributeSetInstanceId = requisitionLine.getM_AttributeSetInstance_ID();
        this.purcaseOrderLine.saveEx();
    }

    private boolean isGenerateForVendor(int partnerId) {
        if (this.getBPGroupId() <= 0) {
            return true;
        }
        if (this.m_excludedVendors.contains(partnerId)) {
            return false;
        }
        boolean match = new Query(this.getCtx(), "C_BPartner", "C_BPartner_ID=? AND C_BP_Group_ID=?", this.get_TrxName()).setParameters(partnerId, this.getBPGroupId()).match();
        if (!match) {
            this.m_excludedVendors.add(partnerId);
        }
        return match;
    }
}

