/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.core.domains.models.X_DD_Order;
import org.adempiere.core.domains.models.X_DD_OrderLine;
import org.adempiere.core.domains.models.X_M_Requisition;
import org.adempiere.core.domains.models.X_M_Warehouse;
import org.adempiere.core.domains.models.X_T_Replenish;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ReplenishReportAbstract;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ReplenishInterface;
import org.compiere.util.Util;

public class ReplenishReport
extends ReplenishReportAbstract {
    private String m_info = "";

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_Warehouse_ID=" + this.getWarehouseId() + ", C_BPartner_ID=" + this.getBPartnerId() + " - ReplenishmentCreate=" + this.getReplenishmentCreate() + ", C_DocType_ID=" + this.getDocTypeId());
        if (this.getReplenishmentCreate() != null && this.getDocTypeId() == 0) {
            throw new AdempiereUserError("@FillMandatory@ @C_DocType_ID@");
        }
        if (!this.isSelection()) {
            MWarehouse warehouse = MWarehouse.get(this.getCtx(), this.getWarehouseId());
            if (warehouse.get_ID() == 0) {
                throw new AdempiereSystemError("@FillMandatory@ @M_Warehouse_ID@");
            }
            this.prepareTable();
            this.fillTable(warehouse);
        }
        if (this.getReplenishmentCreate() == null) {
            return "OK";
        }
        MDocType documentType = MDocType.get(this.getCtx(), this.getDocTypeId());
        if (!documentType.getDocBaseType().equals(this.getReplenishmentCreate())) {
            throw new AdempiereSystemError("@C_DocType_ID@=" + documentType.getName() + " <> " + this.getReplenishmentCreate());
        }
        if (this.getReplenishmentCreate().equals("POO")) {
            this.createPO();
        } else if (this.getReplenishmentCreate().equals("POR")) {
            this.createRequisition();
        } else if (this.getReplenishmentCreate().equals("MMM")) {
            this.createMovements();
        } else if (this.getReplenishmentCreate().equals("DOO")) {
            this.createDO();
        }
        return this.m_info;
    }

    private List<X_T_Replenish> getReplenishFromSmartBrowser(boolean isMandatoryBusinessPartner) {
        ArrayList<X_T_Replenish> replenishList = new ArrayList<X_T_Replenish>();
        for (Integer key : this.getSelectionKeys()) {
            BigDecimal qtyToOrdered = this.getSelectionAsBigDecimal(key, "SBR_QtyToOrder");
            int bPartnerId = this.getSelectionAsInt(key, "SBR_C_BPartner_ID");
            if (qtyToOrdered == null || qtyToOrdered.compareTo(Env.ZERO) <= 0 || isMandatoryBusinessPartner && bPartnerId <= 0) continue;
            X_T_Replenish replenish = new X_T_Replenish(this.getCtx(), 0, this.get_TrxName());
            replenish.setAD_PInstance_ID(this.getAD_PInstance_ID());
            replenish.setM_Warehouse_ID(this.getSelectionAsInt(key, "SBR_M_Warehouse_ID"));
            replenish.setM_Product_ID(this.getSelectionAsInt(key, "SBR_M_Product_ID"));
            replenish.setAD_Org_ID(this.getSelectionAsInt(key, "SBR_AD_Org_ID"));
            replenish.setReplenishType(this.getSelectionAsString(key, "SBR_ReplenishType"));
            replenish.setLevel_Min(this.getSelectionAsBigDecimal(key, "SBR_Level_Min"));
            replenish.setLevel_Max(this.getSelectionAsBigDecimal(key, "SBR_Level_max"));
            replenish.setC_BPartner_ID(bPartnerId);
            replenish.setOrder_Min(this.getSelectionAsBigDecimal(key, "SBR_Order_Min"));
            replenish.setOrder_Pack(this.getSelectionAsBigDecimal(key, "SBR_Order_Pack"));
            replenish.setQtyToOrder(qtyToOrdered);
            replenish.setReplenishmentCreate(this.getReplenishmentCreate());
            replenish.setM_WarehouseSource_ID(this.getSelectionAsInt(key, "SBR_M_WarehouseSource_ID"));
            replenish.setC_DocType_ID(this.getDocTypeId());
            replenishList.add(replenish);
        }
        return replenishList;
    }

    private void prepareTable() {
        Object sql = "UPDATE M_Replenish SET Level_Max = Level_Min WHERE Level_Max < Level_Min";
        int no = DB.executeUpdate((String)sql, this.get_TrxName());
        if (no != 0) {
            this.log.fine("Corrected Max_Level=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO SET Order_Min = 1 WHERE Order_Min IS NULL OR Order_Min < 1"), this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Min=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO SET Order_Pack = 1 WHERE Order_Pack IS NULL OR Order_Pack < 1"), this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Pack=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='Y' WHERE IsCurrentVendor<>'Y' AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID GROUP BY pp.M_Product_ID HAVING COUNT(*) = 1)"), this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(Y)=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='N' WHERE IsCurrentVendor = 'Y' AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID AND pp.IsCurrentVendor='Y' GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1)"), this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(N)=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "DELETE T_Replenish WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Delete Existing Temp=" + no);
        }
    }

    private void fillTable(MWarehouse wh) throws Exception {
        String className;
        Object sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID, r.ReplenishType, r.Level_Min, r.Level_Max, po.C_BPartner_ID, po.Order_Min, po.Order_Pack, 0, ";
        sql = this.getReplenishmentCreate() == null ? (String)sql + "null" : (String)sql + "'" + this.getReplenishmentCreate() + "'";
        sql = (String)sql + " FROM M_Replenish r INNER JOIN M_Product_PO po ON (r.M_Product_ID=po.M_Product_ID) WHERE po.IsCurrentVendor='Y' AND r.ReplenishType<>'0' AND po.IsActive='Y' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.getWarehouseId();
        if (this.getBPartnerId() != 0) {
            sql = (String)sql + " AND po.C_BPartner_ID=" + this.getBPartnerId();
        }
        int no = DB.executeUpdate((String)sql, this.get_TrxName());
        this.log.finest((String)sql);
        this.log.fine("Insert (1) #" + no);
        if (this.getBPartnerId() == 0) {
            sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID, r.ReplenishType, r.Level_Min, r.Level_Max, 0, 1, 1, 0, ";
            sql = this.getReplenishmentCreate() == null ? (String)sql + "null" : (String)sql + "'" + this.getReplenishmentCreate() + "'";
            sql = (String)sql + " FROM M_Replenish r WHERE r.ReplenishType<>'0' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.getWarehouseId() + " AND NOT EXISTS (SELECT * FROM T_Replenish t WHERE r.M_Product_ID=t.M_Product_ID AND AD_PInstance_ID=" + this.getAD_PInstance_ID() + ")";
            no = DB.executeUpdate((String)sql, this.get_TrxName());
            this.log.fine("Insert (BP) #" + no);
        }
        sql = "UPDATE T_Replenish t SET QtyOnHand = (SELECT COALESCE(SUM(QtyOnHand),0) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID),QtyReserved = (SELECT COALESCE(SUM(QtyReserved),0) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID),QtyOrdered = (SELECT COALESCE(SUM(QtyOrdered),0) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID)";
        if (this.getDocTypeId() != 0) {
            sql = (String)sql + ", C_DocType_ID=" + this.getDocTypeId();
        }
        if ((no = DB.executeUpdate((String)(sql = (String)sql + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Update #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "DELETE T_Replenish r WHERE (EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_ID=r.M_Product_ID AND p.IsActive='N') OR EXISTS (SELECT * FROM M_Replenish rr  WHERE rr.M_Product_ID=r.M_Product_ID AND rr.IsActive='N' AND rr.M_Warehouse_ID=" + this.getWarehouseId() + " )) AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Delete Inactive=" + no);
        }
        sql = "UPDATE T_Replenish SET QtyOnHand = 0 WHERE QtyOnHand IS NULL";
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyReserved = 0 WHERE QtyReserved IS NULL";
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyOrdered = 0 WHERE QtyOrdered IS NULL";
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyToOrder = CASE WHEN QtyOnHand - QtyReserved + QtyOrdered <= Level_Min  THEN Level_Max - QtyOnHand + QtyReserved - QtyOrdered  ELSE 0 END WHERE ReplenishType='1' AND AD_PInstance_ID=" + this.getAD_PInstance_ID();
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        if (no != 0) {
            this.log.fine("Update Type-1=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET QtyToOrder = Level_Max - QtyOnHand + QtyReserved - QtyOrdered WHERE ReplenishType='2' AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Update Type-2=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET QtyToOrder = Order_Min WHERE QtyToOrder < Order_Min AND QtyToOrder > 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Set MinOrderQty=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET QtyToOrder = QtyToOrder - MOD(QtyToOrder, Order_Pack) + Order_Pack WHERE MOD(QtyToOrder, Order_Pack) <> 0 AND QtyToOrder > 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Set OrderPackQty=" + no);
        }
        if (wh.getM_WarehouseSource_ID() != 0 && (no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID=" + wh.getM_WarehouseSource_ID() + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Set Source Warehouse=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID = NULL WHERE M_Warehouse_ID=M_WarehouseSource_ID AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Set same Source Warehouse=" + no);
        }
        if ((className = wh.getReplenishmentClass()) != null && className.length() > 0) {
            ReplenishInterface custom = null;
            try {
                Class<?> clazz = Class.forName(className);
                custom = (ReplenishInterface)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AdempiereUserError("No custom Replenishment class " + className + " - " + e.toString());
            }
            List<X_T_Replenish> replenishList = this.getReplenish("ReplenishType='9'", false);
            for (X_T_Replenish replenish : replenishList) {
                if (!replenish.getReplenishType().equals("9")) continue;
                BigDecimal qto = null;
                try {
                    qto = custom.getQtyToOrder(wh, replenish);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, custom.toString(), e);
                }
                if (qto == null) {
                    qto = Env.ZERO;
                }
                replenish.setQtyToOrder(qto);
                replenish.saveEx();
            }
        }
        if ((no = DB.executeUpdate((String)(sql = "DELETE T_Replenish WHERE QtyToOrder < 1 AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), this.get_TrxName())) != 0) {
            this.log.fine("Delete No QtyToOrder=" + no);
        }
    }

    private void createPO() {
        int noOrders = 0;
        Object info = "";
        X_C_Order order = null;
        X_M_Warehouse warehouse = null;
        List<X_T_Replenish> replenishList = this.getReplenish("M_WarehouseSource_ID IS NULL", true);
        for (X_T_Replenish replenish : replenishList) {
            if (warehouse == null || warehouse.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                warehouse = MWarehouse.get(this.getCtx(), replenish.getM_Warehouse_ID());
            }
            if (order == null || order.getC_BPartner_ID() != replenish.getC_BPartner_ID() || order.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                order.setIsSOTrx(false);
                order.setC_DocTypeTarget_ID(this.getDocTypeId());
                MBPartner businessPartner = new MBPartner(this.getCtx(), replenish.getC_BPartner_ID(), this.get_TrxName());
                ((MOrder)order).setBPartner(businessPartner);
                order.setSalesRep_ID(this.getAD_User_ID());
                order.setDescription(Msg.getMsg(this.getCtx(), "Replenishment"));
                order.setAD_Org_ID(warehouse.getAD_Org_ID());
                ((MOrder)order).setM_Warehouse_ID(warehouse.getM_Warehouse_ID());
                order.saveEx();
                this.log.fine(((MOrder)order).toString());
                ++noOrders;
                info = (String)info + " - " + order.getDocumentNo();
            }
            MOrderLine line = new MOrderLine((MOrder)order);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.saveEx();
        }
        this.m_info = "#" + noOrders + (String)info;
        this.log.info(this.m_info);
    }

    private void createRequisition() {
        int noReqs = 0;
        Object info = "";
        X_M_Requisition requisition = null;
        X_M_Warehouse warehouse = null;
        List<X_T_Replenish> replenishList = this.getReplenish("M_WarehouseSource_ID IS NULL", false);
        for (X_T_Replenish replenish : replenishList) {
            if (warehouse == null || warehouse.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                warehouse = MWarehouse.get(this.getCtx(), replenish.getM_Warehouse_ID());
            }
            if (requisition == null || requisition.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                requisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                requisition.setAD_User_ID(this.getAD_User_ID());
                requisition.setC_DocType_ID(this.getDocTypeId());
                requisition.setDescription(Msg.getMsg(this.getCtx(), "Replenishment"));
                requisition.setAD_Org_ID(warehouse.getAD_Org_ID());
                requisition.setM_Warehouse_ID(warehouse.getM_Warehouse_ID());
                requisition.saveEx();
                this.log.fine(((MRequisition)requisition).toString());
                ++noReqs;
                info = (String)info + " - " + requisition.getDocumentNo();
            }
            MRequisitionLine line = new MRequisitionLine((MRequisition)requisition);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setC_BPartner_ID(replenish.getC_BPartner_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.saveEx();
        }
        this.m_info = "#" + noReqs + (String)info;
        this.log.info(this.m_info);
    }

    private void createMovements() {
        int noMoves = 0;
        Object info = "";
        PO client = null;
        MMovement move = null;
        int M_Warehouse_ID = 0;
        int M_WarehouseSource_ID = 0;
        X_M_Warehouse whSource = null;
        X_M_Warehouse wh = null;
        List<X_T_Replenish> replenishList = this.getReplenish("M_WarehouseSource_ID IS NOT NULL", false);
        block0: for (X_T_Replenish replenish : replenishList) {
            if (whSource == null || whSource.getM_WarehouseSource_ID() != replenish.getM_WarehouseSource_ID()) {
                whSource = MWarehouse.get(this.getCtx(), replenish.getM_WarehouseSource_ID());
            }
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get(this.getCtx(), replenish.getM_Warehouse_ID());
            }
            if (client == null || client.getAD_Client_ID() != whSource.getAD_Client_ID()) {
                client = MClient.get(this.getCtx(), whSource.getAD_Client_ID());
            }
            if (move == null || M_WarehouseSource_ID != replenish.getM_WarehouseSource_ID() || M_Warehouse_ID != replenish.getM_Warehouse_ID()) {
                M_WarehouseSource_ID = replenish.getM_WarehouseSource_ID();
                M_Warehouse_ID = replenish.getM_Warehouse_ID();
                move = new MMovement(this.getCtx(), 0, this.get_TrxName());
                move.setC_DocType_ID(this.getDocTypeId());
                move.setDescription(Msg.getMsg(this.getCtx(), "Replenishment") + ": " + whSource.getName() + "->" + wh.getName());
                move.setAD_Org_ID(whSource.getAD_Org_ID());
                move.saveEx();
                this.log.fine(move.toString());
                ++noMoves;
                info = (String)info + " - " + move.getDocumentNo();
            }
            int M_LocatorTo_ID = ((MWarehouse)wh).getDefaultLocator().getM_Locator_ID();
            MProduct product = MProduct.get(this.getCtx(), replenish.getM_Product_ID());
            String MMPolicy = product.getMMPolicy();
            MStorage[] storages = MStorage.getWarehouse(this.getCtx(), whSource.getM_Warehouse_ID(), replenish.getM_Product_ID(), 0, null, "F".equals(MMPolicy), false, 0, this.get_TrxName());
            BigDecimal target = replenish.getQtyToOrder();
            for (int j = 0; j < storages.length; ++j) {
                MStorage storage = storages[j];
                if (storage.getQtyOnHand().signum() <= 0) continue;
                BigDecimal moveQty = target;
                if (storage.getQtyOnHand().compareTo(moveQty) < 0) {
                    moveQty = storage.getQtyOnHand();
                }
                MMovementLine line = new MMovementLine(move);
                line.setM_Product_ID(replenish.getM_Product_ID());
                line.setMovementQty(moveQty);
                if (replenish.getQtyToOrder().compareTo(moveQty) != 0) {
                    line.setDescription("Total: " + replenish.getQtyToOrder());
                }
                line.setM_Locator_ID(storage.getM_Locator_ID());
                line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                line.setM_LocatorTo_ID(M_LocatorTo_ID);
                line.setM_AttributeSetInstanceTo_ID(storage.getM_AttributeSetInstance_ID());
                line.saveEx();
                target = target.subtract(moveQty);
                if (target.signum() == 0) continue block0;
            }
        }
        if (replenishList.size() == 0) {
            this.m_info = "@M_WarehouseSource_ID@ @NotFound@";
            this.log.warning(this.m_info);
        } else {
            this.m_info = "#" + noMoves + (String)info;
            this.log.info(this.m_info);
        }
    }

    private void createDO() throws Exception {
        int noMoves = 0;
        Object info = "";
        PO client = null;
        X_DD_Order order = null;
        int M_Warehouse_ID = 0;
        int M_WarehouseSource_ID = 0;
        X_M_Warehouse whSource = null;
        X_M_Warehouse wh = null;
        List<X_T_Replenish> replenishList = this.getReplenish("M_WarehouseSource_ID IS NOT NULL", false);
        for (X_T_Replenish replenish : replenishList) {
            if (whSource == null || whSource.getM_WarehouseSource_ID() != replenish.getM_WarehouseSource_ID()) {
                whSource = MWarehouse.get(this.getCtx(), replenish.getM_WarehouseSource_ID());
            }
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get(this.getCtx(), replenish.getM_Warehouse_ID());
            }
            if (client == null || client.getAD_Client_ID() != whSource.getAD_Client_ID()) {
                client = MClient.get(this.getCtx(), whSource.getAD_Client_ID());
            }
            if (order == null || M_WarehouseSource_ID != replenish.getM_WarehouseSource_ID() || M_Warehouse_ID != replenish.getM_Warehouse_ID()) {
                MWarehouse[] whsInTransit;
                M_WarehouseSource_ID = replenish.getM_WarehouseSource_ID();
                M_Warehouse_ID = replenish.getM_Warehouse_ID();
                order = new X_DD_Order(this.getCtx(), 0, this.get_TrxName());
                order.setC_DocType_ID(this.getDocTypeId());
                order.setDescription(Msg.getMsg(this.getCtx(), "Replenishment") + ": " + whSource.getName() + "->" + wh.getName());
                order.setAD_Org_ID(whSource.getAD_Org_ID());
                MOrg orgTrx = MOrg.get(this.getCtx(), wh.getAD_Org_ID());
                order.setAD_OrgTrx_ID(orgTrx.getAD_Org_ID());
                int bPartnerId = orgTrx.getLinkedC_BPartner_ID(this.get_TrxName());
                if (bPartnerId == 0) {
                    throw new AdempiereUserError("@C_BPartner_ID@ @AD_Org_ID@ @FillMandatory@ ");
                }
                MBPartner bp = new MBPartner(this.getCtx(), bPartnerId, this.get_TrxName());
                this.setBusinessPartner(order, bp);
                order.setDateOrdered(new Timestamp(System.currentTimeMillis()));
                order.setDeliveryRule("A");
                order.setDeliveryViaRule("D");
                order.setPriorityRule("5");
                order.setIsInDispute(false);
                order.setIsApproved(false);
                order.setIsDropShip(false);
                order.setIsDelivered(false);
                order.setIsInTransit(false);
                order.setIsPrinted(false);
                order.setIsSelected(false);
                order.setIsSOTrx(false);
                for (MWarehouse whInTransit : whsInTransit = MWarehouse.getForOrg(this.getCtx(), whSource.getAD_Org_ID())) {
                    if (!whInTransit.isInTransit()) continue;
                    order.setM_Warehouse_ID(whInTransit.getM_Warehouse_ID());
                }
                if (order.get_ValueAsInt("M_Warehouse_ID") == 0) {
                    throw new AdempiereUserError("@M_Warehouse_ID@ @InTransit@ @FillMandatory@ ");
                }
                order.saveEx();
                this.log.fine(order.toString());
                ++noMoves;
                info = (String)info + " - " + order.get_ValueAsString("DocumentNo");
            }
            int M_LocatorTo_ID = ((MWarehouse)wh).getDefaultLocator().getM_Locator_ID();
            int M_Locator_ID = ((MWarehouse)whSource).getDefaultLocator().getM_Locator_ID();
            if (M_LocatorTo_ID == 0 || M_Locator_ID == 0) {
                throw new AdempiereUserError(Msg.translate(this.getCtx(), "M_Locator_ID") + " @FillMandatory@ ");
            }
            X_DD_OrderLine line = this.getDistributionOrderLineInstanceFromParent(order);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setQtyEntered(replenish.getQtyToOrder());
            line.setQtyOrdered(replenish.getQtyToOrder());
            if (replenish.getQtyToOrder().compareTo(replenish.getQtyToOrder()) != 0) {
                line.setDescription("Total: " + replenish.getQtyToOrder());
            }
            line.setM_Locator_ID(M_Locator_ID);
            line.setM_AttributeSetInstance_ID(0);
            line.setM_LocatorTo_ID(M_LocatorTo_ID);
            line.setM_AttributeSetInstanceTo_ID(0);
            line.setIsInvoiced(false);
            line.saveEx();
        }
        if (replenishList.size() == 0) {
            this.m_info = "No Source Warehouse";
            this.log.warning(this.m_info);
        } else {
            this.m_info = "#" + noMoves + (String)info;
            this.log.info(this.m_info);
        }
    }

    private void setBusinessPartner(X_DD_Order referenceToSet, MBPartner bp) {
        if (bp == null) {
            return;
        }
        referenceToSet.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = referenceToSet.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        ii = referenceToSet.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID();
        String ss = bp.getDeliveryRule();
        if (ss != null) {
            referenceToSet.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            referenceToSet.setDeliveryViaRule(ss);
        }
        ss = bp.getInvoiceRule();
        if (referenceToSet.getSalesRep_ID() == 0 && (ii = Env.getAD_User_ID(referenceToSet.getCtx())) != 0) {
            referenceToSet.setSalesRep_ID(ii);
        }
        List<MBPartnerLocation> partnerLocations = Arrays.asList(bp.getLocations(false));
        MBPartnerLocation partnerLocation = partnerLocations.stream().filter(pl -> pl.isShipTo()).reduce((first, last) -> last).orElseGet(() -> (MBPartnerLocation)partnerLocations.stream().findFirst().orElseThrow(() -> new AdempiereException("@IsShipTo@ @NotFound@")));
        referenceToSet.setC_BPartner_Location_ID(partnerLocation.getC_BPartner_Location_ID());
        Arrays.asList(bp.getContacts(false)).stream().findFirst().ifPresent(user -> referenceToSet.setAD_User_ID(user.getAD_User_ID()));
    }

    private X_DD_OrderLine getDistributionOrderLineInstanceFromParent(X_DD_Order distributionOrder) {
        X_DD_OrderLine distributionOrderLine = new X_DD_OrderLine(distributionOrder.getCtx(), 0, distributionOrder.get_TrxName());
        distributionOrderLine.setDD_Order_ID(distributionOrder.get_ID());
        distributionOrderLine.setAD_Org_ID(distributionOrder.getAD_Org_ID());
        distributionOrderLine.setDateOrdered(distributionOrder.getDateOrdered());
        distributionOrderLine.setDatePromised(distributionOrder.getDatePromised());
        return distributionOrderLine;
    }

    private List<X_T_Replenish> getReplenish(String where, boolean isMandatoryBusinessPartner) {
        if (this.isSelection()) {
            return this.getReplenishFromSmartBrowser(isMandatoryBusinessPartner);
        }
        StringBuffer localWhere = new StringBuffer("AD_PInstance_ID=?");
        if (!isMandatoryBusinessPartner) {
            localWhere.append(" AND ").append(" C_BPartner_ID > 0");
        }
        if (!Util.isEmpty(where)) {
            localWhere.append(" AND ").append(where);
        }
        List<X_T_Replenish> list = new Query(this.getCtx(), "T_Replenish", localWhere.toString(), this.get_TrxName()).setParameters(this.getAD_PInstance_ID()).setOrderBy("M_Warehouse_ID, M_WarehouseSource_ID, C_BPartner_ID").list();
        return list;
    }
}

