/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.List;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.PO;
import org.compiere.process.ProjectGenerateRFQAbstract;

public class ProjectGenerateRFQ
extends ProjectGenerateRFQAbstract {
    private MRfQ m_RFQ = null;
    private int lines = 0;
    private MProject m_MProject = null;
    private MProjectPhase m_MProjectPhase = null;
    private MProjectTask m_MProjectTask = null;
    private MProjectLine m_MProjectLine = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTable_ID() == MProject.Table_ID) {
            this.m_MProject = new MProject(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        } else if (this.getTable_ID() == MProjectPhase.Table_ID) {
            this.m_MProjectPhase = new MProjectPhase(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.m_MProject = new MProject(this.getCtx(), this.m_MProjectPhase.getC_Project_ID(), this.get_TrxName());
        } else if (this.getTable_ID() == MProjectTask.Table_ID) {
            this.m_MProjectTask = new MProjectTask(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.m_MProjectPhase = new MProjectPhase(this.getCtx(), this.m_MProjectTask.getC_ProjectPhase_ID(), this.get_TrxName());
            this.m_MProject = new MProject(this.getCtx(), this.m_MProjectPhase.getC_Project_ID(), this.get_TrxName());
        } else if (this.getTable_ID() == MProjectLine.Table_ID) {
            this.m_MProjectLine = new MProjectLine(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            if (this.m_MProjectLine.getC_ProjectTask_ID() != 0) {
                this.m_MProjectTask = new MProjectTask(this.getCtx(), this.m_MProjectLine.getC_ProjectTask_ID(), this.get_TrxName());
            }
            if (this.m_MProjectLine.getC_ProjectPhase_ID() != 0) {
                this.m_MProjectPhase = new MProjectPhase(this.getCtx(), this.m_MProjectLine.getC_ProjectPhase_ID(), this.get_TrxName());
            }
            if (this.m_MProjectLine.getC_Project_ID() != 0) {
                this.m_MProject = new MProject(this.getCtx(), this.m_MProjectLine.getC_Project_ID(), this.get_TrxName());
            }
        }
    }

    @Override
    protected String doIt() throws Exception {
        Object retValue = "";
        retValue = this.createRFQHeader();
        if (((String)retValue).equals("")) {
            if (this.m_MProjectLine != null) {
                retValue = this.processProjectLines(this.m_MProjectLine);
            } else if (this.m_MProjectTask != null) {
                retValue = this.processProjectTask(this.m_MProjectTask);
            } else if (this.m_MProjectPhase != null) {
                retValue = this.processProjectPhase(this.m_MProjectPhase);
            } else if (this.m_MProject != null) {
                retValue = this.processProject(this.m_MProject);
            }
            if (this.lines == 0) {
                this.rollback();
            } else {
                retValue = "@Generated@ @C_RfQ_ID@ " + this.m_RFQ.getDocumentNo();
            }
        }
        return retValue;
    }

    private String processProject(MProject project) {
        Object retValue;
        block4: {
            block3: {
                retValue = "";
                if (!project.getProjectLineLevel().equals("P")) break block3;
                List<MProjectLine> pLines = project.getLines();
                if (pLines.size() <= 0) break block4;
                for (MProjectLine mProjectLine : pLines) {
                    retValue = (String)retValue + this.processProjectLines(mProjectLine);
                }
                break block4;
            }
            List<MProjectPhase> lPhases = project.getPhases();
            if (lPhases.size() > 0) {
                for (MProjectPhase mProjectPhase : lPhases) {
                    retValue = (String)retValue + this.processProjectPhase(mProjectPhase);
                }
            }
        }
        return retValue;
    }

    private String processProjectPhase(MProjectPhase mProjectPhase) {
        Object retValue;
        block4: {
            MProject project;
            block5: {
                retValue = "";
                this.m_RFQ.set_ValueOfColumn("C_ProjectPhase_ID", (Object)mProjectPhase.get_ID());
                if (mProjectPhase.getC_ProjectPhase_ID() == 0) break block4;
                project = (MProject)mProjectPhase.getC_Project();
                if (!project.getProjectLineLevel().equals("A")) break block5;
                List<MProjectLine> pLines = mProjectPhase.getLines();
                if (pLines.size() > 0 && mProjectPhase.getM_Product_ID() == 0) {
                    for (MProjectLine mProjectLine : pLines) {
                        retValue = (String)retValue + this.processProjectLines(mProjectLine);
                    }
                } else {
                    MProduct product = (MProduct)mProjectPhase.getM_Product();
                    retValue = this.createRFQLine(product, mProjectPhase.getQty(), mProjectPhase);
                }
                break block4;
            }
            if (!project.getProjectLineLevel().equals("T")) break block4;
            List<MProjectTask> pTasks = mProjectPhase.getTasks();
            for (MProjectTask mProjectTask : pTasks) {
                retValue = (String)retValue + this.processProjectTask(mProjectTask);
            }
        }
        return retValue;
    }

    private String processProjectTask(MProjectTask pTask) {
        Object retValue = "";
        this.m_RFQ.set_ValueOfColumn("C_ProjectTask_ID", (Object)pTask.get_ID());
        if (pTask.getDateDeadline() == null) {
            return "@NotFound@ @DateDeadLine@";
        }
        this.m_RFQ.setDateResponse(pTask.getDateDeadline());
        this.m_RFQ.setDateWorkStart(pTask.getDateStartSchedule());
        this.m_RFQ.setDateWorkComplete(pTask.getDateFinishSchedule());
        this.m_RFQ.setName(pTask.getName());
        this.m_RFQ.setHelp(pTask.getDescription());
        this.m_RFQ.saveEx();
        if (pTask.getC_ProjectTask_ID() != 0) {
            MProjectLine[] pLines = pTask.getLines();
            if (pLines.length > 0 && pTask.getM_Product_ID() == 0) {
                for (MProjectLine mProjectLine : pLines) {
                    retValue = (String)retValue + this.processProjectLines(mProjectLine);
                }
            } else if (pTask.getM_Product_ID() > 0) {
                MProduct product = (MProduct)pTask.getM_Product();
                retValue = this.createRFQLine(product, pTask.getQty(), pTask);
            } else {
                return "@NotFound@ @M_Product_ID@";
            }
        }
        return retValue;
    }

    private String processProjectLines(MProjectLine projectLine) {
        this.log.info("doIt - " + projectLine);
        if (projectLine.getM_Product_ID() == 0) {
            return "@NotFound@ @M_Product_ID@";
        }
        MProduct product = (MProduct)projectLine.getM_Product();
        return this.createRFQLine(product, projectLine.getPlannedQty(), projectLine);
    }

    private String createRFQHeader() {
        if (this.getRfQTopicId() == 0) {
            return "@Invalid@ @C_RfQ_Topic_ID@";
        }
        if (this.m_MProject.getDateStart() == null) {
            return "@Invalid@ @DateStart@";
        }
        this.m_RFQ = new MRfQ(this.getCtx(), 0, this.get_TrxName());
        this.m_RFQ.setName(this.m_MProject.getName());
        this.m_RFQ.setSalesRep_ID(this.m_MProject.getSalesRep_ID());
        this.m_RFQ.setC_Currency_ID(this.m_MProject.getC_Currency_ID());
        this.m_RFQ.setC_RfQ_Topic_ID(this.getRfQTopicId());
        this.m_RFQ.setQuoteType(this.getQuoteType());
        this.m_RFQ.setDateResponse(this.m_MProject.getDateStart());
        this.m_RFQ.setDateWorkStart(this.m_MProject.getDateStart());
        this.m_RFQ.setIsQuoteAllQty(this.isQuoteAllQty());
        this.m_RFQ.setIsInvitedVendorsOnly(this.isInvitedVendorsOnly());
        this.m_RFQ.setIsRfQResponseAccepted(this.isRfQResponseAccepted());
        this.m_RFQ.setIsInvitedVendorsOnly(this.isInvitedVendorsOnly());
        this.m_RFQ.setIsRfQResponseAccepted(this.isRfQResponseAccepted());
        this.m_RFQ.setIsSelfService(this.isSelfService());
        this.m_RFQ.setC_BPartner_ID(this.m_MProject.getC_BPartner_ID());
        this.m_RFQ.setC_BPartner_Location_ID(this.m_MProject.getC_BPartner_Location_ID());
        this.m_RFQ.setAD_User_ID(this.m_MProject.getAD_User_ID());
        this.m_RFQ.setAD_Org_ID(this.m_MProject.getAD_Org_ID());
        this.m_RFQ.set_ValueOfColumn("C_Project_ID", (Object)this.m_MProject.getC_Project_ID());
        this.m_RFQ.set_ValueOfColumn("C_Campaign_ID", (Object)this.m_MProject.getC_Campaign_ID());
        this.m_RFQ.set_ValueOfColumn("User1_ID", (Object)this.m_MProject.getUser1_ID());
        this.m_RFQ.saveEx();
        return "";
    }

    private String createRFQLine(MProduct product, BigDecimal Qty, PO entity) {
        if (this.m_RFQ == null || this.m_RFQ.getC_RfQ_ID() == 0) {
            return "@Invalid@ @C_RfQ_ID@";
        }
        MRfQLine line = new MRfQLine(this.m_RFQ);
        int projectPhaseId = 0;
        int projectTaskId = 0;
        if (entity instanceof MProjectLine) {
            line.setDescription(((MProjectLine)entity).getDescription());
            projectTaskId = entity.get_ValueAsInt("C_ProjectTask_ID");
            projectPhaseId = entity.get_ValueAsInt("C_ProjectPhase_ID");
        }
        line.setM_Product_ID(product.getM_Product_ID());
        if (entity instanceof MProjectTask) {
            projectTaskId = entity.get_ValueAsInt("C_ProjectTask_ID");
            projectPhaseId = entity.get_ValueAsInt("C_ProjectPhase_ID");
        } else if (entity instanceof MProjectPhase) {
            projectPhaseId = entity.get_ValueAsInt("C_ProjectPhase_ID");
        }
        if (projectPhaseId > 0) {
            line.set_ValueOfColumn("C_ProjectPhase_ID", (Object)projectPhaseId);
        }
        if (projectTaskId > 0) {
            line.set_ValueOfColumn("C_ProjectTask_ID", (Object)projectTaskId);
        }
        line.set_ValueOfColumn("C_Project_ID", entity.get_Value("C_Project_ID"));
        line.saveEx();
        MRfQLineQty lineQty = new MRfQLineQty(line);
        lineQty.setC_UOM_ID(product.getC_UOM_ID());
        lineQty.setQty(Qty);
        lineQty.setIsRfQQty(true);
        lineQty.saveEx();
        ++this.lines;
        return "";
    }
}

