/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MRequest;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class ProcessingRequestSelection
extends SvrProcess {
    private int typeID = 0;
    private int categoryID = 0;
    private int groupID = 0;
    private int statusID = 0;
    private String priority = "";
    private Timestamp dateNextAction = null;
    private int salesRepID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("R_RequestType_ID")) {
                    this.typeID = para[i].getParameterAsInt();
                    continue;
                }
                if (name.equals("R_Category_ID")) {
                    this.categoryID = para[i].getParameterAsInt();
                    continue;
                }
                if (name.equals("R_Group_ID")) {
                    this.groupID = para[i].getParameterAsInt();
                    continue;
                }
                if (name.equals("R_Status_ID")) {
                    this.statusID = para[i].getParameterAsInt();
                    continue;
                }
                if (name.equals("Priority")) {
                    this.priority = para[i].getParameterAsString();
                    continue;
                }
                if (name.equals("DateNextAction")) {
                    this.dateNextAction = para[i].getParameterAsTimestamp();
                    continue;
                }
                if (name.equals("SalesRep_ID")) {
                    this.salesRepID = para[i].getParameterAsInt();
                    continue;
                }
                this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            MRequest req = new MRequest(this.getCtx(), (int)key, this.get_TrxName());
            if (req != null && req.get_ID() > 0) {
                if (this.typeID > 0) {
                    req.setR_RequestType_ID(this.typeID);
                }
                if (this.categoryID > 0) {
                    req.setR_Category_ID(this.categoryID);
                }
                if (this.groupID > 0) {
                    req.setR_Group_ID(this.groupID);
                }
                if (this.statusID > 0) {
                    req.setR_Status_ID(this.statusID);
                }
                if (this.priority != null && !this.priority.equalsIgnoreCase("")) {
                    req.setPriority(this.priority);
                }
                if (this.dateNextAction != null) {
                    req.setDateNextAction(this.dateNextAction);
                }
                if (this.salesRepID > 0) {
                    req.setSalesRep_ID(this.salesRepID);
                }
                req.saveEx();
            }
        });
        return "OK";
    }
}

