/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_HR_Movement;
import org.adempiere.core.domains.models.X_HR_Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.PSCreateFromHRMovementAbstract;

public class PSCreateFromHRMovement
extends PSCreateFromHRMovementAbstract {
    private AtomicInteger sequence = new AtomicInteger(10);
    private Map<Integer, X_HR_Process> payrollProcessMap = new HashMap<Integer, X_HR_Process>();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@C_PaySelection_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        MPaySelection paySelection = new MPaySelection(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.sequence.set(paySelection.getLastLineNo());
        this.getSelectionKeys().forEach(key -> {
            int movementId = key;
            String paymentRule = this.getSelectionAsString((int)key, "HRM_PaymentRule");
            BigDecimal sourceAmount = this.getSelectionAsBigDecimal((int)key, "HRM_Amount");
            BigDecimal convertedAmount = this.getSelectionAsBigDecimal((int)key, "HRM_ConvertedAmount");
            MPaySelectionLine line = new MPaySelectionLine(paySelection, this.sequence.getAndAdd(10), paymentRule);
            X_HR_Movement payrollMovement = new X_HR_Movement(this.getCtx(), movementId, this.get_TrxName());
            Optional<X_HR_Process> mybePayrollProcess = Optional.ofNullable(this.payrollProcessMap.get(payrollMovement.getHR_Process_ID()));
            X_HR_Process payrollProcess = mybePayrollProcess.orElseGet(() -> {
                X_HR_Process processFromMovement = new X_HR_Process(this.getCtx(), payrollMovement.getHR_Process_ID(), this.get_TrxName());
                this.payrollProcessMap.put(payrollMovement.getHR_Process_ID(), processFromMovement);
                return processFromMovement;
            });
            line.setHRMovement(payrollMovement, payrollProcess.getC_ConversionType_ID(), sourceAmount, convertedAmount);
            line.saveEx();
        });
        return "@OK@";
    }
}

