/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.process.OrderPOCreateAbstract;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class OrderPOCreate
extends OrderPOCreateAbstract {
    private int counter = 0;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTable_ID() == MOrder.Table_ID && this.getRecord_ID() > 0) {
            this.setOrderId(this.getRecord_ID());
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("DateOrdered=" + this.getDateOrdered() + " - " + this.getDateOrderedTo() + " - C_BPartner_ID=" + this.getBPartnerId() + " - Vendor_ID=" + this.getVendorId() + " - IsDropShip=" + this.getIsDropShip() + " - C_Order_ID=" + this.getOrderId());
        if (this.getOrderId() == 0 && this.getDateOrdered() == null && this.getDateOrderedTo() == null && this.getBPartnerId() == 0 && this.getVendorId() == 0) {
            throw new AdempiereUserError("@FillMandatory@ @AD_Process_Para_ID@");
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("IsSOTrx = 'Y' AND DocStatus IN('IP', 'CO')");
        whereClause.append(" AND NOT EXISTS (SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID=C_Order.C_Order_ID AND ol.Link_OrderLine_ID IS NOT NULL)");
        if (this.getOrderId() != 0) {
            whereClause.append(" AND C_Order.C_Order_ID=?");
            parameters.add(this.getOrderId());
        } else {
            if (this.getBPartnerId() != 0) {
                whereClause.append(" AND C_Order.C_BPartner_ID=?");
                parameters.add(this.getBPartnerId());
            }
            if (this.getVendorId() != 0) {
                whereClause.append(" AND EXISTS (SELECT 1 FROM C_OrderLine ol INNER JOIN M_Product_PO po ON (ol.M_Product_ID = po.M_Product_ID) WHERE C_Order.C_Order_ID = ol.C_Order_ID AND po.C_BPartner_ID=?)");
                parameters.add(this.getVendorId());
            }
            if (this.getDateOrdered() != null && this.getDateOrderedTo() != null) {
                whereClause.append(" AND TRUNC(C_Order.DateOrdered, 'DD') BETWEEN ? AND ?");
                parameters.add(this.getDateOrdered());
                parameters.add(this.getDateOrderedTo());
            } else if (this.getDateOrdered() != null && this.getDateOrderedTo() == null) {
                whereClause.append(" AND TRUNC(C_Order.DateOrdered, 'DD') >= ?");
                parameters.add(this.getDateOrdered());
            } else if (this.getDateOrdered() == null && this.getDateOrderedTo() != null) {
                whereClause.append(" AND TRUNC(C_Order.DateOrdered, 'DD') <= ?");
                parameters.add(this.getDateOrderedTo());
            }
        }
        new Query(this.getCtx(), "C_Order", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).list().stream().forEach(order -> this.counter += this.createPOFromSO((MOrder)order));
        return "@Created@ " + this.counter;
    }

    private int createPOFromSO(MOrder salesOrder) {
        this.log.info(salesOrder.toString());
        MOrderLine[] salesOrderLines = salesOrder.getLines(true, null);
        if (salesOrderLines == null || salesOrderLines.length == 0) {
            this.log.warning("No Lines - " + salesOrder);
            return 0;
        }
        MOrder purchaseOrder = salesOrder.getDropShip_BPartner_ID() > 0 ? this.createFromSOInfo(salesOrder, salesOrderLines) : this.createFromProductPOInfo(salesOrder, salesOrderLines);
        String documentAction = this.getParameterAsString("DocAction");
        if (!Util.isEmpty(documentAction) && (documentAction.equals("CO") || documentAction.equals("PR"))) {
            purchaseOrder.processIt(documentAction);
            purchaseOrder.saveEx();
        }
        if (this.counter == 1 && purchaseOrder != null) {
            salesOrder.setLink_Order_ID(purchaseOrder.getC_Order_ID());
            salesOrder.saveEx();
        }
        return this.counter;
    }

    private MOrder createFromSOInfo(MOrder salesOrder, MOrderLine[] salesOrderLines) {
        MOrder purchaseOrder = this.createPOForVendor(salesOrder.getDropShip_BPartner_ID(), salesOrder);
        this.addLog(0, null, null, purchaseOrder.getDocumentNo());
        ++this.counter;
        this.createLines(purchaseOrder, salesOrderLines, -1);
        return purchaseOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MOrder createFromProductPOInfo(MOrder salesOrder, MOrderLine[] salesOrderLines) {
        String sql = "SELECT MIN(po.C_BPartner_ID), po.M_Product_ID FROM M_Product_PO po INNER JOIN C_OrderLine ol ON (po.M_Product_ID=ol.M_Product_ID) WHERE ol.C_Order_ID=? AND po.IsCurrentVendor='Y' " + (this.getVendorId() > 0 ? " AND po.C_BPartner_ID=? " : "") + "GROUP BY po.M_Product_ID ORDER BY 1";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        X_C_Order purchaseOrder = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, salesOrder.getC_Order_ID());
            if (this.getVendorId() != 0) {
                pstmt.setInt(2, this.getVendorId());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int bPartnerId = rs.getInt(1);
                if (purchaseOrder == null || purchaseOrder.getBill_BPartner_ID() != bPartnerId) {
                    purchaseOrder = this.createPOForVendor(rs.getInt(1), salesOrder);
                    this.addLog(0, null, null, purchaseOrder.getDocumentNo());
                    ++this.counter;
                }
                int productId = rs.getInt(2);
                this.createLines((MOrder)purchaseOrder, salesOrderLines, productId);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return purchaseOrder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MOrder createPOForVendor(int bPartnerId, MOrder salesOrder) {
        MOrder purchaseOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
        purchaseOrder.setClientOrg(salesOrder.getAD_Client_ID(), salesOrder.getAD_Org_ID());
        purchaseOrder.setIsSOTrx(false);
        int documentTypeTargetId = this.getParameterAsInt("C_DocTypeDropShip_ID");
        if (documentTypeTargetId > 0) {
            purchaseOrder.setC_DocTypeTarget_ID(documentTypeTargetId);
        } else {
            purchaseOrder.setC_DocTypeTarget_ID();
        }
        purchaseOrder.setDescription(salesOrder.getDescription());
        purchaseOrder.setPOReference(salesOrder.getDocumentNo());
        purchaseOrder.setPriorityRule(salesOrder.getPriorityRule());
        purchaseOrder.setSalesRep_ID(salesOrder.getSalesRep_ID());
        purchaseOrder.setM_Warehouse_ID(salesOrder.getM_Warehouse_ID());
        MBPartner vendor = new MBPartner(this.getCtx(), bPartnerId, this.get_TrxName());
        purchaseOrder.setBPartner(vendor);
        if (!Util.isEmpty(this.getIsDropShip())) {
            purchaseOrder.setIsDropShip(this.getIsDropShip().equals("Y"));
            if (salesOrder.isDropShip() && salesOrder.getDropShip_BPartner_ID() != 0) {
                purchaseOrder.setDropShip_BPartner_ID(salesOrder.getDropShip_BPartner_ID());
                purchaseOrder.setDropShip_Location_ID(salesOrder.getDropShip_Location_ID());
                purchaseOrder.setDropShip_User_ID(salesOrder.getDropShip_User_ID());
            } else {
                purchaseOrder.setDropShip_BPartner_ID(salesOrder.getC_BPartner_ID());
                purchaseOrder.setDropShip_Location_ID(salesOrder.getC_BPartner_Location_ID());
                purchaseOrder.setDropShip_User_ID(salesOrder.getAD_User_ID());
            }
            MOrgInfo orginfo = MOrgInfo.get(this.getCtx(), purchaseOrder.getAD_Org_ID(), this.get_TrxName());
            if (orginfo.getDropShip_Warehouse_ID() != 0) {
                purchaseOrder.setM_Warehouse_ID(orginfo.getDropShip_Warehouse_ID());
            } else {
                this.log.log(Level.SEVERE, "Must specify drop ship warehouse in org info.");
            }
        }
        purchaseOrder.setC_Activity_ID(salesOrder.getC_Activity_ID());
        purchaseOrder.setC_Campaign_ID(salesOrder.getC_Campaign_ID());
        purchaseOrder.setC_Project_ID(salesOrder.getC_Project_ID());
        purchaseOrder.setOrderType(salesOrder.getOrderType());
        purchaseOrder.set_ValueOfColumn("Help", salesOrder.get_Value("Help"));
        if (salesOrder.get_ValueAsInt("C_ProjectPhase_ID") > 0) {
            purchaseOrder.set_ValueOfColumn("C_ProjectPhase_ID", (Object)salesOrder.get_ValueAsInt("C_ProjectPhase_ID"));
        }
        if (salesOrder.get_ValueAsInt("C_ProjectTask_ID") > 0) {
            purchaseOrder.set_ValueOfColumn("C_ProjectTask_ID", (Object)salesOrder.get_ValueAsInt("C_ProjectTask_ID"));
        }
        purchaseOrder.setUser1_ID(salesOrder.getUser1_ID());
        purchaseOrder.setUser2_ID(salesOrder.getUser2_ID());
        purchaseOrder.setUser3_ID(salesOrder.getUser3_ID());
        purchaseOrder.setUser4_ID(salesOrder.getUser4_ID());
        purchaseOrder.setDocAction("CO");
        MPriceList poList = null;
        MCurrency cur = (MCurrency)salesOrder.getC_Currency();
        MBPartner partner = (MBPartner)purchaseOrder.getC_BPartner();
        if (partner.get_ValueAsInt("PO_PriceList_ID") > 0) {
            poList = new MPriceList(this.getCtx(), partner.get_ValueAsInt("PO_PriceList_ID"), this.get_TrxName());
            if (poList.getC_Currency_ID() == cur.get_ID()) {
                purchaseOrder.setM_PriceList_ID(poList.get_ID());
            } else {
                poList = MPriceList.getDefault(this.getCtx(), false, cur.getISO_Code());
                if (poList == null || poList.get_ID() <= 0) throw new AdempiereException("No se obtuvo lista de precios de compra predeterminada en " + cur.getISO_Code());
                purchaseOrder.setM_PriceList_ID(poList.get_ID());
            }
        } else {
            poList = MPriceList.getDefault(this.getCtx(), false, cur.getISO_Code());
            if (poList == null || poList.get_ID() <= 0) throw new AdempiereException("No se obtuvo lista de precios de compra predeterminada en " + cur.getISO_Code());
            purchaseOrder.setM_PriceList_ID(poList.get_ID());
        }
        purchaseOrder.saveEx();
        return purchaseOrder;
    }

    private void createLines(MOrder purchaseOrder, MOrderLine[] salesOrderLines, int productId) {
        MBPartner partner = (MBPartner)purchaseOrder.getC_BPartner();
        MTax taxPO = null;
        if (partner.isPOTaxExempt() && (taxPO = MTax.getForTaxIndicator(this.getCtx(), "1", this.get_TrxName())) == null) {
            throw new AdempiereException("ERROR: No se obtuvo impuesto EXENTO");
        }
        for (MOrderLine line : salesOrderLines) {
            if (line.getM_Product_ID() != productId && productId >= 0) continue;
            MOrderLine poLine = new MOrderLine(purchaseOrder);
            poLine.setM_Product_ID(line.getM_Product_ID());
            poLine.setC_Charge_ID(line.getC_Charge_ID());
            poLine.setM_AttributeSetInstance_ID(line.getM_AttributeSetInstance_ID());
            poLine.setC_UOM_ID(line.getC_UOM_ID());
            poLine.setQtyEntered(line.getQtyEntered());
            poLine.setQtyOrdered(line.getQtyOrdered());
            poLine.setDescription(line.getDescription());
            poLine.setDatePromised(line.getDatePromised());
            poLine.set_ValueOfColumn("IsBonusProduct", line.get_Value("IsBonusProduct"));
            poLine.set_ValueOfColumn("EndDate", line.get_Value("EndDate"));
            poLine.set_ValueOfColumn("Reference", line.get_Value("Reference"));
            poLine.setPrice();
            poLine.setPriceList(line.getPriceList());
            poLine.set_ValueOfColumn("DescriptionURL", line.get_Value("DescriptionURL"));
            poLine.setC_ProjectPhase_ID(line.getC_ProjectPhase_ID());
            poLine.setC_ProjectTask_ID(line.getC_ProjectTask_ID());
            if (taxPO != null) {
                poLine.setC_Tax_ID(taxPO.get_ID());
            }
            poLine.saveEx();
            line.setLink_OrderLine_ID(poLine.getC_OrderLine_ID());
            line.saveEx();
        }
    }
}

