/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.awt.HeadlessException;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.ProcessUtil;
import org.compiere.cm.StringUtil;
import org.compiere.model.MMigration;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MigrationToXML
extends SvrProcess {
    private int migrationId = 0;
    private String fileName;
    private File tempFile;

    @Override
    protected String doIt() throws Exception {
        MMigration migration = new MMigration(this.getCtx(), this.migrationId, this.get_TrxName());
        if (migration == null || migration.is_new()) {
            return "@NoMigrationFound@";
        }
        this.log.log(Level.FINE, "Creating xml document for migration: " + migration);
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        Element root = document.createElement("Migrations");
        document.appendChild(root);
        root.appendChild(migration.toXmlNode(document));
        TransformerFactory transfac = TransformerFactory.newInstance();
        transfac.setAttribute("indent-number", 2);
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("standalone", "yes");
        this.fileName = migration.getReleaseNo() + "_" + migration.getSeqNo() + "_" + StringUtil.replace(migration.getName().trim(), " ", "") + ".xml";
        this.tempFile = null;
        if (ProcessInfo.INTERFACE_TYPE_SWING.equals(this.getProcessInfo().getInterfaceType())) {
            String path = Env.getContext(this.getCtx(), "Last Used Path");
            try {
                FileNameExtensionFilter filter = new FileNameExtensionFilter(Msg.getMsg(this.getCtx(), "FileXML"), "xml");
                JFileChooser chooser = new JFileChooser(path);
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle(this.getProcessInfo().getTitle());
                chooser.setDialogType(1);
                chooser.setFileFilter(filter);
                chooser.setSelectedFile(this.tempFile);
                int result = chooser.showSaveDialog(null);
                if (result != 0) {
                    return "@OperationCancelled@";
                }
                this.tempFile = chooser.getSelectedFile();
                this.tempFile.createNewFile();
                Env.setContext(this.getCtx(), "Last Used Path", this.tempFile.getAbsolutePath());
            }
            catch (HeadlessException e) {
                e.printStackTrace();
                throw new AdempiereException("Can't create file for XML export. " + e.getMessage());
            }
        }
        if (this.tempFile == null || !this.tempFile.isFile()) {
            this.tempFile = File.createTempFile("adempiere_", "_" + this.fileName);
        }
        this.fileName = this.tempFile.getAbsolutePath();
        this.log.log(Level.FINE, "Writing xml to file " + this.fileName);
        FileWriter fw = new FileWriter(this.fileName);
        StreamResult result = new StreamResult(fw);
        DOMSource source = new DOMSource(document);
        trans.transform(source, result);
        fw.close();
        if (ProcessInfo.INTERFACE_TYPE_ZK.equals(this.getProcessInfo().getInterfaceType())) {
            String className = "org.zkoss.zul.Filedownload";
            Class<?> Filedownload = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ProcessUtil.class.getClassLoader();
            }
            try {
                Filedownload = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                this.log.log(Level.WARNING, className, ex);
                throw new AdempiereException("Can't load the necessary class '" + className + "' to download the file. " + ex.getMessage());
            }
            Method save = null;
            Object FileDownloader = Filedownload.newInstance();
            File file = new File(this.fileName);
            try {
                save = Filedownload.getMethod("save", File.class, String.class);
                save.invoke(FileDownloader, file, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.log.log(Level.WARNING, "Can't download the file.", e);
                throw new AdempiereException("Can't download the file. " + e.getMessage());
            }
            this.tempFile.deleteOnExit();
            return "@XMLDownloadSuccessMessage@";
        }
        return "@ExportedMigrationXMLTo@: " + this.fileName;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] paras;
        for (ProcessInfoParameter para : paras = this.getParameter()) {
            if (!para.getParameterName().equals("AD_Migration_ID")) continue;
            this.migrationId = para.getParameterAsInt();
        }
        if (this.migrationId == 0) {
            this.migrationId = this.getRecord_ID();
        }
        this.log.log(Level.FINE, "AD_Migration_ID = " + this.migrationId);
    }
}

