/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.process.InvoiceCreateFromAbstract;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MAllocInvoice;

public class InvoiceCreateFrom
extends InvoiceCreateFromAbstract {
    private static final String RMA = "A";
    private static final String ORDER = "O";
    private static final String RECEIPT = "R";
    private static final String INVOICE = "I";

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() == 0) {
            return "";
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MDocType docTypeInv = new MDocType(this.getCtx(), invoice.getC_DocTypeTarget_ID(), this.get_TrxName());
        AtomicInteger referenceId = new AtomicInteger(0);
        AtomicInteger created = new AtomicInteger(0);
        List<Integer> recordIds = this.getSelectionKeys();
        String createFromType = recordIds.size() > 0 ? this.getSelectionAsString(recordIds.get(0), "CF_CreateFromType") : null;
        this.log.fine("CreateFromType=" + createFromType);
        if (createFromType == null || createFromType.length() == 0) {
            throw new AdempiereException("@CreateFromType@ @NotFound@");
        }
        MInvoice[] invoiceFrom = new MInvoice[]{null};
        recordIds.stream().forEach(key -> {
            block47: {
                MInvoiceLine fromLine;
                BigDecimal priceEntered;
                BigDecimal qtyEntered;
                int uomId;
                int chargeId;
                int productId;
                block46: {
                    ResultSet rs;
                    CPreparedStatement pstmt;
                    block45: {
                        MProduct product;
                        productId = this.getSelectionAsInt((int)key, "CF_M_Product_ID");
                        chargeId = this.getSelectionAsInt((int)key, "CF_C_Charge_ID");
                        uomId = this.getSelectionAsInt((int)key, "CF_C_UOM_ID");
                        qtyEntered = this.getSelectionAsBigDecimal((int)key, "CF_QtyEntered");
                        priceEntered = this.getSelectionAsBigDecimal((int)key, "CF_PriceEntered");
                        this.log.fine("Line QtyEntered=" + qtyEntered + ", Product=" + productId + ", CreateFromType=" + createFromType + ", Key=" + key);
                        if (invoice.isSOTrx() || !createFromType.equals(ORDER)) break block46;
                        MInvoiceLine invoiceLine = null;
                        MOrderLine orderLine = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
                        MOrder order = (MOrder)orderLine.getC_Order();
                        MDocType docType = (MDocType)order.getC_DocTypeTarget();
                        if (docType.getC_DocTypeInvoice_ID() > 0) {
                            invoice.setC_DocTypeTarget_ID(docType.getC_DocTypeInvoice_ID());
                        }
                        if (order.get_ValueAsBoolean("IsInDispute")) {
                            invoice.setIsInDispute(true);
                        }
                        referenceId.set(order.get_ID());
                        String whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID = M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                        MInOutLine[] inOutLines = MInOutLine.getOfOrderLine(Env.getCtx(), key, whereClause, this.get_TrxName());
                        this.log.fine("Receipt Lines with OrderLine = #" + inOutLines.length);
                        int precision = 2;
                        if (productId > 0 && (product = MProduct.get(Env.getCtx(), productId)) != null) {
                            precision = product.getUOMPrecision();
                            if (product.getC_UOM_ID() != uomId) {
                                qtyEntered = qtyEntered.setScale(precision, 5);
                            }
                        }
                        String sqlReturnedMInOut = "SELECT shipL.M_InOutLine_ID M_InOutLine_ID,CASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN shipL.qtyEntered ELSE shipL.movementQty END - CASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.qtyEntered ELSE 0 END) ELSE SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.movementQty ELSE 0 END) END qtyDelivered, shipL.movementQty - SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.qtyEntered ELSE 0 END) qtyMovement, (SELECT coalesce(SUM(qty),0) FROM m_matchinv WHERE m_inoutline_id = shipL.m_inoutline_id) as qtyUsed FROM C_OrderLine ol JOIN M_InOutLine shipL ON ol.C_OrderLine_ID=shipL.C_OrderLine_ID JOIN M_InOut ship ON shipL.M_InOut_ID=ship.M_InOut_ID JOIN C_DocType docShip ON ship.C_DocType_ID=docShip.C_DocType_ID LEFT JOIN M_RMALine rmal ON shipl.M_InOutLine_ID=rmal.M_InOutLine_ID LEFT JOIN M_InOutLine shiplDev ON rmal.M_RMALine_ID=shipLDev.M_RMALine_ID LEFT JOIN M_InOut shipDev ON shiplDev.M_InOut_ID=shipDev.M_InOut_ID WHERE docShip.DocBaseType='MMR' AND ship.docStatus='CO' AND shipL.isInvoiced='N' AND ol.C_OrderLine_ID=? GROUP BY ol.C_OrderLine_ID, shipL.M_InOutLine_ID HAVING (  CASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN shipL.qtyEntered ELSE shipL.movementQty END -   CASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.qtyEntered ELSE 0 END) ELSE SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.movementQty ELSE 0 END) END) <> 0";
                        pstmt = null;
                        rs = null;
                        try {
                            pstmt = DB.prepareStatement(sqlReturnedMInOut, this.get_TrxName());
                            pstmt.setInt(1, orderLine.get_ID());
                            rs = pstmt.executeQuery();
                            BigDecimal restShipQtyEntered = qtyEntered;
                            BigDecimal restShipQtyInvoiced = qtyEntered;
                            BigDecimal shipmentByOrderLine = Env.ZERO;
                            while (rs.next()) {
                                invoiceLine = new MInvoiceLine(invoice);
                                MInOutLine mInOutLine = new MInOutLine(this.getCtx(), rs.getInt("M_InOutLine_ID"), this.get_TrxName());
                                BigDecimal qtyEnt = rs.getBigDecimal("qtyDelivered");
                                BigDecimal qtyInv = rs.getBigDecimal("qtyMovement");
                                BigDecimal qtyUsed = rs.getBigDecimal("qtyUsed");
                                BigDecimal qtyAvailable = qtyEnt.subtract(qtyUsed);
                                if (qtyAvailable.compareTo(Env.ZERO) <= 0) continue;
                                invoiceLine.setC_OrderLine_ID(orderLine.get_ID());
                                invoiceLine.setM_InOutLine_ID(mInOutLine.get_ID());
                                if (productId > 0) {
                                    invoiceLine.setM_Product_ID(productId, uomId);
                                } else if (chargeId != 0) {
                                    invoiceLine.setC_Charge_ID(chargeId);
                                }
                                if (qtyEnt.compareTo(restShipQtyEntered) > 0) {
                                    qtyEnt = restShipQtyEntered;
                                }
                                if (qtyInv.compareTo(restShipQtyInvoiced) > 0) {
                                    qtyInv = restShipQtyInvoiced;
                                }
                                if (qtyEnt.compareTo(qtyAvailable) > 0) {
                                    qtyEnt = qtyAvailable;
                                    qtyInv = qtyAvailable;
                                }
                                invoiceLine.setQtyEntered(qtyEnt);
                                invoiceLine.setQtyInvoiced(qtyInv);
                                invoiceLine.setC_Tax_ID(orderLine.getC_Tax_ID());
                                invoiceLine.setPriceActual(priceEntered);
                                invoiceLine.setPriceList(priceEntered);
                                invoiceLine.setPriceEntered(priceEntered);
                                if (orderLine.getC_Project_ID() > 0) {
                                    invoiceLine.setC_Project_ID(orderLine.getC_Project_ID());
                                } else {
                                    invoiceLine.setC_Project_ID(order.getC_Project_ID());
                                }
                                invoiceLine.setUser1_ID(orderLine.getUser1_ID());
                                invoiceLine.setUser4_ID(orderLine.getUser4_ID());
                                invoiceLine.saveEx();
                                restShipQtyEntered = restShipQtyEntered.subtract(qtyEnt);
                                restShipQtyInvoiced = restShipQtyInvoiced.subtract(qtyInv);
                                shipmentByOrderLine = shipmentByOrderLine.add(qtyEnt);
                            }
                            if (shipmentByOrderLine.compareTo(qtyEntered) > 0) {
                                throw new AdempiereException("La cantidad ingresada a facturar es menor a la cantidad entregada => Entregado:" + shipmentByOrderLine.setScale(2, RoundingMode.HALF_UP) + ", Ingresado:" + qtyEntered);
                            }
                            if (restShipQtyEntered.compareTo(Env.ZERO) <= 0 && restShipQtyInvoiced.compareTo(Env.ZERO) <= 0) break block45;
                            MInvoiceLine invoiceLine2 = new MInvoiceLine(invoice);
                            if (productId > 0) {
                                invoiceLine2.setM_Product_ID(productId, uomId);
                            } else if (chargeId != 0) {
                                invoiceLine2.setC_Charge_ID(chargeId);
                            }
                            invoiceLine2.setQtyInvoiced(restShipQtyInvoiced);
                            invoiceLine2.setQtyEntered(restShipQtyEntered);
                            invoiceLine2.setC_OrderLine_ID(orderLine.get_ID());
                            invoiceLine2.setC_Tax_ID(orderLine.getC_Tax_ID());
                            invoiceLine2.setPriceActual(priceEntered);
                            invoiceLine2.setPriceList(priceEntered);
                            invoiceLine2.setPriceEntered(priceEntered);
                            if (orderLine.getC_Project_ID() > 0) {
                                invoiceLine2.setC_Project_ID(orderLine.getC_Project_ID());
                            } else {
                                invoiceLine2.setC_Project_ID(order.getC_Project_ID());
                            }
                            invoiceLine2.setUser1_ID(orderLine.getUser1_ID());
                            invoiceLine2.setUser4_ID(orderLine.getUser4_ID());
                            invoiceLine2.saveEx();
                        }
                        catch (Exception e) {
                            try {
                                throw new AdempiereException(e);
                            }
                            catch (Throwable throwable) {
                                DB.close(rs, pstmt);
                                throw throwable;
                            }
                        }
                    }
                    DB.close(rs, pstmt);
                    break block47;
                }
                MAllocInvoice alloc = null;
                MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                BigDecimal qtyInvoiced = null;
                int precision = 2;
                if (productId > 0) {
                    MProduct product = MProduct.get(Env.getCtx(), productId);
                    if (product != null) {
                        invoiceLine.setM_Product_ID(product.getM_Product_ID(), uomId);
                        precision = product.getUOMPrecision();
                        if (product.getC_UOM_ID() != uomId) {
                            qtyEntered = qtyEntered.setScale(precision, 5);
                            qtyInvoiced = MUOMConversion.convertProductFrom(Env.getCtx(), productId, uomId, qtyEntered);
                        }
                    }
                } else if (chargeId != 0) {
                    invoiceLine.setC_Charge_ID(chargeId);
                }
                qtyEntered = qtyEntered.setScale(precision, 5);
                if (qtyInvoiced == null) {
                    qtyInvoiced = qtyEntered;
                }
                invoiceLine.setQty(qtyEntered);
                invoiceLine.setQtyInvoiced(qtyInvoiced);
                if (createFromType.equals(ORDER)) {
                    MOrderLine orderLine = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
                    referenceId.set(orderLine.getC_Order_ID());
                    String whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID = M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                    MInOutLine[] inOutLines = MInOutLine.getOfOrderLine(Env.getCtx(), key, whereClause, this.get_TrxName());
                    this.log.fine("Receipt Lines with OrderLine = #" + inOutLines.length);
                    BigDecimal qty = qtyEntered;
                    MInOutLine inOutLine = Arrays.stream(inOutLines).filter(ioLine -> ioLine != null && ioLine.getQtyEntered().compareTo(qty) == 0).findFirst().orElseGet(() -> inOutLines.length > 0 ? inOutLines[0] : null);
                    if (inOutLine != null) {
                        invoiceLine.setShipLine(inOutLine);
                    } else {
                        invoiceLine.setOrderLine(orderLine);
                    }
                    invoiceLine.setPriceActual(priceEntered);
                    invoiceLine.setPriceList(priceEntered);
                    invoiceLine.setPriceEntered(priceEntered);
                } else if (createFromType.equals(INVOICE)) {
                    fromLine = new MInvoiceLine(this.getCtx(), (int)key, this.get_TrxName());
                    if (invoiceFrom[0] == null) {
                        invoiceFrom[0] = (MInvoice)fromLine.getC_Invoice();
                        invoice.setC_Project_ID(invoiceFrom[0].getC_Project_ID());
                        invoice.setUser1_ID(invoiceFrom[0].getUser1_ID());
                        invoice.setUser3_ID(invoiceFrom[0].getUser3_ID());
                        invoice.setUser4_ID(invoiceFrom[0].getUser4_ID());
                        invoice.setC_Campaign_ID(invoiceFrom[0].getC_Campaign_ID());
                        invoice.setC_Activity_ID(invoiceFrom[0].getC_Activity_ID());
                        invoice.setC_Order_ID(invoiceFrom[0].getC_Order_ID());
                        invoice.set_ValueOfColumn("S_Contract_ID", invoiceFrom[0].get_Value("S_Contract_ID"));
                        invoice.setM_PriceList_ID(invoiceFrom[0].getM_PriceList_ID());
                        invoice.setC_Currency_ID(invoiceFrom[0].getC_Currency_ID());
                        if (!invoice.isSOTrx() && this.IsCreditNote()) {
                            int docTypeTargetID = MDocType.getDocType("APC", " AND IsDefault = 'Y'");
                            invoice.setC_DocTypeTarget_ID(docTypeTargetID);
                        }
                        invoice.saveEx();
                    }
                    referenceId.set(invoiceLine.getParent().getC_Invoice_ID());
                    PO.copyValues(fromLine, invoiceLine);
                    invoiceLine.setQty(qtyEntered);
                    invoiceLine.setQtyInvoiced(qtyInvoiced);
                    invoiceLine.setC_Invoice_ID(invoiceLine.getParent().getC_Invoice_ID());
                    invoiceLine.setAD_Org_ID(fromLine.getAD_Org_ID());
                    invoiceLine.setC_OrderLine_ID(fromLine.getC_OrderLine_ID());
                    invoiceLine.setRef_InvoiceLine_ID(0);
                    invoiceLine.setM_InOutLine_ID(0);
                    invoiceLine.setA_Asset_ID(0);
                    invoiceLine.setM_AttributeSetInstance_ID(0);
                    invoiceLine.setS_ResourceAssignment_ID(0);
                    invoiceLine.set_ValueOfColumn("S_ContractLine_ID", fromLine.get_Value("S_ContractLine_ID"));
                    invoiceLine.set_ValueOfColumn("S_TimeExpenseLine_ID", fromLine.get_Value("S_TimeExpenseLine_ID"));
                    if (invoiceLine.getParent().getC_BPartner_ID() != fromLine.getC_Invoice().getC_BPartner_ID() || invoiceLine.getQtyInvoiced().compareTo(fromLine.getQtyInvoiced()) != 0) {
                        invoiceLine.setTaxAmt(Env.ZERO);
                        invoiceLine.setTax();
                    }
                    invoiceLine.setProcessed(false);
                    if (docTypeInv.getDocBaseType().equalsIgnoreCase("ARC") || docTypeInv.getDocBaseType().equalsIgnoreCase("APC")) {
                        alloc = MAllocInvoice.getByInvoice(this.getCtx(), invoiceFrom[0].get_ID(), invoice.get_ID(), this.get_TrxName());
                        if (alloc == null) {
                            alloc = new MAllocInvoice(this.getCtx(), 0, this.get_TrxName());
                            alloc.setC_Invoice_ID(invoice.get_ID());
                            alloc.setC_AllocInvoice_ID(invoiceFrom[0].get_ID());
                            BigDecimal amtInvAllocate = DB.getSQLValueBDEx(this.get_TrxName(), "select invoiceopen(" + invoiceFrom[0].get_ID() + ", null)", new Object[0]);
                            alloc.setOpenAmt(amtInvAllocate);
                            alloc.setAmtToAllocate(invoiceLine.getLineTotalAmt());
                        } else {
                            alloc.setAmtToAllocate(alloc.getAmtToAllocate().add(invoiceLine.getLineTotalAmt()));
                        }
                        alloc.setFromProcess(true);
                        alloc.saveEx();
                    }
                } else if (createFromType.equals(RMA)) {
                    MRMALine rmaLine = new MRMALine(this.getCtx(), (int)key, this.get_TrxName());
                    referenceId.set(rmaLine.getM_RMA_ID());
                    invoiceLine.setRMALine(rmaLine);
                } else if (createFromType.equals(RECEIPT)) {
                    MInOutLine inOutLine = new MInOutLine(this.getCtx(), (int)key, this.get_TrxName());
                    referenceId.set(inOutLine.getM_InOut_ID());
                    invoiceLine.setShipLine(inOutLine);
                }
                invoiceLine.saveEx();
                if (createFromType.equals(INVOICE)) {
                    fromLine = new MInvoiceLine(this.getCtx(), (int)key, this.get_TrxName());
                    invoiceLine.copyLandedCostFrom(fromLine);
                    invoiceLine.allocateLandedCosts();
                }
            }
            created.updateAndGet(createNo -> createNo + 1);
        });
        this.addReference(invoice, createFromType, referenceId.get());
        return "@Created@ " + created.get();
    }

    private void addReference(MInvoice invoice, String createFromType, int referenceId) {
        if (referenceId == 0) {
            return;
        }
        if (createFromType.equals(ORDER)) {
            MOrder order = new MOrder(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setOrder(order);
        } else if (createFromType.equals(INVOICE)) {
            MInvoice fromInvoice = new MInvoice(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setAD_OrgTrx_ID(fromInvoice.getAD_OrgTrx_ID());
            invoice.setC_Project_ID(fromInvoice.getC_Project_ID());
            invoice.setC_Campaign_ID(fromInvoice.getC_Campaign_ID());
            invoice.setC_Activity_ID(fromInvoice.getC_Activity_ID());
            invoice.setUser1_ID(fromInvoice.getUser1_ID());
            invoice.setUser2_ID(fromInvoice.getUser2_ID());
            invoice.setUser3_ID(fromInvoice.getUser3_ID());
            invoice.setUser4_ID(fromInvoice.getUser4_ID());
        } else if (createFromType.equals(RMA)) {
            MRMA rma = new MRMA(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setRMA(rma);
        } else if (createFromType.equals(RECEIPT)) {
            MInOut inOut = new MInOut(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setShipment(inOut);
        }
        invoice.saveEx();
    }
}

