/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_M_InOutLine;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.process.InOutGenerateAbstract;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InOutGenerate
extends InOutGenerateAbstract {
    private MInOut shipment = null;
    private int m_created = 0;
    private int m_line = 0;
    private int m_lastC_BPartner_Location_ID = -1;
    private HashMap<SParameter, MStorage[]> m_map = new HashMap();
    private SParameter m_lastPP = null;
    private MStorage[] m_lastStorages = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDocAction() == null) {
            this.setDocAction("CO");
        }
        if (this.getMovementDate() == null) {
            this.setMovementDate(Env.getContextAsDate(this.getCtx(), "#Date"));
            if (this.getMovementDate() == null) {
                this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            }
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("PR");
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.isSelection() + ", M_Warehouse_ID=" + this.getWarehouseId() + ", C_BPartner_ID=" + this.getBPartnerId() + ", Consolidate=" + this.isConsolidateDocument() + ", IsUnconfirmed=" + this.isUnconfirmedInOut() + ", Movement=" + this.getMovementDate());
        if (this.getWarehouseId() == 0) {
            throw new AdempiereUserError("@NotFound@ @M_Warehouse_ID@");
        }
        String message = null;
        if (this.isSelection()) {
            message = this.generate(new Query(this.getCtx(), "C_Order", "DocStatus='CO' AND IsSOTrx='Y' AND C_Order_ID IN" + this.getSelectionKeys().toString().replace('[', '(').replace(']', ')'), this.get_TrxName()).setClient_ID().setOrderBy("M_Warehouse_ID, PriorityRule, M_Shipper_ID, C_BPartner_ID, C_BPartner_Location_ID, C_Order_ID").list());
        } else {
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(this.getWarehouseId());
            StringBuffer whereAdded = new StringBuffer("AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.M_Warehouse_ID=?");
            if (this.getDatePromised() != null) {
                parameters.add(this.getDatePromised());
                whereAdded.append(" AND TRUNC(ol.DatePromised, 'DD') <= ?");
            }
            whereAdded.append(" AND C_Order.C_Order_ID= ol.C_Order_ID AND ol.QtyOrdered <> ol.QtyDelivered)");
            if (this.getBPartnerId() != 0) {
                parameters.add(this.getBPartnerId());
                whereAdded.append(" AND o.C_BPartner_ID = ?");
            }
            message = this.generate(new Query(this.getCtx(), "C_Order", "DocStatus='CO' AND IsSOTrx='Y' AND EXISTS(SELECT 1 FROM C_DocType dt WHERE dt.C_DocType_ID = C_Order.C_DocType_ID AND DocBaseType='SOO' AND DocSubTypeSO NOT IN ('ON','OB','WR')) AND IsDropShip='N' AND DeliveryRule<>'M' " + whereAdded, this.get_TrxName()).setParameters(parameters).setOrderBy("M_Warehouse_ID, PriorityRule, M_Shipper_ID, C_BPartner_ID, C_BPartner_Location_ID, C_Order_ID").setClient_ID().list());
        }
        return message;
    }

    private String generate(List<MOrder> orderList) {
        AtomicInteger counter = new AtomicInteger(0);
        orderList.forEach(order -> {
            BigDecimal toDeliver;
            MOrderLine line;
            int i2;
            counter.getAndIncrement();
            if (!this.isConsolidateDocument() || this.shipment != null && (this.shipment.getC_BPartner_Location_ID() != order.getC_BPartner_Location_ID() || this.shipment.getM_Shipper_ID() != order.getM_Shipper_ID())) {
                this.completeShipment();
            }
            this.log.fine("check: " + order + " - DeliveryRule=" + order.getDeliveryRule());
            Timestamp minGuaranteeDate = this.getMovementDate();
            boolean completeOrder = "O".equals(order.getDeliveryRule());
            String where = " AND M_Warehouse_ID=" + this.getWarehouseId();
            if (this.getDatePromised() != null) {
                where = where + " AND (TRUNC(DatePromised)<=" + DB.TO_DATE(this.getDatePromised(), true) + " OR DatePromised IS NULL)";
            }
            if (!"F".equals(order.getDeliveryRule())) {
                where = where + " AND (C_OrderLine.M_Product_ID IS NULL OR EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND IsExcludeAutoDelivery='N'))";
            }
            if (!this.isUnconfirmedInOut()) {
                where = where + " AND NOT EXISTS (SELECT * FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID=io.M_InOut_ID) WHERE iol.C_OrderLine_ID=C_OrderLine.C_OrderLine_ID AND io.DocStatus IN ('IP','WC'))";
            }
            MOrderLine[] lines = order.getLines(where, "C_BPartner_Location_ID, M_Product_ID");
            for (i2 = 0; i2 < lines.length; ++i2) {
                BigDecimal deliver;
                boolean fullLine;
                line = lines[i2];
                if (line.getM_Warehouse_ID() != this.getWarehouseId()) continue;
                this.log.fine("check: " + line);
                BigDecimal onHand = Env.ZERO;
                toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                MProduct product = line.getProduct();
                if (product != null && toDeliver.signum() == 0 || line.getC_Charge_ID() != 0 && toDeliver.signum() == 0) continue;
                BigDecimal unconfirmedShippedQty = Env.ZERO;
                if (this.isUnconfirmedInOut() && product != null && toDeliver.signum() != 0) {
                    String where2 = "EXISTS (SELECT * FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('IP','WC'))";
                    MInOutLine[] iols = MInOutLine.getOfOrderLine(this.getCtx(), line.getC_OrderLine_ID(), where2, null);
                    for (int j = 0; j < iols.length; ++j) {
                        unconfirmedShippedQty = unconfirmedShippedQty.add(iols[j].getMovementQty());
                    }
                    String logInfo = "Unconfirmed Qty=" + unconfirmedShippedQty + " - ToDeliver=" + toDeliver + "->";
                    toDeliver = toDeliver.subtract(unconfirmedShippedQty);
                    logInfo = logInfo + toDeliver;
                    if (toDeliver.signum() < 0) {
                        toDeliver = Env.ZERO;
                        logInfo = logInfo + " (set to 0)";
                    }
                    onHand = onHand.subtract(unconfirmedShippedQty);
                    this.log.fine(logInfo);
                }
                if (!(product != null && product.isStocked() || line.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                    if ("O".equals(order.getDeliveryRule())) continue;
                    this.createLine((MOrder)order, line, toDeliver, null, false);
                    continue;
                }
                String MMPolicy = product.getMMPolicy();
                MStorage[] storages = this.getStorages(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy));
                for (int j = 0; j < storages.length; ++j) {
                    MStorage storage = storages[j];
                    onHand = onHand.add(storage.getQtyOnHand());
                }
                boolean bl = fullLine = onHand.compareTo(toDeliver) >= 0 || toDeliver.signum() < 0;
                if (completeOrder && !fullLine) {
                    this.log.fine("Failed CompleteOrder - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + line);
                    completeOrder = false;
                    break;
                }
                if (fullLine && "L".equals(order.getDeliveryRule())) {
                    this.log.fine("CompleteLine - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ", ToDeliver=" + toDeliver + " - " + line);
                    this.createLine((MOrder)order, line, toDeliver, storages, false);
                    continue;
                }
                if ("A".equals(order.getDeliveryRule()) && (onHand.signum() > 0 || toDeliver.signum() < 0)) {
                    deliver = toDeliver;
                    if (deliver.compareTo(onHand) > 0) {
                        deliver = onHand;
                    }
                    this.log.fine("Available - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + line);
                    this.createLine((MOrder)order, line, deliver, storages, false);
                    continue;
                }
                if ("F".equals(order.getDeliveryRule())) {
                    deliver = toDeliver;
                    this.log.fine("Force - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + line);
                    this.createLine((MOrder)order, line, deliver, storages, true);
                    continue;
                }
                if ("M".equals(order.getDeliveryRule())) {
                    this.log.fine("Manual - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ") - " + line);
                    continue;
                }
                this.log.fine("Failed: " + order.getDeliveryRule() + " - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + line);
            }
            if (completeOrder && "O".equals(order.getDeliveryRule())) {
                for (i2 = 0; i2 < lines.length; ++i2) {
                    line = lines[i2];
                    if (line.getM_Warehouse_ID() != this.getWarehouseId()) continue;
                    MProduct product = line.getProduct();
                    toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                    MStorage[] storages = null;
                    if (product != null && product.isStocked()) {
                        String MMPolicy = product.getMMPolicy();
                        storages = this.getStorages(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy));
                    }
                    this.createLine((MOrder)order, line, toDeliver, storages, false);
                }
            }
            this.m_line += 1000;
        });
        this.completeShipment();
        return "@Created@ = " + this.m_created + " @of@ " + counter;
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qty, MStorage[] storages, boolean force) {
        if (this.m_lastC_BPartner_Location_ID != orderLine.getC_BPartner_Location_ID()) {
            this.completeShipment();
        }
        this.m_lastC_BPartner_Location_ID = orderLine.getC_BPartner_Location_ID();
        if (this.shipment == null) {
            this.shipment = new MInOut(order, 0, this.getMovementDate());
            this.shipment.setM_Warehouse_ID(orderLine.getM_Warehouse_ID());
            if (order.getC_BPartner_ID() != orderLine.getC_BPartner_ID()) {
                this.shipment.setC_BPartner_ID(orderLine.getC_BPartner_ID());
            }
            if (order.getC_BPartner_Location_ID() != orderLine.getC_BPartner_Location_ID()) {
                this.shipment.setC_BPartner_Location_ID(orderLine.getC_BPartner_Location_ID());
            }
            this.shipment.saveEx();
        }
        if (storages == null) {
            MInOutLine line = new MInOutLine(this.shipment);
            line.setOrderLine(orderLine, 0, Env.ZERO);
            line.setQty(qty);
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                line.setQtyEntered(qty.multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
            }
            line.setLine(this.m_line + orderLine.getLine());
            line.saveEx();
            this.log.fine(line.toString());
            return;
        }
        ArrayList<X_M_InOutLine> list = new ArrayList<X_M_InOutLine>();
        BigDecimal toDeliver = qty;
        for (int i2 = 0; i2 < storages.length; ++i2) {
            MStorage storage = storages[i2];
            BigDecimal deliver = toDeliver;
            if (storage.getQtyOnHand().signum() < 0) continue;
            if (deliver.compareTo(storage.getQtyOnHand()) > 0 && storage.getQtyOnHand().signum() >= 0 && (!force || force && i2 + 1 != storages.length)) {
                deliver = storage.getQtyOnHand();
            }
            if (deliver.signum() == 0) continue;
            int M_Locator_ID = storage.getM_Locator_ID();
            X_M_InOutLine line = null;
            if (orderLine.getM_AttributeSetInstance_ID() == 0) {
                for (int ll = 0; ll < list.size(); ++ll) {
                    MInOutLine test = (MInOutLine)list.get(ll);
                    if (test.getM_Locator_ID() != M_Locator_ID || test.getM_AttributeSetInstance_ID() != 0) continue;
                    line = test;
                    break;
                }
            }
            if (line == null) {
                line = new MInOutLine(this.shipment);
                ((MInOutLine)line).setOrderLine(orderLine, M_Locator_ID, order.isSOTrx() ? deliver : Env.ZERO);
                ((MInOutLine)line).setQty(deliver);
                list.add(line);
            } else {
                ((MInOutLine)line).setQty(line.getMovementQty().add(deliver));
            }
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                ((MInOutLine)line).setQtyEntered(line.getMovementQty().multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
            }
            line.setLine(this.m_line + orderLine.getLine());
            line.saveEx();
            this.log.fine("ToDeliver=" + qty + "/" + deliver + " - " + (MInOutLine)line);
            toDeliver = toDeliver.subtract(deliver);
            storage.setQtyOnHand(storage.getQtyOnHand().subtract(deliver));
            if (toDeliver.signum() == 0) break;
        }
        if (toDeliver.signum() != 0) {
            if (!force) {
                throw new IllegalStateException("Not All Delivered - Remainder=" + toDeliver);
            }
            MInOutLine line = new MInOutLine(this.shipment);
            line.setOrderLine(orderLine, 0, order.isSOTrx() ? toDeliver : Env.ZERO);
            line.setQty(toDeliver);
            line.saveEx();
        }
    }

    private MStorage[] getStorages(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo) {
        this.m_lastPP = new SParameter(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo);
        this.m_lastStorages = this.m_map.get(this.m_lastPP);
        if (this.m_lastStorages == null) {
            this.m_lastStorages = MStorage.getWarehouse(this.getCtx(), M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, false, 0, this.get_TrxName());
            this.m_map.put(this.m_lastPP, this.m_lastStorages);
        }
        return this.m_lastStorages;
    }

    private void completeShipment() {
        if (this.shipment != null) {
            if (!this.shipment.processIt(this.getDocAction())) {
                this.log.warning("Failed: " + this.shipment);
            }
            this.shipment.saveEx();
            this.addLog(this.shipment.getM_InOut_ID(), this.shipment.getMovementDate(), null, this.shipment.getDocumentNo());
            this.getProcessInfo().setRecord_ID(this.shipment.getM_InOut_ID());
            ++this.m_created;
            this.m_map = new HashMap();
            this.m_lastPP = null;
            this.m_lastStorages = null;
        }
        this.shipment = null;
        this.m_line = 0;
    }

    class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int p_Warehouse_ID, int p_Product_ID, int p_AttributeSetInstance_ID, Timestamp p_minGuaranteeDate, boolean p_FiFo) {
            this.M_Warehouse_ID = p_Warehouse_ID;
            this.M_Product_ID = p_Product_ID;
            this.M_AttributeSetInstance_ID = p_AttributeSetInstance_ID;
            this.minGuaranteeDate = p_minGuaranteeDate;
            this.FiFo = p_FiFo;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SParameter) {
                boolean eq;
                SParameter cmp = (SParameter)obj;
                boolean bl = eq = cmp.M_Warehouse_ID == this.M_Warehouse_ID && cmp.M_Product_ID == this.M_Product_ID && cmp.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && cmp.M_AttributeSet_ID == this.M_AttributeSet_ID && cmp.allAttributeInstances == this.allAttributeInstances && cmp.FiFo == this.FiFo;
                if (!(!eq || cmp.minGuaranteeDate == null && this.minGuaranteeDate == null || cmp.minGuaranteeDate != null && this.minGuaranteeDate != null && cmp.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    eq = false;
                }
                return eq;
            }
            return false;
        }

        public int hashCode() {
            long hash = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                hash *= -1L;
            }
            if (this.FiFo) {
                hash *= -2L;
            }
            if (hash < 0L) {
                hash = -hash + 7L;
            }
            while (hash > Integer.MAX_VALUE) {
                hash -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                hash += (long)this.minGuaranteeDate.hashCode();
                while (hash > Integer.MAX_VALUE) {
                    hash -= Integer.MAX_VALUE;
                }
            }
            return (int)hash;
        }
    }
}

