/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class FactReconciliation
extends SvrProcess {
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_Account_ID = 0;
    private long m_start = System.currentTimeMillis();

    @Override
    protected void prepare() {
        StringBuffer sb = new StringBuffer("AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("DateAcct")) {
                this.p_DateAcct_From = (Timestamp)para[i2].getParameter();
                this.p_DateAcct_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("Account_ID")) {
                this.p_Account_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() {
        CPreparedStatement pstmt = null;
        Object rs = null;
        String sql = "INSERT into T_Reconciliation (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, Fact_Acct_ID,  AD_PInstance_ID, MatchCode) SELECT f.AD_Client_ID, f.AD_Org_ID, f.Created, f.CreatedBy, f.Updated, f.UpdatedBy, f.IsActive, f.Fact_Acct_ID, ?, r.MatchCode FROM Fact_Acct f LEFT OUTER JOIN Fact_Reconciliation r ON (f.Fact_Acct_ID=r.Fact_Acct_ID) WHERE Account_ID = ? AND DateAcct BETWEEN  ? AND ? ";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_PInstance_ID());
            pstmt.setInt(2, this.p_Account_ID);
            pstmt.setTimestamp(3, this.p_DateAcct_From);
            pstmt.setTimestamp(4, this.p_DateAcct_To);
            int count = pstmt.executeUpdate();
            String result = Msg.getMsg(this.getCtx(), "@Created@") + ": " + count + ", ";
            this.log.log(Level.FINE, result);
            sql = "DELETE FROM T_Reconciliation t WHERE (SELECT SUM(f.amtacctdr-f.amtacctcr) FROM T_Reconciliation r     INNER JOIN Fact_Acct f ON (f.Fact_Acct_ID = r.Fact_Acct_ID)        WHERE r.MatchCode=t.MatchCode       AND r.AD_PInstance_ID = t.AD_PInstance_ID) = 0 AND t.AD_PInstance_ID = ?";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_PInstance_ID());
            count = pstmt.executeUpdate();
            result = Msg.getMsg(this.getCtx(), "@Deleted@") + ": " + count;
            this.log.log(Level.FINE, result);
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            String string = e.getLocalizedMessage();
            return string;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "";
    }
}

