/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTypePhase;
import org.compiere.process.CopyProjectTypePhasesIntoProjectAbstract;

public class CopyProjectTypePhasesIntoProject
extends CopyProjectTypePhasesIntoProjectAbstract {
    private int p_C_Project_ID = 0;
    private MProject m_project;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.p_C_Project_ID = this.getProjectId();
        if (this.p_C_Project_ID == 0) {
            return "@C_Project_ID@ @NotFound@";
        }
        this.m_project = MProject.getById(this.getCtx(), this.p_C_Project_ID, this.get_TrxName());
        int count = 0;
        List<MProjectTypePhase> projectTypePhases = this.getInstancesForSelection(this.get_TrxName());
        count = this.populateProjectPhase(this.m_project, projectTypePhases);
        this.correctProjectSequences(this.m_project);
        return "@Created@/@Updated@ #" + count;
    }

    private int populateProjectPhase(MProject project, List<MProjectTypePhase> projectTypePhases) {
        AtomicInteger count = new AtomicInteger(0);
        projectTypePhases.stream().forEach(projectTypePhase -> {
            MProjectPhase projectPhase = this.getProjectPhase(project, (MProjectTypePhase)projectTypePhase);
            if (projectPhase == null) {
                projectPhase = new MProjectPhase(project, (MProjectTypePhase)projectTypePhase);
                projectPhase.setProjInvoiceRule(project.getProjInvoiceRule());
                projectPhase.saveEx();
                count.updateAndGet(no -> no + 1);
            }
        });
        return count.get();
    }

    private MProjectPhase getProjectPhase(MProject project, MProjectTypePhase projectTypePhase) {
        MProjectPhase resultProjectPhase = null;
        List<MProjectPhase> projectPhases = project.getPhases();
        for (MProjectPhase projectPhase : projectPhases) {
            if (projectPhase.getC_Phase_ID() != projectTypePhase.getC_Phase_ID() || !projectPhase.getName().equalsIgnoreCase(projectTypePhase.getName())) continue;
            resultProjectPhase = projectPhase;
            break;
        }
        return resultProjectPhase;
    }

    private boolean correctProjectSequences(MProject project) {
        int seqNoPhase = 10;
        for (MProjectPhase projectPhase : project.getPhases()) {
            projectPhase.setSeqNo(seqNoPhase);
            seqNoPhase += 10;
            projectPhase.saveEx();
        }
        return true;
    }
}

