/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Hashtable;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProduct;
import org.compiere.process.CommissionAPInvoiceAbstract;
import org.compiere.util.Env;

public class CommissionAPInvoice
extends CommissionAPInvoiceAbstract {
    private int created = 0;
    private StringBuffer generatedDocuments = new StringBuffer();
    private Hashtable<Integer, MInvoice> invoices;

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - C_CommissionRun_ID=" + this.getRecord_ID());
        MCommissionRun commissionRun = new MCommissionRun(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (commissionRun.getC_CommissionRun_ID() == 0) {
            throw new IllegalArgumentException("@C_CommissionRun_ID@ @NotFound@");
        }
        if (Env.ZERO.compareTo(commissionRun.getGrandTotal()) == 0) {
            throw new IllegalArgumentException("@GrandTotal@ = 0");
        }
        if (!commissionRun.getDocStatus().equals("CO")) {
            throw new IllegalArgumentException("@C_CommissionRun_ID@ @NotValid@");
        }
        MCommission commissionDefinition = new MCommission(this.getCtx(), commissionRun.getC_Commission_ID(), this.get_TrxName());
        if (commissionDefinition.getC_Commission_ID() == 0) {
            throw new IllegalArgumentException("@C_Commission_ID@ @NotFound@");
        }
        if (commissionDefinition.getC_Charge_ID() == 0 && commissionDefinition.get_ValueAsInt("M_Product_ID") == 0) {
            throw new IllegalArgumentException("@C_Commission_ID@ - (@M_Product_ID@ / @C_Charge_ID@) @NotFound@");
        }
        this.invoices = new Hashtable();
        commissionRun.getCommissionAmtList().stream().filter(commissionAmt -> commissionAmt.getCommissionAmt() != null && commissionAmt.getCommissionAmt().compareTo(Env.ZERO) > 0).forEach(commissionAmt -> {
            MInvoice invoice = this.getInvoice(commissionDefinition, commissionRun, (MCommissionAmt)commissionAmt);
            this.createInvoiceLine((MCommissionAmt)commissionAmt, invoice, commissionDefinition.getC_Charge_ID(), commissionDefinition.get_ValueAsInt("M_Product_ID"));
        });
        return "@Created@ " + this.created + (String)(this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private MInvoice getInvoice(MCommission commissionDefinition, MCommissionRun commissionRun, MCommissionAmt commissionAmt) {
        MInvoice invoice = this.invoices.get(commissionAmt.getC_BPartner_ID());
        if (invoice != null) {
            return invoice;
        }
        invoice = new MInvoice(this.getCtx(), 0, null);
        invoice.setClientOrg(commissionAmt.getAD_Client_ID(), commissionAmt.getAD_Org_ID());
        invoice.setC_DocTypeTarget_ID("API");
        MBPartner businessPartner = MBPartner.get(this.getCtx(), commissionAmt.getC_BPartner_ID());
        invoice.setBPartner(businessPartner);
        invoice.setSalesRep_ID(this.getAD_User_ID());
        if (commissionDefinition.getC_Currency_ID() != invoice.getC_Currency_ID()) {
            throw new IllegalArgumentException("@CommissionAPInvoiceCurrency@");
        }
        invoice.saveEx();
        this.invoices.put(commissionAmt.getC_BPartner_ID(), invoice);
        ++this.created;
        this.addToMessage(invoice.getDocumentNo());
        return invoice;
    }

    private void createInvoiceLine(MCommissionAmt commissionAmt, MInvoice invoice, int chargeId, int productId) {
        MInvoiceLine iLine = new MInvoiceLine(invoice);
        if (productId > 0) {
            MProduct product = MProduct.get(this.getCtx(), productId);
            iLine.setProduct(product);
        } else {
            iLine.setC_Charge_ID(chargeId);
        }
        iLine.setQty(1);
        iLine.setPrice(commissionAmt.getCommissionAmt());
        iLine.setTax();
        iLine.saveEx();
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }
}

