/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_T_CombinedAging;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCombinedAging;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CombinedAgingRevalue
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private int p_C_ConversionType_ID = 0;
    private Timestamp p_StatementDate = null;
    private String p_IsSOTrx = "B";
    private int p_C_Currency_ID = 0;
    private int as_C_Currency_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private boolean p_ListSources = false;
    private int m_statementOffset = 0;
    private boolean p_IncludePayments = true;
    private boolean p_IsDateInvoiced = false;
    private boolean p_IsExclude = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_ConversionType_ID")) {
                this.p_C_ConversionType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("StatementDate")) {
                this.p_StatementDate = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("IsSOTrx") && para[i].getParameter() != null) {
                this.p_IsSOTrx = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("ListSources")) {
                this.p_ListSources = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsIncludePayments")) {
                this.p_IncludePayments = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsDateInvoiced")) {
                this.p_IsDateInvoiced = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsExclude")) {
                this.p_IsExclude = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
        this.as_C_Currency_ID = as.getC_Currency_ID();
        if (this.p_StatementDate == null) {
            this.p_StatementDate = new Timestamp(System.currentTimeMillis());
        } else {
            this.m_statementOffset = TimeUtil.getDaysBetween(new Timestamp(System.currentTimeMillis()), this.p_StatementDate, new int[0]);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("StatementDate=" + this.p_StatementDate + ", IsSOTrx=" + this.p_IsSOTrx + ", C_Currency_ID=" + this.as_C_Currency_ID + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", ListSources=" + this.p_ListSources);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bp.C_BP_Group_ID, oi.C_BPartner_ID,oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID, oi.C_Currency_ID, oi.IsSOTrx, oi.DateInvoiced, oi.NetDays,oi.DueDate,oi.DaysDue, ");
        Object s = ",oi.C_Currency_ID," + this.as_C_Currency_ID + ",?," + (Serializable)(this.p_C_ConversionType_ID == 0 ? "oi.C_ConversionType_ID" : Integer.valueOf(this.p_C_ConversionType_ID)) + ",oi.AD_Client_ID,oi.AD_Org_ID)";
        sql.append("currencyConvert(oi.GrandTotal").append((String)s).append(", currencyConvert((oi.GrandTotal - (CASE WHEN oi.C_Invoice_ID IS NOT NULL THEN invoiceOpenToDate(oi.C_Invoice_ID, 0, ?) ELSE paymentAvailableToDate(oi.C_Payment_ID, ?)*CASE WHEN oi.ISSoTrx='Y' THEN -1 ELSE 1 END END ))").append((String)s).append(", currencyConvert((CASE WHEN oi.C_Invoice_ID IS NOT NULL THEN invoiceOpenToDate(oi.C_Invoice_ID, 0, ?) ELSE 0 END)").append((String)s).append(", currencyConvert((CASE WHEN oi.C_Payment_ID IS NOT NULL THEN paymentAvailableToDate(oi.C_Payment_ID, ?)*(CASE WHEN oi.ISSoTrx='Y' THEN -1 ELSE 1 END) ELSE 0 END )").append((String)s);
        sql.append(",oi.C_Activity_ID,oi.C_Campaign_ID,oi.C_Project_ID, oi.C_Payment_ID, oi.AD_Org_ID, oi.s_contract_id, currencyrate(oi.c_currency_id, " + this.as_C_Currency_ID + ", oi.dateacct, 0, oi.ad_client_id, 0) as currencyrate,    currencyrate(oi.c_currency_id, " + this.as_C_Currency_ID + ",'" + this.p_StatementDate + "', " + this.p_C_ConversionType_ID + ", oi.ad_client_id, 0) as rate, oi.grandtotal, case when oi.c_invoice_id > 0 then invoiceOpenToDate(oi.C_Invoice_ID, 0, '" + this.p_StatementDate + "') else 0 end as openamt, case when oi.c_payment_id > 0 then paymentavailabletodate(oi.c_payment_id, '" + this.p_StatementDate + "') else 0 end as openamtpay  FROM RV_CombinedOpenItem oi INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID) LEFT JOIN C_Invoice inv ON (oi.C_Invoice_ID=inv.C_Invoice_ID) LEFT JOIN C_DocType dt ON (inv.C_DocTypeTarget_ID=dt.C_DocType_ID) ");
        s = this.p_IsSOTrx.equals("B") ? "Y','N" : this.p_IsSOTrx;
        sql.append("WHERE oi.ISSoTrx IN ('" + (String)s + "') ");
        if (!this.p_IncludePayments) {
            sql.append(" AND oi.C_Invoice_ID IS NOT NULL ");
        }
        if (this.p_C_Currency_ID != 0) {
            sql.append(" AND oi.C_Currency_ID = " + this.p_C_Currency_ID);
        }
        if (this.p_C_BPartner_ID > 0) {
            sql.append(" AND oi.C_BPartner_ID=").append(this.p_C_BPartner_ID);
        } else if (this.p_C_BP_Group_ID > 0) {
            sql.append(" AND bp.C_BP_Group_ID=").append(this.p_C_BP_Group_ID);
        }
        if (this.p_AD_Org_ID > 0) {
            sql.append(" AND oi.AD_Org_ID=").append(this.p_AD_Org_ID);
        }
        if (this.p_IsExclude) {
            sql.append(" AND dt.DocBaseType NOT IN ('DPI','DRI')");
        }
        sql.append(" AND oi.DateInvoiced <= ?");
        sql.append(" AND (CASE WHEN oi.C_Invoice_ID IS NOT NULL THEN invoiceOpenToDate(oi.C_Invoice_ID, 0, ?) ELSE paymentAvailableToDate(oi.C_Payment_ID, ?) END ) <> 0");
        sql.append(" ORDER BY oi.C_BPartner_ID, oi.C_Currency_ID, oi.C_Invoice_ID, oi.C_Payment_ID ");
        this.log.fine("SQL: " + sql.toString());
        String finalSql = MRole.getDefault(this.getCtx(), false).addAccessSQL(sql.toString(), "oi", true, false);
        this.log.finer(finalSql);
        CPreparedStatement pstmt = null;
        PO aging = null;
        int counter = 0;
        int rows = 0;
        int AD_PInstance_ID = this.getAD_PInstance_ID();
        try {
            Date date = new Date(this.p_StatementDate.getTime());
            pstmt = DB.prepareStatement(finalSql, this.get_TrxName());
            pstmt.setDate(1, date);
            pstmt.setDate(2, date);
            pstmt.setDate(3, date);
            pstmt.setDate(4, date);
            pstmt.setDate(5, date);
            pstmt.setDate(6, date);
            pstmt.setDate(7, date);
            pstmt.setDate(8, date);
            pstmt.setDate(9, date);
            pstmt.setDate(10, date);
            pstmt.setDate(11, date);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_BP_Group_ID = rs.getInt(1);
                int C_BPartner_ID = rs.getInt(2);
                int C_Invoice_ID = this.p_ListSources ? rs.getInt(3) : 0;
                int C_InvoicePaySchedule_ID = this.p_ListSources ? rs.getInt(4) : 0;
                int C_Currency_ID = rs.getInt(5);
                boolean IsSOTrx = "Y".equals(rs.getString(6));
                Timestamp DateInvoiced = rs.getTimestamp(7);
                Timestamp DueDate = rs.getTimestamp(9);
                int DaysDue = 0;
                DaysDue = this.p_IsDateInvoiced ? DB.getSQLValueEx(this.get_TrxName(), "select (EXTRACT(epoch FROM ('" + this.p_StatementDate + "'::timestamp - '" + DateInvoiced + "'::timestamp )))/3600/24", new Object[0]) : rs.getInt(10) + this.m_statementOffset;
                BigDecimal GrandTotal = rs.getBigDecimal(11) == null ? new BigDecimal(0) : rs.getBigDecimal(11);
                BigDecimal OpenAmtInv = rs.getBigDecimal(13) == null ? new BigDecimal(0) : rs.getBigDecimal(13);
                BigDecimal OpenAmtPay = rs.getBigDecimal(14) == null ? new BigDecimal(0) : rs.getBigDecimal(14);
                int C_Activity_ID = this.p_ListSources ? rs.getInt(15) : 0;
                int C_Campaign_ID = this.p_ListSources ? rs.getInt(16) : 0;
                int C_Project_ID = this.p_ListSources ? rs.getInt(17) : 0;
                int C_Payment_ID = this.p_ListSources ? rs.getInt(18) : 0;
                int AD_Org_ID = rs.getInt(19);
                int S_Contract_ID = rs.getInt(20);
                BigDecimal rateAcct = rs.getBigDecimal(21);
                BigDecimal rateActual = rs.getBigDecimal(22);
                BigDecimal amount = rs.getBigDecimal(23);
                BigDecimal OpenAmtSourceInv = rs.getBigDecimal(24);
                BigDecimal OpenAmtSourcePay = rs.getBigDecimal(25);
                ++rows;
                if (aging == null || AD_PInstance_ID != ((X_T_CombinedAging)aging).getAD_PInstance_ID() || C_BPartner_ID != ((X_T_CombinedAging)aging).getC_BPartner_ID() || C_Currency_ID != ((X_T_CombinedAging)aging).getC_Currency_ID() || C_Invoice_ID != ((X_T_CombinedAging)aging).getC_Invoice_ID() || C_InvoicePaySchedule_ID != ((X_T_CombinedAging)aging).getC_InvoicePaySchedule_ID() || C_Payment_ID != ((X_T_CombinedAging)aging).getC_Payment_ID()) {
                    if (aging != null) {
                        this.log.fine("Attempting to save" + (MCombinedAging)aging);
                        if (aging.save()) {
                            this.log.fine("#" + ++counter + " - " + (MCombinedAging)aging);
                        } else {
                            this.log.log(Level.SEVERE, "Not saved " + (MCombinedAging)aging);
                            break;
                        }
                    }
                    aging = new MCombinedAging(this.getCtx(), AD_PInstance_ID, this.p_StatementDate, C_BPartner_ID, C_Currency_ID, C_Invoice_ID, C_Payment_ID, C_InvoicePaySchedule_ID, C_BP_Group_ID, AD_Org_ID, DueDate, IsSOTrx, this.get_TrxName());
                    ((X_T_CombinedAging)aging).setC_Activity_ID(C_Activity_ID);
                    ((X_T_CombinedAging)aging).setC_Campaign_ID(C_Campaign_ID);
                    ((X_T_CombinedAging)aging).setC_Project_ID(C_Project_ID);
                    aging.set_ValueOfColumn("S_Contract_ID", (Object)S_Contract_ID);
                    aging.set_ValueOfColumn("CurrencyRate", (Object)rateAcct);
                    aging.set_ValueOfColumn("Rate", (Object)rateActual);
                    ((X_T_CombinedAging)aging).setIsIncludePayments(this.p_IncludePayments);
                    if (C_Currency_ID != this.as_C_Currency_ID) {
                        if (rateActual != null) {
                            BigDecimal amtReval = amount.multiply(rateActual);
                            aging.set_ValueOfColumn("Amount", (Object)amtReval);
                        }
                        if (rateActual != null && rateAcct != null) {
                            BigDecimal diff = rateActual.subtract(rateAcct);
                            BigDecimal AmtRevalDiff = Env.ZERO;
                            AmtRevalDiff = ((X_T_CombinedAging)aging).getC_Invoice_ID() > 0 ? diff.multiply(OpenAmtSourceInv) : diff.multiply(OpenAmtSourcePay);
                            aging.set_ValueOfColumn("AmtRevalDiff", (Object)AmtRevalDiff);
                        }
                    }
                }
                int multiplier = 1;
                if (this.p_IsSOTrx.equals("B") && !IsSOTrx) {
                    multiplier = -1;
                }
                if (this.p_IsDateInvoiced) {
                    DueDate = DateInvoiced;
                }
                if (((X_T_CombinedAging)aging).getC_Invoice_ID() > 0) {
                    ((MCombinedAging)aging).add(DueDate, DaysDue, GrandTotal.multiply(new BigDecimal(multiplier)), OpenAmtInv.multiply(new BigDecimal(multiplier)));
                    continue;
                }
                ((MCombinedAging)aging).add(DueDate, DaysDue, GrandTotal.multiply(new BigDecimal(multiplier)), OpenAmtPay.multiply(new BigDecimal(multiplier)));
            }
            if (aging != null) {
                if (aging.save()) {
                    this.log.fine("#" + ++counter + " - " + (MCombinedAging)aging);
                } else {
                    this.log.log(Level.SEVERE, "Not saved " + (MCombinedAging)aging);
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, finalSql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info("#" + counter + " - rows=" + rows);
        return "";
    }
}

