/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trx;

public class ColumnEncryption
extends SvrProcess {
    private boolean p_IsEncrypted = false;
    private boolean p_ChangeSetting = false;
    private int p_MaxLength = 0;
    private String p_TestValue = null;
    private int p_AD_Column_ID = 0;
    private Trx m_trx;
    private Connection m_conn;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("IsEncrypted")) {
                this.p_IsEncrypted = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("ChangeSetting")) {
                this.p_ChangeSetting = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("MaxLength")) {
                this.p_MaxLength = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("TestValue")) {
                this.p_TestValue = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        int encLength;
        this.log.info("AD_Column_ID=" + this.p_AD_Column_ID + ", IsEncrypted=" + this.p_IsEncrypted + ", ChangeSetting=" + this.p_ChangeSetting + ", MaxLength=" + this.p_MaxLength);
        MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
        if (column.get_ID() == 0 || column.get_ID() != this.p_AD_Column_ID) {
            throw new AdempiereUserError("@NotFound@ @AD_Column_ID@ - " + this.p_AD_Column_ID);
        }
        String columnName = column.getColumnName();
        int dt = column.getAD_Reference_ID();
        if (column.isKey() || column.isParent() || column.isStandardColumn() || column.isVirtualColumn() || column.isIdentifier() || column.isTranslated() || DisplayType.isLookup(dt) || DisplayType.isLOB(dt) || "DocumentNo".equalsIgnoreCase(column.getColumnName()) || "Value".equalsIgnoreCase(column.getColumnName()) || "Name".equalsIgnoreCase(column.getColumnName())) {
            if (column.isEncrypted()) {
                column.setIsEncrypted(false);
                column.saveEx();
            }
            return columnName + ": cannot be encrypted";
        }
        this.addLog(0, null, null, "Encryption Class = " + SecureEngine.getClassName());
        boolean error = false;
        if (this.p_TestValue != null && this.p_TestValue.length() > 0) {
            String encString = SecureEngine.encrypt(this.p_TestValue);
            this.addLog(0, null, null, "Encrypted Test Value=" + encString);
            String clearString = SecureEngine.decrypt(encString);
            if (this.p_TestValue.equals(clearString)) {
                this.addLog(0, null, null, "Decrypted=" + clearString + " (same as test value)");
            } else {
                this.addLog(0, null, null, "Decrypted=" + clearString + " (NOT the same as test value - check algorithm)");
                error = true;
            }
            encLength = encString.length();
            this.addLog(0, null, null, "Test Length=" + this.p_TestValue.length() + " -> " + encLength);
            if (encLength <= column.getFieldLength()) {
                this.addLog(0, null, null, "Encrypted Length (" + encLength + ") fits into field (" + column.getFieldLength() + ")");
            } else {
                this.addLog(0, null, null, "Encrypted Length (" + encLength + ") does NOT fit into field (" + column.getFieldLength() + ") - resize field");
                error = true;
            }
        }
        if (this.p_MaxLength != 0) {
            Object testClear = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            while (((String)testClear).length() < this.p_MaxLength) {
                testClear = (String)testClear + (String)testClear;
            }
            testClear = ((String)testClear).substring(0, this.p_MaxLength);
            this.log.config("Test=" + (String)testClear + " (" + this.p_MaxLength + ")");
            String encString = SecureEngine.encrypt((String)testClear);
            encLength = encString.length();
            this.addLog(0, null, null, "Test Max Length=" + ((String)testClear).length() + " -> " + encLength);
            if (encLength <= column.getFieldLength()) {
                this.addLog(0, null, null, "Encrypted Max Length (" + encLength + ") fits into field (" + column.getFieldLength() + ")");
            } else {
                this.addLog(0, null, null, "Encrypted Max Length (" + encLength + ") does NOT fit into field (" + column.getFieldLength() + ") - resize field");
                error = true;
            }
        }
        if (this.p_IsEncrypted && this.p_ChangeSetting) {
            if (column.isEncrypted()) {
                this.log.severe("EncryptError: Column already encrypted.");
                throw new Exception();
            }
            this.m_trx = Trx.get(this.get_TrxName(), true);
            this.m_conn = this.m_trx.getConnection();
            if (this.m_conn == null) {
                this.log.warning("EncryptError: No connections available");
                throw new Exception();
            }
            this.m_conn.setAutoCommit(false);
            int columnID = column.get_ID();
            MTable table2 = MTable.get(this.getCtx(), column.getAD_Table_ID());
            String tableName = table2.getTableName();
            int oldLength = column.getFieldLength();
            int newLength = this.encryptedColumnLength(oldLength);
            if (newLength > oldLength && this.changeFieldLength(columnID, columnName, newLength, tableName) == -1) {
                this.log.warning("EncryptError [ChangeFieldLength]: ColumnID=" + columnID + ", NewLength=" + newLength);
                throw new Exception();
            }
            if (this.encryptColumnContents(columnName, column.getAD_Table_ID()) == -1) {
                this.log.warning("EncryptError: No records encrypted.");
                throw new Exception();
            }
            if (this.p_IsEncrypted != column.isEncrypted()) {
                if (error || !this.p_ChangeSetting) {
                    this.addLog(0, null, null, "Encryption NOT changed - Encryption=" + column.isEncrypted());
                } else {
                    column.setIsEncrypted(this.p_IsEncrypted);
                    if (column.save()) {
                        this.addLog(0, null, null, "Encryption CHANGED - Encryption=" + column.isEncrypted());
                    } else {
                        this.addLog(0, null, null, "Save Error");
                    }
                }
            }
        }
        return "Encryption=" + column.isEncrypted();
    }

    private int encryptColumnContents(String columnName, int tableID) throws Exception {
        String tableName = MTable.getTableName(this.getCtx(), tableID);
        return this.encryptColumnContents(columnName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int encryptColumnContents(String columnName, String tableName) throws Exception {
        int recordsEncrypted = 0;
        String idColumnName = tableName + "_ID";
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT " + idColumnName + "," + columnName);
        selectSql.append(" FROM " + tableName);
        selectSql.append(" ORDER BY " + idColumnName);
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE " + tableName);
        updateSql.append(" SET " + columnName + "=?");
        updateSql.append(" WHERE " + idColumnName + "=?");
        PreparedStatement selectStmt = null;
        PreparedStatement updateStmt = null;
        ResultSet rs = null;
        try {
            selectStmt = this.m_conn.prepareStatement(selectSql.toString(), 1003, 1008);
            updateStmt = this.m_conn.prepareStatement(updateSql.toString());
            rs = selectStmt.executeQuery();
            recordsEncrypted = 0;
            while (rs.next()) {
                int id = rs.getInt(1);
                String value = rs.getString(2);
                value = SecureEngine.encrypt(value);
                updateStmt.setString(1, value);
                updateStmt.setInt(2, id);
                if (updateStmt.executeUpdate() != 1) {
                    this.log.warning("EncryptError: Table=" + tableName + ", ID=" + id);
                    throw new Exception();
                }
                ++recordsEncrypted;
            }
        }
        catch (Exception exception) {
            try {
                this.log.severe(exception.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, selectStmt);
                DB.close(updateStmt);
                rs = null;
                selectStmt = null;
                updateStmt = null;
                throw throwable;
            }
            DB.close(rs, selectStmt);
            DB.close(updateStmt);
            rs = null;
            selectStmt = null;
            updateStmt = null;
        }
        DB.close(rs, selectStmt);
        DB.close(updateStmt);
        rs = null;
        selectStmt = null;
        updateStmt = null;
        return recordsEncrypted;
    }

    private int encryptedColumnLength(int colLength) {
        Object str = "";
        for (int i2 = 0; i2 < colLength; ++i2) {
            str = (String)str + "1";
        }
        str = SecureEngine.encrypt((String)str);
        return ((String)str).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int changeFieldLength(int columnID, String columnName, int length, String tableName) throws Exception {
        ResultSet rs;
        PreparedStatement selectStmt;
        int rowsEffected;
        block5: {
            rowsEffected = -1;
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("SELECT FieldLength");
            selectSql.append(" FROM AD_Column");
            selectSql.append(" WHERE AD_Column_ID=?");
            StringBuffer alterSql = new StringBuffer();
            alterSql.append("ALTER TABLE " + tableName);
            alterSql.append(" MODIFY " + columnName);
            alterSql.append(" NVARCHAR2(");
            alterSql.append(length + ") ");
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("UPDATE AD_Column");
            updateSql.append(" SET FieldLength=" + length);
            updateSql.append(" WHERE AD_Column_ID=" + columnID);
            selectStmt = null;
            rs = null;
            try {
                selectStmt = this.m_conn.prepareStatement(selectSql.toString(), 1003, 1008);
                selectStmt.setInt(1, columnID);
                rs = selectStmt.executeQuery();
                if (!rs.next()) break block5;
                if (DB.executeUpdate(alterSql.toString(), false, this.m_trx.getTrxName()) == -1) {
                    this.log.warning("EncryptError [ChangeFieldLength]: ColumnID=" + columnID + ", NewLength=" + length);
                    throw new Exception();
                }
                if (DB.executeUpdate(updateSql.toString(), false, this.m_trx.getTrxName()) != -1) break block5;
                this.log.warning("EncryptError [ChangeFieldLength]: ColumnID=" + columnID + ", NewLength=" + length);
                throw new Exception();
            }
            catch (Exception exception) {
                try {
                    this.log.severe(exception.getMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, selectStmt);
                    rs = null;
                    selectStmt = null;
                    throw throwable;
                }
                DB.close(rs, selectStmt);
                rs = null;
                selectStmt = null;
            }
        }
        DB.close(rs, selectStmt);
        rs = null;
        selectStmt = null;
        return ++rowsEffected;
    }
}

