/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.adempiere.core.domains.models.X_T_Aging;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAging;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.process.AgingAbstract;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class Aging
extends AgingAbstract {
    private int statementOffset = 0;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getStatementDate() == null) {
            this.setStatementDate(new Timestamp(System.currentTimeMillis()));
        } else {
            this.statementOffset = TimeUtil.getDaysBetween(new Timestamp(System.currentTimeMillis()), this.getStatementDate(), new int[0]);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("StatementDate=" + this.getStatementDate() + ", IsSOTrx=" + this.isSOTrx() + ", C_Currency_ID=" + this.getCurrencyId() + ", AD_Org_ID=" + this.getOrgId() + ", C_BP_Group_ID=" + this.getBPGroupId() + ", C_BPartner_ID=" + this.getBPartnerId() + ", IsListInvoices=" + this.isListInvoices());
        String dateacct = DB.TO_DATE(this.getStatementDate());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bp.C_BP_Group_ID, oi.C_BPartner_ID,oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID, oi.C_Currency_ID, oi.IsSOTrx, oi.DateInvoiced, oi.NetDays,oi.DueDate,oi.DaysDue, ");
        if (this.getCurrencyId() == 0) {
            if (!this.isDateAcct()) {
                sql.append(" oi.GrandTotal, oi.PaidAmt, oi.OpenAmt ");
            } else {
                sql.append(" oi.GrandTotal, invoicePaidToDate(oi.C_Invoice_ID, oi.C_Currency_ID, 1," + dateacct + ") AS PaidAmt, invoiceOpenToDate(oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID," + dateacct + ") AS OpenAmt ");
            }
        } else {
            String s = ",oi.C_Currency_ID," + this.getCurrencyId() + ",oi.DateAcct,oi.C_ConversionType_ID,oi.AD_Client_ID,oi.AD_Org_ID)";
            sql.append("currencyConvert(oi.GrandTotal").append(s);
            if (!this.isDateAcct()) {
                sql.append(", currencyConvert(oi.PaidAmt").append(s).append(", currencyConvert(oi.OpenAmt").append(s);
            } else {
                sql.append(", currencyConvert(invoicePaidToDate(oi.C_Invoice_ID, oi.C_Currency_ID, 1," + dateacct + ")").append(s).append(", currencyConvert(invoiceOpenToDate(oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID," + dateacct + ")").append(s);
            }
        }
        sql.append(",oi.C_Activity_ID,oi.C_Campaign_ID,oi.C_Project_ID,oi.AD_Org_ID, i.SalesRep_ID ");
        if (!this.isDateAcct()) {
            sql.append(" FROM RV_OpenItem oi");
        } else {
            sql.append(" FROM RV_OpenItemToDate oi");
        }
        sql.append(" INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_Invoice i ON(i.C_Invoice_ID = oi.C_Invoice_ID) WHERE oi.ISSoTrx=").append(this.isSOTrx() ? "'Y'" : "'N'");
        if (this.getBPartnerId() > 0) {
            sql.append(" AND oi.C_BPartner_ID=").append(this.getBPartnerId());
        } else if (this.getBPGroupId() > 0) {
            sql.append(" AND bp.C_BP_Group_ID=").append(this.getBPGroupId());
        }
        if (this.getOrgId() > 0) {
            sql.append(" AND oi.AD_Org_ID=").append(this.getOrgId());
        }
        if (this.isDateAcct()) {
            sql.append(" AND invoiceOpenToDate(oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID," + dateacct + ") <> 0 ");
        }
        if (this.getSalesRepId() > 0) {
            sql.append(" AND i.SalesRep_ID=").append(this.getSalesRepId());
        }
        sql.append(" ORDER BY oi.C_BPartner_ID, oi.C_Currency_ID, oi.C_Invoice_ID");
        this.log.finest(sql.toString());
        String finalSql = MRole.getDefault(this.getCtx(), false).addAccessSQL(sql.toString(), "oi", true, false);
        this.log.finer(finalSql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        PO aging = null;
        int counter = 0;
        int rows = 0;
        int AD_PInstance_ID = this.getAD_PInstance_ID();
        try {
            pstmt = DB.prepareStatement(finalSql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int bussinessPartnerGroupId = rs.getInt(1);
                int businessPartnerId = rs.getInt(2);
                int invoiceId = this.isListInvoices() ? rs.getInt(3) : 0;
                int invoicePayScheduleId = this.isListInvoices() ? rs.getInt(4) : 0;
                int currencyId = rs.getInt(5);
                boolean isSalesTransaction = "Y".equals(rs.getString(6));
                Timestamp dueDate = rs.getTimestamp(9);
                int daysDue = rs.getInt(10) + this.statementOffset;
                BigDecimal grandTotal = rs.getBigDecimal(11);
                BigDecimal openAmt = rs.getBigDecimal(13);
                int activityId = this.isListInvoices() ? rs.getInt(14) : 0;
                int campaignId = this.isListInvoices() ? rs.getInt(15) : 0;
                int projectId = this.isListInvoices() ? rs.getInt(16) : 0;
                int organizationId = rs.getInt(17);
                int salesRepresentativeId = rs.getInt(18);
                ++rows;
                if (aging == null || AD_PInstance_ID != ((X_T_Aging)aging).getAD_PInstance_ID() || businessPartnerId != ((X_T_Aging)aging).getC_BPartner_ID() || currencyId != ((X_T_Aging)aging).getC_Currency_ID() || invoiceId != ((X_T_Aging)aging).getC_Invoice_ID() || invoicePayScheduleId != ((X_T_Aging)aging).getC_InvoicePaySchedule_ID()) {
                    if (aging != null) {
                        aging.saveEx();
                        this.log.fine("#" + ++counter + " - " + (MAging)aging);
                    }
                    aging = new MAging(this.getCtx(), AD_PInstance_ID, this.getStatementDate(), businessPartnerId, currencyId, invoiceId, invoicePayScheduleId, bussinessPartnerGroupId, organizationId, dueDate, isSalesTransaction, this.get_TrxName());
                    ((X_T_Aging)aging).setC_Activity_ID(activityId);
                    ((X_T_Aging)aging).setC_Campaign_ID(campaignId);
                    ((X_T_Aging)aging).setC_Project_ID(projectId);
                    aging.set_ValueOfColumn("C_BankAccount_ID", (Object)0);
                    aging.set_ValueOfColumn("C_CashFlow_ID", (Object)0);
                    ((X_T_Aging)aging).setSalesRep_ID(salesRepresentativeId);
                    ((X_T_Aging)aging).setDateAcct(this.isDateAcct());
                }
                ((MAging)aging).add(dueDate, daysDue, grandTotal, openAmt);
            }
            if (aging != null) {
                aging.saveEx();
                this.log.fine("#" + ++counter + " - " + (MAging)aging);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, finalSql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.log.info("#" + counter + " - rows=" + rows);
        return "";
    }
}

