/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MSysConfig;
import org.compiere.print.util.SerializableMatrix;
import org.compiere.print.util.SwapFile;
import org.compiere.print.util.SwapFileSegment;
import org.compiere.util.CLogger;

public class SerializableMatrixImpl<T extends Serializable>
implements SerializableMatrix<T> {
    private static final int DEFAULT_BLOCK_SIZE = 4096;
    private static final int DEFAULT_SWAP_MAX_ROWS = 2000;
    private static final String REPORT_SWAP_MAX_ROWS = "REPORT_SWAP_MAX_ROWS";
    private static final CLogger log = CLogger.getCLogger(SerializableMatrixImpl.class);
    private ArrayList<List<T>> m_rows = new ArrayList();
    private int m_currentRow = -1;
    private int m_pageSize = 0;
    private int m_size = 0;
    private Page currentPage = null;
    private List<SwapFileSegment> segments = new ArrayList<SwapFileSegment>();
    private List<Page> pages = new ArrayList<Page>();
    private SwapFile swapFile;
    private String prefix;

    public SerializableMatrixImpl(String name) {
        this.prefix = name;
        int pageSize = MSysConfig.getIntValue(REPORT_SWAP_MAX_ROWS, 2000);
        this.m_pageSize = pageSize <= 0 ? Integer.MAX_VALUE : pageSize;
    }

    @Override
    public void addRow(List<T> data) {
        ++this.m_size;
        if (this.currentPage == null) {
            this.currentPage = new Page();
            this.pages.add(this.currentPage);
            this.currentPage.first = 0;
            this.currentPage.last = 0;
            this.currentPage.size = 1;
            this.currentPage.pageNo = this.pages.size() - 1;
            this.m_rows.add(data);
            this.m_currentRow = 0;
        } else {
            Page lastPage = this.pages.get(this.pages.size() - 1);
            if (lastPage.size == this.m_pageSize) {
                this.pageout(this.currentPage);
                this.currentPage = new Page();
                this.pages.add(this.currentPage);
                this.currentPage.pageNo = this.pages.size() - 1;
                this.currentPage.last = this.currentPage.first = lastPage.last + 1;
                this.currentPage.size = 1;
                this.m_rows = new ArrayList();
                this.m_rows.add(data);
                this.m_currentRow = this.currentPage.first;
            } else {
                if (this.currentPage.pageNo != lastPage.pageNo) {
                    this.pageout(this.currentPage);
                    this.pagein(lastPage.pageNo);
                }
                this.m_rows.add(data);
                ++this.currentPage.last;
                ++this.currentPage.size;
                this.m_currentRow = this.currentPage.last;
            }
        }
    }

    @Override
    public boolean setRowIndex(int row) {
        if (row < 0 || row >= this.m_size) {
            return false;
        }
        if (row >= this.currentPage.first && row <= this.currentPage.last) {
            this.m_currentRow = row;
            return true;
        }
        Page tmp = this.currentPage;
        for (Page page : this.pages) {
            if (row < page.first || row > page.last) continue;
            this.currentPage = page;
            this.pageout(tmp);
            this.pagein(this.currentPage.pageNo);
            this.m_currentRow = row;
            return true;
        }
        return false;
    }

    @Override
    public boolean setRowNext() {
        return this.setRowIndex(this.m_currentRow + 1);
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public int getRowIndex() {
        return this.m_currentRow;
    }

    @Override
    public List<T> getRowData() {
        return this.m_rows.isEmpty() ? null : this.m_rows.get(this.m_currentRow - this.currentPage.first);
    }

    @Override
    public void setRowData(List<T> data) {
        int index;
        if (this.currentPage != null && (index = this.m_currentRow - this.currentPage.first) < this.m_rows.size()) {
            this.m_rows.set(index, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageout(Page currentPage) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        try {
            ObjectOutputStream ous = new ObjectOutputStream(bas);
            ous.writeObject(this.m_rows);
            if (this.swapFile == null) {
                this.swapFile = new SwapFile(this.makePrefix(this.prefix), 4096, 2);
            }
            this.swapFile.open();
            SwapFileSegment segment = this.swapFile.write(bas.toByteArray());
            if (currentPage.pageNo < this.segments.size()) {
                this.segments.set(currentPage.pageNo, segment);
            } else {
                this.segments.add(segment);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            if (this.swapFile != null) {
                this.swapFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pagein(int index) {
        SwapFileSegment segment = this.segments.get(index);
        try {
            ArrayList rows;
            this.swapFile.open();
            byte[] data = this.swapFile.read(segment);
            this.swapFile.free(segment);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            this.m_rows = rows = (ArrayList)ois.readObject();
            this.currentPage = this.pages.get(index);
            this.m_currentRow = this.currentPage.first;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            this.swapFile.close();
        }
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuffer prefix = new StringBuffer();
        for (char ch : nameArray = name.toCharArray()) {
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
                continue;
            }
            prefix.append("_");
        }
        return prefix.toString();
    }

    class Page {
        protected int pageNo;
        protected int first;
        protected int last;
        protected int size;

        Page() {
        }
    }
}

